/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.swing;

import java.awt.Component;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jpos.SP;
import jpos.ui.UIConstants;

public class BDefTblCellCheckBoxRenderer
extends JCheckBox
implements TableCellRenderer,
Serializable {
    static ResourceBundle res = ResourceBundle.getBundle("TransJavaCommon");
    private static ImageIcon iconChecked = new ImageIcon(SP.sParams.imagepath + "tick32x32.png");
    private static ImageIcon iconUnchecked = new ImageIcon(SP.sParams.imagepath + "unchecked.png");

    public BDefTblCellCheckBoxRenderer() {
        this.setOpaque(true);
        this.setBorderPainted(true);
        this.setHorizontalAlignment(0);
        this.setSelected(false);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(table.getForeground());
            super.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIConstants.TABLE_SELECTED_CELL_BORDER);
        } else {
            this.setBorder(UIConstants.TABLE_CELL_BORDER);
        }
        this.setValue(value);
        return this;
    }

    protected void setValue(Object value) {
        boolean selected = false;
        if (value instanceof Boolean) {
            selected = (Boolean)value;
        } else if (value instanceof String) {
            selected = value.equals("true");
        }
        this.setSelected(selected);
    }

    private void toggleIcon(boolean selected) {
        if (selected) {
            this.setIcon(iconChecked);
        } else {
            this.setIcon(iconUnchecked);
        }
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.toggleIcon(selected);
    }
}

