/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import jpos.basscom.swing.BJButtonCan;
import jpos.basscom.swing.BJButtonOk;
import jpos.basscom.swing.event.BSaveListener;
import jpos.basscom.utils.Utils;

public class BJDialog
extends JDialog
implements KeyEventDispatcher {
    protected boolean bivEditMsgToParent = true;
    protected long nivKey;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel1;
    private FlowLayout flowLayout1 = new FlowLayout();
    private BJButtonOk jbOk;
    private BJButtonCan jbCancel;
    private transient Vector<BSaveListener> BSaveListeners;

    public BJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    public BJDialog(Dialog parent, String title, boolean modal) {
        super(parent, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    public BJDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.jPanel1 = new JPanel();
        this.jbOk = new BJButtonOk();
        this.jbCancel = new BJButtonCan();
        this.jbOk.setActionCommand("jbOk");
        this.jbOk.setEnabled(false);
        this.jbOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BJDialog.this.actionEnter();
            }
        });
        this.jbOk.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    BJDialog.this.actionEnter();
                }
            }
        });
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        this.jbCancel.setMaximumSize(new Dimension(70, 33));
        this.jbCancel.setActionCommand("jbCancel");
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BJDialog.this.actionNotifyChange()) {
                    BJDialog.this.actionClose();
                }
            }
        });
        this.jbCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && BJDialog.this.actionNotifyChange()) {
                    BJDialog.this.actionClose();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (!(e.getComponent() instanceof JTextArea)) {
                        BJDialog.this.actionEnter();
                    }
                } else if (e.getKeyCode() == 27) {
                    BJDialog.this.actionClose();
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (BJDialog.this.actionNotifyChange()) {
                    BJDialog.this.actionClose();
                }
            }
        });
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.flowLayout1);
        this.jPanel1.setMinimumSize(new Dimension(150, 45));
        this.jPanel1.setPreferredSize(new Dimension(150, 45));
        this.flowLayout1.setVgap(10);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add(this.jbOk);
        this.jPanel1.add(this.jbCancel);
    }

    public void setEditMsgToParent(boolean bEditMsgToParent) {
        this.bivEditMsgToParent = bEditMsgToParent;
    }

    public boolean getEditMsgToParent() {
        return this.bivEditMsgToParent;
    }

    protected void fireSuperJbInit() {
        this.jbOk.setEnabled(false);
    }

    @Override
    public void dispose() {
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        super.dispose();
    }

    protected void actionPopulate(long key) {
    }

    protected void actionSave(long key) {
    }

    protected void actionClose() {
        this.dispose();
    }

    public void actionEnter() {
        this.fireActionSave(this.nivKey);
        this.actionClose();
    }

    public boolean actionEdit() {
        if (!this.bivEditMsgToParent) {
            this.jbOk.setEnabled(true);
            return true;
        }
        Container parent = this.getParent();
        if (parent != null && parent instanceof BJDialog && !((BJDialog)parent).actionEdit()) {
            return false;
        }
        this.jbOk.setEnabled(true);
        return true;
    }

    protected boolean actionNotifyChange() {
        return true;
    }

    protected void actionNoSave() {
    }

    public long getKey() {
        return this.nivKey;
    }

    public void setKey(long key) {
        this.nivKey = key;
    }

    public void setButtonEnable(int nIndex, boolean bEnable) {
        if (nIndex == 0) {
            this.jbOk.setEnabled(bEnable);
        } else {
            this.jbCancel.setEnabled(bEnable);
        }
    }

    public JButton getOkButton() {
        return this.jbOk;
    }

    public JButton getCancelButton() {
        return this.jbCancel;
    }

    public synchronized void addBSaveListener(BSaveListener l) {
        if (this.BSaveListeners == null) {
            this.BSaveListeners = new Vector(2);
        }
        if (!this.BSaveListeners.contains(l)) {
            this.BSaveListeners.addElement(l);
        }
    }

    protected void fireActionSave(long key) {
        if (this.BSaveListeners != null) {
            for (BSaveListener l : this.BSaveListeners) {
                l.actionSave(key);
            }
        }
    }

    protected void fireActionNoSave(long key) {
        if (this.BSaveListeners != null) {
            for (BSaveListener l : this.BSaveListeners) {
                l.actionNoSave(key);
            }
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isActive()) {
            this.processKeyEvent(e);
        }
        return false;
    }
}

