/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.utils;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import jpos.basscom.utils.Utils;
import jpos.basscom.utils.Xmls;

public class MultiResultSetBuilderXmls {
    private ResultSet rs;
    private ResultSetMetaData rsmd;
    protected SQLException exception;
    private Map<String, String> names = new HashMap<String, String>();
    private Map<String, Boolean> attribs = new HashMap<String, Boolean>();
    private Map<String, Boolean> esc_crlf = new HashMap<String, Boolean>();
    int maxRows = Integer.MAX_VALUE;
    private String rowName = "entry";
    private boolean bDoSav = true;
    private Xmls[] entry;
    private Xmls equalXml;
    private int[] eleCompare;
    private int[] eleStart;
    private int[] eleEnd;
    private String[] eleName;
    private int levels;
    private int nextLev = 0;
    private int colCount;
    private String[] columnName;
    private int[] equalBuildEntries;
    private MultiResultSetBuilderXmls[][] equalBuild;
    private int[][] equalBuildCol;
    private Statement[][] equalBuildStmt;
    private String[][] equalBuildSql;
    private String[][] equalBuildWhere;
    private String[][] equalBuildOrder;
    private String[] vals;
    private String[] oldVals;
    private boolean[] rswasNull;
    private int rowCount = 0;
    private int flushRowCount = 0;
    private int flushAfterCount = 0;
    private boolean equalBuildOn = false;
    private boolean anyRows = true;

    public MultiResultSetBuilderXmls(ResultSet rs, int levels) {
        this.rs = rs;
        try {
            int index;
            this.rsmd = rs.getMetaData();
            this.levels = levels;
            this.entry = new Xmls[levels];
            this.eleCompare = new int[levels];
            this.eleStart = new int[levels];
            this.eleEnd = new int[levels];
            this.eleName = new String[levels];
            this.colCount = this.rsmd.getColumnCount();
            if (levels == 1) {
                this.eleCompare[0] = 0;
                this.eleStart[0] = 1;
                this.eleEnd[0] = this.colCount;
            }
            this.columnName = new String[this.colCount];
            this.rswasNull = new boolean[this.colCount];
            this.vals = new String[this.colCount];
            this.oldVals = new String[this.colCount];
            for (index = 0; index < this.colCount; ++index) {
                this.oldVals[index] = null;
            }
            this.eleName[0] = this.rowName;
            for (index = 0; index < this.colCount; ++index) {
                this.columnName[index] = this.rsmd.getColumnName(index + 1);
            }
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public boolean build(Xmls root) throws SQLException, IOException {
        try {
            return this.build(root, null, 0);
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public boolean build(Xmls root, Writer flush, int flushrows) throws SQLException, IOException {
        this.flushAfterCount = flushrows;
        boolean bLevelChanged = false;
        boolean bCompare = false;
        try {
            if (this.rowCount == 0) {
                this.anyRows = this.rs.next();
            } else if (!this.anyRows) {
                return false;
            }
            while (this.anyRows && this.rowCount++ < this.maxRows) {
                ++this.flushRowCount;
                for (int col = 1; col <= this.colCount; ++col) {
                    this.vals[col - 1] = this.rs.getString(col);
                    this.rswasNull[col - 1] = this.rs.wasNull();
                    if (this.esc_crlf.isEmpty() || !this.isEsc_crlf(col + "") || this.rswasNull[col - 1]) continue;
                    this.vals[col - 1] = Utils.stringReplace(this.vals[col - 1], "\r\n", "\u0004");
                }
                for (int idx = 0; idx < this.levels; ++idx) {
                    if (this.levels == 1) {
                        try {
                            this.savOld(idx, root, flush);
                        }
                        catch (IOException e) {
                            throw new IOException(e.getMessage());
                        }
                        this.createEle(idx);
                        continue;
                    }
                    bLevelChanged = false;
                    bCompare = true;
                    if (this.vals[this.eleCompare[idx]] == null && this.oldVals[this.eleCompare[idx]] == null) {
                        bLevelChanged = false;
                        bCompare = false;
                    }
                    if (this.vals[this.eleCompare[idx]] == null && this.oldVals[this.eleCompare[idx]] != null) {
                        bLevelChanged = true;
                        bCompare = false;
                    }
                    if (this.vals[this.eleCompare[idx]] != null && this.oldVals[this.eleCompare[idx]] == null) {
                        bLevelChanged = true;
                        bCompare = false;
                    }
                    if (bCompare && !this.vals[this.eleCompare[idx]].equals(this.oldVals[this.eleCompare[idx]])) {
                        bLevelChanged = true;
                    }
                    if (!bLevelChanged) continue;
                    try {
                        this.savOld(idx, root, flush);
                    }
                    catch (IOException e) {
                        throw new IOException(e.getMessage());
                    }
                    for (int cre = idx; cre < this.levels; ++cre) {
                        this.createEle(cre);
                    }
                    break;
                }
                this.anyRows = this.rs.next();
            }
            ++this.rowCount;
            try {
                this.savOld(0, root, flush);
                return true;
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
    }

    private void savOld(int savlevel, Xmls root, Writer flush) throws IOException, SQLException {
        if (this.rowCount > 1 & this.bDoSav) {
            for (int lvl = this.levels - 1; lvl >= savlevel; --lvl) {
                if (this.equalBuildOn && this.equalBuildCol.length > lvl) {
                    for (int i = 0; i < this.equalBuildEntries[lvl]; ++i) {
                        if (this.equalBuildCol[lvl][i] <= -1) continue;
                        try {
                            this.equalBuild[lvl][i].reExecQuery(this.equalBuildStmt[lvl][i], this.equalBuildSql[lvl][i] + this.equalBuildWhere[lvl][i] + this.oldVals[this.equalBuildCol[lvl][i] - 1] + this.equalBuildOrder[lvl][i]);
                        }
                        catch (SQLException e) {
                            throw new SQLException(e.getMessage());
                        }
                        this.equalBuild[lvl][i].build(this.equalXml);
                        this.entry[lvl].addContent(this.equalXml);
                        this.equalXml.clear();
                    }
                }
                this.entry[lvl].endEle(this.eleName[lvl].toLowerCase());
                if (lvl > 0) {
                    this.entry[lvl - 1].addContent(this.entry[lvl]);
                } else {
                    root.addContent(this.entry[lvl]);
                }
                this.entry[lvl].clear();
            }
        }
        for (int col = 1; col <= this.colCount; ++col) {
            this.oldVals[col - 1] = this.vals[col - 1];
        }
        if (savlevel == 0 && this.flushAfterCount > 0 && this.flushRowCount > this.flushAfterCount) {
            try {
                flush.write(root.getXML());
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            root.clear();
            this.flushRowCount = 0;
        }
        this.bDoSav = true;
    }

    private void createEle(int idx) throws SQLException {
        String aname;
        int col;
        boolean bContinue = false;
        for (int col2 = this.eleStart[idx]; col2 <= this.eleEnd[idx]; ++col2) {
            if (this.rswasNull[col2 - 1]) continue;
            bContinue = true;
            break;
        }
        if (this.entry[idx] == null) {
            this.entry[idx] = new Xmls(this.eleName[idx].toLowerCase(), true);
            this.entry[idx].setSeperator();
        } else {
            this.entry[idx].stEleOpen(this.eleName[idx].toLowerCase());
        }
        for (col = this.eleStart[idx]; col <= this.eleEnd[idx]; ++col) {
            String name = this.names.isEmpty() ? this.columnName[col - 1].toLowerCase() : this.lookupName(this.columnName[col - 1]).toLowerCase();
            aname = this.columnName[col - 1].toLowerCase();
            if (this.attribs.isEmpty() || !this.isAttribute(aname) || !bContinue) continue;
            this.entry[idx].attr(this.lookupName(this.columnName[col - 1].toLowerCase()), this.vals[col - 1]);
        }
        this.entry[idx].stEleClose();
        for (col = this.eleStart[idx]; col <= this.eleEnd[idx]; ++col) {
            String name = this.names.isEmpty() ? this.columnName[col - 1].toLowerCase() : this.lookupName(this.columnName[col - 1]).toLowerCase();
            aname = this.columnName[col - 1].toLowerCase();
            if (!this.attribs.isEmpty() && this.isAttribute(aname)) continue;
            this.entry[idx].totEle(name, this.vals[col - 1]);
        }
    }

    private String lookupName(String origName) {
        String name = this.names.get(origName.toLowerCase());
        if (name != null) {
            return name;
        }
        return origName;
    }

    private boolean isAttribute(String origName) {
        Boolean val = this.attribs.get(origName.toLowerCase());
        return val == Boolean.TRUE;
    }

    private boolean isEsc_crlf(String colNum) {
        Boolean val = this.esc_crlf.get(colNum);
        return val == Boolean.TRUE;
    }

    public void setRowName(String rowName) {
        this.rowName = rowName;
        this.eleName[0] = rowName;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setdoSav(boolean doSav) {
        this.bDoSav = doSav;
    }

    public void setAsAttribute(String columnName) {
        this.attribs.put(columnName.toLowerCase(), Boolean.TRUE);
    }

    public void setAsEsc_crlf(String colNum) {
        this.esc_crlf.put(colNum, Boolean.TRUE);
    }

    public void setAsAttributeAll() {
        for (int idx = 0; idx < this.colCount; ++idx) {
            this.attribs.put(this.columnName[idx].toLowerCase(), Boolean.TRUE);
        }
    }

    public void setAsAttribute(String columnName, String attribName) {
        this.attribs.put(columnName.toLowerCase(), Boolean.TRUE);
        this.names.put(columnName.toLowerCase(), attribName);
    }

    public void setAsAttribute(int columnNum) {
        try {
            String name = this.rsmd.getColumnName(columnNum).toLowerCase();
            this.attribs.put(name, Boolean.TRUE);
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public void setAsAttribute(int columnNum, String attribName) {
        try {
            String name = this.rsmd.getColumnName(columnNum).toLowerCase();
            this.attribs.put(name, Boolean.TRUE);
            this.names.put(name, attribName);
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public void setAsElement(String columnName, String elemName) {
        String name = columnName.toLowerCase();
        this.attribs.put(name, Boolean.FALSE);
        this.names.put(name, elemName);
    }

    public void setAsElement(String columnName) {
        String name = columnName.toLowerCase();
        this.attribs.put(name, Boolean.FALSE);
    }

    public void setAsElement(int columnNum, String elemName) {
        try {
            String name = this.rsmd.getColumnName(columnNum).toLowerCase();
            this.attribs.put(name, Boolean.FALSE);
            this.names.put(name, elemName);
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public void setAsElement(int columnNum) {
        try {
            String name = this.rsmd.getColumnName(columnNum).toLowerCase();
            this.attribs.put(name, Boolean.FALSE);
        }
        catch (SQLException e) {
            this.exception = e;
        }
    }

    public void setNewLevel(int compareAt, int startAt, int endAt, String eleName) {
        this.eleCompare[this.nextLev] = compareAt - 1;
        this.eleStart[this.nextLev] = startAt;
        this.eleEnd[this.nextLev] = endAt;
        this.eleName[this.nextLev] = eleName;
        ++this.nextLev;
    }

    public void setNewLevel(int compareAt, int endAt, String eleName) {
        this.setNewLevel(compareAt, compareAt, endAt, eleName);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void reExecQuery(Statement stmt, String sql) throws SQLException {
        try {
            this.rs = stmt.executeQuery(sql);
            for (int index = 0; index < this.colCount; ++index) {
                this.oldVals[index] = null;
            }
            this.rowCount = 0;
            this.bDoSav = true;
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void showit(String sShow) {
        System.out.println(sShow);
    }
}

