/*
 * Decompiled with CFR 0.152.
 */
package jpos.capillary;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jpos.RestRequest;
import jpos.SP;
import jpos.Settings;
import jpos.capillary.CapillaryLoyaltySetup;
import jpos.capillary.CapillaryRedeemRequest;
import jpos.capillary.CapillaryRequest;
import jpos.capillary.CapillaryResult;
import jpos.capillary.CapillaryReverseRedeemRequest;
import jpos.capillary.CapillaryReverseRedeemResult;
import jpos.capillary.CapillaryUtils;

public class CapillaryAPI {
    private String baseURL;
    private String username;
    private String password;
    private String apiAuthVersion1;
    private String apiAuthVersion2;
    private String capillaryRedemptionId;
    private String lastError;
    private Map<String, String> authHeader;
    private Map<String, String> params;

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getUsername() {
        return this.username;
    }

    protected CapillaryAPI() {
        CapillaryLoyaltySetup setup = new CapillaryLoyaltySetup();
        this.baseURL = RestRequest.formatBaseURL(setup.getLoyaltyApiUrl());
        this.username = setup.getUsername();
        this.password = setup.getPassword();
        this.apiAuthVersion1 = setup.getApiAuthVersion1();
        this.apiAuthVersion2 = setup.getApiAuthVersion2();
    }

    protected boolean requestBalance(String externalId) {
        this.setAuthHeader();
        this.setParams(RequestType.REQUEST_BALANCE, externalId);
        RestRequest restRequest = new RestRequest();
        RestRequest.Response result = null;
        try {
            result = restRequest.get(this.baseURL + "/" + this.apiAuthVersion1 + "/customer/get", this.params, this.authHeader);
        }
        catch (IOException e) {
            this.lastError = SP.getRS("capillary_failed_GetBalance");
            return false;
        }
        CapillaryResult resultJson = null;
        Gson gson = new Gson();
        try {
            resultJson = (CapillaryResult)gson.fromJson(result.Content, CapillaryResult.class);
        }
        catch (JsonSyntaxException e) {
            this.lastError = SP.getRS("capillary_failed_GetBalance");
            return false;
        }
        if (!result.isSuccess()) {
            this.lastError = SP.getRS("capillary_failed_authentication") + ": " + resultJson.response.status.message;
            return false;
        }
        return true;
    }

    protected boolean requestRedeem(String cardNumber, long staffId, double points) {
        this.setAuthHeader();
        this.setParams(RequestType.REQUEST_REDEEM, cardNumber);
        RestRequest restRequest = new RestRequest();
        CapillaryRequest request = this.getRequest(RequestType.REQUEST_REDEEM, cardNumber, points);
        RestRequest.Response result = null;
        try {
            restRequest.setPostJson(request);
            if (Settings.isLogCapillaryPayloads()) {
                CapillaryUtils.LogCapillaryPayload(true, request);
            }
            result = restRequest.post(this.baseURL + "/" + this.apiAuthVersion1 + "/points/redeem", this.params, this.authHeader);
        }
        catch (IOException e) {
            this.lastError = SP.getRS("capillary_failed_PostRedemption");
            return false;
        }
        CapillaryResult resultJson = null;
        Gson gson = new Gson();
        try {
            resultJson = (CapillaryResult)gson.fromJson(result.Content, CapillaryResult.class);
        }
        catch (JsonSyntaxException e) {
            this.lastError = SP.getRS("capillary_failed_ParseRedemption");
            return false;
        }
        if (Settings.isLogCapillaryPayloads()) {
            CapillaryUtils.LogCapillaryPayload(false, resultJson);
        }
        if (!result.isSuccess() && !resultJson.response.status.success) {
            this.lastError = resultJson.response.status.message;
            return false;
        }
        this.capillaryRedemptionId = resultJson.response.responses.points.redemption_id;
        return resultJson.response.status.success;
    }

    protected boolean requestReverse(String cardNumber, String transactionId) {
        this.setAuthHeader();
        RestRequest restRequest = new RestRequest();
        CapillaryReverseRedeemRequest request = new CapillaryReverseRedeemRequest();
        request.redemptionId = transactionId;
        request.identifier.type = "externalId";
        request.identifier.value = cardNumber;
        RestRequest.Response result = null;
        try {
            restRequest.setPostJson(request);
            if (Settings.isLogCapillaryPayloads()) {
                CapillaryUtils.LogCapillaryPayload(true, request);
            }
            result = restRequest.post(this.baseURL + "/" + this.apiAuthVersion2 + "/points/reverse", null, this.authHeader);
        }
        catch (IOException e) {
            this.lastError = SP.getRS("capillary_failed_ReverseRedemption");
            return false;
        }
        CapillaryReverseRedeemResult resultJson = null;
        Gson gson = new Gson();
        try {
            resultJson = (CapillaryReverseRedeemResult)gson.fromJson(result.Content, CapillaryReverseRedeemResult.class);
        }
        catch (JsonSyntaxException e) {
            this.lastError = SP.getRS("capillary_failed_ReverseRedemption");
            return false;
        }
        if (Settings.isLogCapillaryPayloads()) {
            CapillaryUtils.LogCapillaryPayload(false, resultJson);
        }
        if (resultJson.errors != null && resultJson.errors.size() > 0) {
            this.lastError = "";
            for (int i = 0; i < resultJson.errors.size(); ++i) {
                this.lastError = this.lastError + "\n" + resultJson.errors.get((int)i).code + " " + resultJson.errors.get((int)i).message;
            }
            return false;
        }
        return result.isSuccess();
    }

    private void setAuthHeader() {
        this.authHeader = new HashMap<String, String>();
        this.authHeader.put("authorization", "Basic " + CapillaryUtils.getEncodeBasicAuth(this.username, this.password, true));
        this.authHeader.put("Accept", "application/json");
    }

    private void setParams(RequestType requestType, String externalId) {
        this.params = new HashMap<String, String>();
        switch (requestType) {
            case REQUEST_BALANCE: {
                this.params.put("mobile", externalId);
                this.params.put("mlp", "true");
                break;
            }
            case REQUEST_REDEEM: {
                this.params.put("format", "json");
                break;
            }
        }
    }

    private CapillaryRequest getRequest(RequestType requestType, String externalId, double points) {
        CapillaryRequest capillaryRequest = new CapillaryRequest();
        switch (requestType) {
            case REQUEST_REDEEM: {
                CapillaryRedeemRequest redeemRequest = new CapillaryRedeemRequest();
                redeemRequest.root = new CapillaryRedeemRequest.CapillaryRedeemRoot(redeemRequest);
                CapillaryRedeemRequest.Redeem redeem = new CapillaryRedeemRequest.Redeem(redeemRequest);
                CapillaryRequest.CapillaryRequestCustomer redeemCust = new CapillaryRequest.CapillaryRequestCustomer(capillaryRequest);
                redeemCust.external_id = externalId;
                redeem.customer = redeemCust;
                redeem.points_redeemed = points;
                redeemRequest.root.redeem.add(redeem);
                capillaryRequest = redeemRequest;
                break;
            }
        }
        return capillaryRequest;
    }

    protected String getLastError() {
        return this.lastError;
    }

    protected String getRedemptionId() {
        return this.capillaryRedemptionId;
    }

    private static enum RequestType {
        REQUEST_BALANCE,
        REQUEST_REDEEM;

    }
}

