/*
 * Decompiled with CFR 0.152.
 */
package jpos.crypt;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JDialog;
import jpos.DlgMessage;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.basscom.utils.CryptoUtils;
import jpos.crypt.DlgPrompt;
import jpos.crypt.StringTransform;
import org.jdom.Element;

public class PersonCrypt
implements AutoCloseable {
    public static final String HASH_HMAC_ALGORITHM = "HmacSHA256";
    public static final String EMAIL_INDEX_NAME = "EMAIL";
    public static final StringTransform EMAIL_TRANSFORM_NO_DOMAIN = new StringTransform("NoDomain", StringTransform.createRegexReplaceOperation("@.*$", ""));
    public static final StringTransform[] EMAIL_TRANSFORMS = new StringTransform[]{StringTransform.NO_TRANSFORMATION, EMAIL_TRANSFORM_NO_DOMAIN};
    public static final String PHONE_INDEX_NAME = "PHONE";
    public static final StringTransform PHONE_TRANSFORM_LAST9 = new StringTransform("Last9", StringTransform.createRegexReplaceOperation("\\W+", ""), StringTransform.createLastXCharactersOperation(9));
    public static final StringTransform PHONE_TRANSFORM_LAST8 = new StringTransform("Last8", StringTransform.createRegexReplaceOperation("\\W+", ""), StringTransform.createLastXCharactersOperation(8));
    public static final StringTransform[] PHONE_TRANSFORMS = new StringTransform[]{PHONE_TRANSFORM_LAST9, PHONE_TRANSFORM_LAST8};
    private static PersonCrypt instance;
    private CryptoUtils.AESKey key;
    private boolean requestOfflineKey = true;
    private Map<Object, Runnable> acquiredActions = new Hashtable<Object, Runnable>();

    public void setRequestOfflineKey(boolean requestOfflineKey) {
        this.requestOfflineKey = requestOfflineKey;
    }

    public boolean getRequestOfflineKey() {
        return this.requestOfflineKey;
    }

    public boolean acquireKey(PosFrame parent) {
        return this.acquireKey(parent, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean acquireKey(PosFrame parentFrame, JDialog parentDialog) {
        Element keyResult;
        String base64Key;
        Window parent;
        if (this.keyExists()) {
            return true;
        }
        Window window = parent = parentDialog != null ? parentDialog : parentFrame;
        if (SP.sParams.checkIConn() && !StringUtils.isNullOrEmpty(base64Key = XMLUtils.getValue(keyResult = SP.sParams.OnlineQueryProvider.getOnlineQuery("person_key", "", false).getXML(), "key"))) {
            try {
                this.setKey(Base64.getMimeDecoder().decode(base64Key));
                this.doAcquiredActions();
                return true;
            }
            catch (IllegalArgumentException e) {
                DlgMessage.showMessage(parent, SP.getRS("Online_Person_Key_Invalid"), SP.getRS("Error"), 0);
            }
        }
        if (!this.requestOfflineKey) return false;
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT SALT, KEY FROM STORE_OFFLINE WHERE WIDX = ?", SP.sParams.getStoreIdx());){
            if (!qry.next()) {
                if (parent != null) {
                    DlgMessage.showMessage(parent, SP.getRS("No_Person_Key_Password"), SP.getRS("Error"), 0);
                    this.setRequestOfflineKey(false);
                }
                boolean bl = false;
                return bl;
            }
            String salt = qry.getString("SALT");
            byte[] encryptedKey = qry.getBytes("KEY");
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
        while (true) {
            DlgPrompt prompt;
            if (parentDialog != null) {
                prompt = new DlgPrompt(parentFrame, parentDialog, SP.getRS("Offline_Key_Title"), SP.getRS("Offline_Key_Prompt", "\n"), DlgPrompt.Buttons.OK_CANCEL_IGNORE, true);
            } else {
                if (parentFrame == null) return false;
                prompt = new DlgPrompt(parentFrame, SP.getRS("Offline_Key_Title"), SP.getRS("Offline_Key_Prompt", "\n"), DlgPrompt.Buttons.OK_CANCEL_IGNORE, true);
            }
            prompt.addIgnoreAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PersonCrypt.this.setRequestOfflineKey(false);
                }
            });
            prompt.setVisible(true);
            if (!prompt.getUserAccepted()) {
                return false;
            }
            try {
                void var5_5;
                void var4_4;
                byte[] hashKey = CryptoUtils.generateAESKeyFromPassword(prompt.getUserInput(), (String)var4_4);
                byte[] key = CryptoUtils.decryptAES((byte[])var5_5, hashKey);
                this.setKey(key);
                Arrays.fill(hashKey, (byte)0);
                Arrays.fill(key, (byte)0);
                this.doAcquiredActions();
                return true;
            }
            catch (GeneralSecurityException e) {
                DlgMessage.showMessage(parent, SP.getRS("Invalid_Password"), SP.getRS("Error"), 0);
                continue;
            }
            break;
        }
    }

    public boolean keyExists() {
        return this.key != null;
    }

    public void setKey(byte[] key) {
        if (this.keyExists()) {
            this.key.dispose();
            this.key = null;
        }
        this.key = new CryptoUtils.AESKey(key);
    }

    public String getContactWhere(String tableAlias, String searchText, Connection conn) {
        List<String> peridxs;
        if (StringUtils.isNullOrEmpty(searchText)) {
            return "";
        }
        StringBuilder searchClause = new StringBuilder();
        if (searchText.contains("@")) {
            peridxs = this.searchEmail(conn, searchText);
            this.searchPersonOfflineEmail(searchText, peridxs, conn);
        } else {
            peridxs = this.searchPhone(conn, searchText);
            this.searchPersonOfflinePhone(searchText, peridxs, conn);
        }
        if (peridxs.size() > 0) {
            searchClause.append(" AND ( ");
            for (int i = 0; i < peridxs.size(); i += 1000) {
                if (i > 0) {
                    searchClause.append(" OR ");
                }
                searchClause.append(" " + tableAlias + ".PERIDX IN (" + String.join((CharSequence)",", peridxs.subList(i, Math.min(i + 1000, peridxs.size()))) + ") ");
            }
        } else {
            return " AND 1=2 ";
        }
        searchClause.append(" ) ");
        return searchClause.toString();
    }

    private void searchPersonOfflinePhone(String inText, List<String> searchPeridxs, Connection conn) {
        String text = PosUtils.StringToSqlString(inText.toLowerCase().substring(Math.max(0, inText.length() - 8), inText.length()));
        try (SqlQuery sql = new SqlQuery(conn, " SELECT PERIDX FROM PERSON_OFFLINE WHERE RIGHT(lower(MAIN_PHONE),8) = " + text + " ");){
            while (sql.next()) {
                String peridx = sql.getString("peridx");
                if (searchPeridxs.contains(peridx)) continue;
                searchPeridxs.add(peridx);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void searchPersonOfflineEmail(String inText, List<String> searchPeridxs, Connection conn) {
        String text = PosUtils.StringToSqlString(EMAIL_TRANSFORM_NO_DOMAIN.transform(inText.toLowerCase()));
        try (SqlQuery sql = new SqlQuery(conn, " SELECT PERIDX FROM PERSON_OFFLINE WHERE LEFT(lower(EMAIL),position('@', lower(EMAIL)) - 1) = " + text + " ");){
            while (sql.next()) {
                String peridx = sql.getString("peridx");
                if (searchPeridxs.contains(peridx)) continue;
                searchPeridxs.add(peridx);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public List<String> searchEmail(Connection conn, String inputEmail) {
        return this.searchBlindIndex(conn, inputEmail, EMAIL_INDEX_NAME, EMAIL_TRANSFORMS);
    }

    public List<String> searchPhone(Connection conn, String inputPhone) {
        return this.searchBlindIndex(conn, inputPhone, PHONE_INDEX_NAME, PHONE_TRANSFORMS);
    }

    public List<String> searchEmail(Connection conn, String inputEmail, StringTransform transformation) {
        return this.searchBlindIndex(conn, inputEmail, EMAIL_INDEX_NAME, new StringTransform[]{transformation});
    }

    public List<String> searchPhone(Connection conn, String inputPhone, StringTransform transformation) {
        return this.searchBlindIndex(conn, inputPhone, PHONE_INDEX_NAME, new StringTransform[]{transformation});
    }

    private List<String> searchBlindIndex(Connection conn, String input, String indexName, StringTransform[] transformations) {
        ArrayList<String> results = new ArrayList<String>();
        if (StringUtils.isNullOrEmpty(input = this.cleanIndexInput(input))) {
            return results;
        }
        if (this.key == null || this.key.getAuthKey() == null) {
            PosUtils.logError("No key available to search blind indexes");
            return results;
        }
        for (StringTransform transform : transformations) {
            String transformed = transform.transform(input);
            if (StringUtils.isNullOrEmpty(transformed)) continue;
            try (SqlQuery query = new SqlQuery(conn, "SELECT IDX FROM BLIND_INDEX WHERE HASH = ? AND INDEX_NAME = ? AND TRANSFORM = ?", this.generateIndexHash(transformed), indexName, transform.getName());){
                while (query.next()) {
                    results.add(query.getString("IDX"));
                }
            }
            catch (GeneralSecurityException | SQLException e) {
                PosUtils.logError(e);
            }
            if (results.isEmpty()) continue;
            return results;
        }
        return results;
    }

    public void generateBlindIndexes(Connection conn, String indexName, long indexKey, String decryptedData, StringTransform ... transformations) throws SQLException, GeneralSecurityException {
        String value = this.cleanIndexInput(decryptedData);
        if (StringUtils.isNullOrEmpty(value)) {
            SqlQuery.executeUpdate(conn, "DELETE FROM BLIND_INDEX WHERE IDX = ? AND INDEX_NAME = ?", indexKey, indexName);
            return;
        }
        for (int i = 0; i < transformations.length; ++i) {
            StringTransform transform = transformations[i];
            String transformed = transform.transform(value);
            if (!StringUtils.isNullOrEmpty(transformed)) {
                String hash = this.generateIndexHash(transformed);
                SqlQuery.executeUpdate(conn, "UPDATE OR INSERT INTO BLIND_INDEX(HASH, IDX, INDEX_NAME, TRANSFORM) VALUES (?, ?, ?, ?) MATCHING (IDX, INDEX_NAME, TRANSFORM)", hash, indexKey, indexName, transform.getName());
                continue;
            }
            SqlQuery.executeUpdate(conn, "DELETE FROM BLIND_INDEX WHERE IDX = ? AND INDEX_NAME = ? AND TRANSFORM = ?", indexKey, indexName, transform.getName());
        }
    }

    private String cleanIndexInput(String input) {
        return StringUtils.nullToEmpty(input).trim().toLowerCase(Locale.ROOT);
    }

    private String generateIndexHash(String input) throws GeneralSecurityException {
        Mac hmac = Mac.getInstance(HASH_HMAC_ALGORITHM);
        hmac.init(new SecretKeySpec(this.key.getAuthKey(), HASH_HMAC_ALGORITHM));
        return Base64.getEncoder().encodeToString(hmac.doFinal(input.getBytes(StandardCharsets.UTF_8)));
    }

    public byte[] encryptValue(String value) throws GeneralSecurityException {
        if (!this.keyExists()) {
            throw new GeneralSecurityException("Key does not exist.");
        }
        return CryptoUtils.encryptAES(value.getBytes(StandardCharsets.UTF_8), this.key);
    }

    public String decryptValue(byte[] encryptedValue) throws GeneralSecurityException {
        if (!this.keyExists()) {
            throw new GeneralSecurityException("Key does not exist.");
        }
        return new String(CryptoUtils.decryptAES(encryptedValue, this.key), StandardCharsets.UTF_8);
    }

    public void SetAcquiredAction(Object key, Runnable action) {
        if (action != null) {
            this.acquiredActions.put(key, action);
        } else {
            this.acquiredActions.remove(key);
        }
    }

    private void doAcquiredActions() {
        for (Runnable action : this.acquiredActions.values()) {
            if (action == null) continue;
            try {
                action.run();
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public static PersonCrypt getInstance() {
        if (instance == null) {
            instance = new PersonCrypt();
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            instance.close();
            instance = null;
        }
    }

    @Override
    public void close() {
        if (this.keyExists()) {
            this.key.dispose();
            this.key = null;
        }
        this.acquiredActions.clear();
    }
}

