/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Date;
import jpos.SP;
import jpos.StringUtils;
import jpos.custorder.DespatchInfo;
import jpos.custorder.IDespatcher;

public abstract class Despatcher
implements IDespatcher {
    protected String printError;
    protected boolean manualMode = false;
    protected String lastGeneratedLabelFilename = "";
    protected String lastGeneratedConsignmentFilename = "";
    protected String lastGeneratedInvoiceFilename = "";

    protected String generateLabelsFilename(DespatchInfo despatchInfo) {
        return SP.sParams.getDeliveryLabelDirectory() + File.separator + despatchInfo.getOrderNumber() + "_labels_" + new Date().getTime() + ".pdf";
    }

    protected String generateConsignmentFilename(DespatchInfo despatchInfo) {
        return SP.sParams.getDeliveryLabelDirectory() + File.separator + despatchInfo.getOrderNumber() + "_consignment_" + new Date().getTime() + ".pdf";
    }

    protected String generateInvoiceFilename(DespatchInfo despatchInfo) {
        return SP.sParams.getDeliveryLabelDirectory() + File.separator + despatchInfo.getOrderNumber() + "_invoice_" + new Date().getTime() + ".pdf";
    }

    @Override
    public String getBookingSummary(DespatchInfo despatchInfo) {
        String connote = despatchInfo.getConnoteNumber();
        if (StringUtils.isNullOrEmpty(connote)) {
            connote = SP.getRS("No_Consignment_Note_number_was_returned_by_the_freight_system");
        }
        return SP.getRS("Connote_Number_X_Carrier_Y_ReadyDateTime_Z", connote, despatchInfo.getCarrierName(), despatchInfo.getReadyDateTime());
    }

    @Override
    public boolean printLabels(DespatchInfo despatchInfo) {
        this.printError = null;
        try {
            String invoiceError;
            String consignError;
            String labelError = SP.sParams.PrinterProvider.openDocument(this.lastGeneratedLabelFilename);
            if (!StringUtils.isNullOrEmpty(labelError)) {
                this.printError = labelError;
            }
            if (this.lastGeneratedConsignmentFilename != null && !StringUtils.isNullOrEmpty(consignError = SP.sParams.PrinterProvider.openDocument(this.lastGeneratedConsignmentFilename))) {
                String string = this.printError = StringUtils.isNullOrEmpty(this.printError) ? consignError : this.printError + "\n" + consignError;
            }
            if (!(despatchInfo.getCountry().equals(despatchInfo.getCountryOfOrigin()) || this.lastGeneratedInvoiceFilename.isEmpty() || StringUtils.isNullOrEmpty(invoiceError = SP.sParams.PrinterProvider.openDocument(this.lastGeneratedInvoiceFilename)))) {
                this.printError = StringUtils.isNullOrEmpty(this.printError) ? invoiceError : this.printError + "\n" + invoiceError;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return StringUtils.isNullOrEmpty(this.printError);
    }

    @Override
    public boolean reprintLabels(DespatchInfo despatchInfo) {
        this.printError = null;
        try {
            final String orderNumber = despatchInfo.getOrderNumber();
            File dir = new File(SP.sParams.getDeliveryLabelDirectory());
            File[] foundFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith(orderNumber);
                }
            });
            if (foundFiles.length == 0) {
                this.printError = SP.getRS("No_labels_to_reprint", "\n", "\n");
                return false;
            }
            for (File file : foundFiles) {
                this.printError = SP.sParams.PrinterProvider.openDocument(file.getAbsolutePath());
                if (StringUtils.isNullOrEmpty(this.printError)) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return StringUtils.isNullOrEmpty(this.printError);
    }

    @Override
    public String getPrintError() {
        return this.printError;
    }

    @Override
    public boolean showBookingSummary() {
        return !this.isManualMode();
    }

    @Override
    public boolean allowManualOverride() {
        return true;
    }

    @Override
    public void setManualMode(boolean manualMode) {
        this.manualMode = manualMode;
    }

    @Override
    public boolean isManualMode() {
        return this.manualMode;
    }

    @Override
    public abstract String getDespatcherTitle();

    @Override
    public abstract String getSwitchModeButtonText();

    @Override
    public abstract boolean requestDespatch(DespatchInfo var1);

    @Override
    public abstract boolean hasCredentials();
}

