/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.Security;
import jpos.StoreParams;
import jpos.custorder.DeliveryInfo;
import jpos.ui.DialogButton;
import jpos.ui.IconButton;
import jpos.ui.LabelSubHeading;

public class DlgDeliveryOptions
extends PosDialog {
    private boolean result = false;
    private boolean deliverySecurityGranted = false;
    private DeliveryInfo deliveryInfo;
    private LabelSubHeading label = new LabelSubHeading();
    private DialogButton bCancel = new DialogButton("");
    private IconButton bPickup;
    private IconButton bDelivery;
    private IconButton bSplit;
    private double stockedItemCount;

    public DlgDeliveryOptions(PosFrame frame, DeliveryInfo deliveryInfo, double stockedItemCount) {
        super(frame, SP.getRS("DlgNewOrderType_Title"), true);
        this.bPickup = new IconButton("", new ImageIcon(SP.sParams.imagepath + "order_type_pickup.png"));
        this.bDelivery = new IconButton("", new ImageIcon(SP.sParams.imagepath + "order_type_delivery.png"));
        this.bSplit = new IconButton("", new ImageIcon(SP.sParams.imagepath + "order_type_split.png"));
        this.deliveryInfo = deliveryInfo;
        this.stockedItemCount = stockedItemCount;
        this.init();
        if (deliveryInfo != null) {
            switch (deliveryInfo.getDeliveryOption()) {
                case DELIVERY: {
                    this.deliverySecurityGranted = true;
                    this.bDelivery.requestFocusInWindow();
                    break;
                }
                case CUSTOMER_PICKUP: {
                    break;
                }
                case SPLIT: {
                    this.deliverySecurityGranted = true;
                    if (!this.bSplit.isEnabled()) break;
                    this.bSplit.requestFocusInWindow();
                    break;
                }
            }
        }
    }

    private void init() {
        this.setAcceptOnEnter(false);
        this.setResizable(false);
        this.label.setText(SP.getRS("DlgNewOrderType_Label"));
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bPickup.setText(SP.getRS("NewOrderType_Pickup"));
        this.bDelivery.setText(SP.getRS("NewOrderType_Delivery"));
        this.bSplit.setText(SP.getRS("NewOrderType_Split"));
        JPanel panelOptions = new JPanel(new GridBagLayout());
        if (SP.sParams.bHidePickUpOption) {
            this.bPickup.setEnabled(false);
        } else {
            panelOptions.add((Component)this.bPickup, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 10, 0, 10), 0, 0));
        }
        panelOptions.add((Component)this.bDelivery, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 10, 0, 10), 0, 0));
        if (this.stockedItemCount <= 1.0) {
            this.bSplit.setEnabled(false);
        } else {
            panelOptions.add((Component)this.bSplit, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 10, 0, 10), 0, 0));
        }
        JPanel panelCancel = new JPanel(new GridBagLayout());
        panelCancel.add((Component)this.bCancel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panelMain = new JPanel(new GridBagLayout());
        panelMain.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 10, 20), 0, 0));
        panelMain.add((Component)panelOptions, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        panelMain.add((Component)panelCancel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 2, new Insets(10, 20, 10, 20), 0, 0));
        this.getContentPane().add(panelMain);
        this.bPickup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgDeliveryOptions.this.deliveryInfo != null) {
                    DlgDeliveryOptions.this.deliveryInfo.setDeliveryOption(DeliveryInfo.DeliveryOptions.CUSTOMER_PICKUP);
                }
                DlgDeliveryOptions.this.okDialog();
            }
        });
        this.bDelivery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgDeliveryOptions.this.validateDeliverySecurity()) {
                    if (DlgDeliveryOptions.this.deliveryInfo != null) {
                        DlgDeliveryOptions.this.deliveryInfo.setDeliveryOption(DeliveryInfo.DeliveryOptions.DELIVERY);
                    }
                    DlgDeliveryOptions.this.okDialog();
                }
            }
        });
        this.bSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DlgDeliveryOptions.this.validateDeliverySecurity()) {
                    if (DlgDeliveryOptions.this.deliveryInfo != null) {
                        DlgDeliveryOptions.this.deliveryInfo.setDeliveryOption(DeliveryInfo.DeliveryOptions.SPLIT);
                    }
                    DlgDeliveryOptions.this.okDialog();
                }
            }
        });
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgDeliveryOptions.this.cancelDialog();
            }
        });
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.bPickup);
        v.add(this.bDelivery);
        v.add(this.bSplit);
        v.add(this.bCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    public boolean getResult() {
        return this.result;
    }

    private boolean validateDeliverySecurity() {
        if (!this.deliverySecurityGranted && !Security.hasSecurity(this.frParent, 11170L, this.frParent.getUser().getMemidx(), 0, true)) {
            DlgMessage.showMessage(this, SP.getRS("no_security"), SP.getRS("Insufficient_security"), -1, 0);
            return false;
        }
        this.deliverySecurityGranted = true;
        return true;
    }

    @Override
    public void cancelDialog() {
        this.result = false;
        this.dispose();
    }

    @Override
    public void okDialog() {
        this.result = true;
        this.dispose();
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

