/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.auspost;

import com.google.gson.Gson;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import jpos.DlgMessage;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.custorder.DespatchInfo;
import jpos.custorder.Despatcher;
import jpos.custorder.Pack;
import jpos.custorder.ShippingLabelFilePurge;
import jpos.logging.RollingLog;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jdom.Element;

public class AustraliaPost
extends Despatcher {
    String accountNo = "";
    String apiKey = "";
    String apiPassword = "";
    String carrierName = "";
    String carrierIdx = "";
    String freightOption = "";
    int purgeTime;
    boolean authority_to_leave = false;
    private static int downloadRetry = 10;
    String origDescription = "";

    public AustraliaPost(String accountNo, String apiKey, String apiPassword, String carrierIdx, String carrierName, String freightOption, boolean authToLeave, int purgeTime) {
        this.accountNo = accountNo;
        this.apiKey = apiKey;
        this.apiPassword = apiPassword;
        this.carrierIdx = carrierIdx;
        this.freightOption = freightOption;
        this.authority_to_leave = authToLeave;
        this.purgeTime = purgeTime;
    }

    @Override
    public String getDespatcherTitle() {
        if (this.isManualMode()) {
            return SP.getRS("Manual_Despatch");
        }
        return SP.getRS("AusPost_Despatch");
    }

    @Override
    public String getSwitchModeButtonText() {
        if (!this.isManualMode()) {
            return SP.getRS("Manual_Switch");
        }
        return SP.getRS("AusPost_Switch");
    }

    @Override
    public boolean hasCredentials() {
        return !StringUtils.isNullOrEmpty(this.accountNo) && !StringUtils.isNullOrEmpty(this.apiKey) && !StringUtils.isNullOrEmpty(this.apiPassword);
    }

    public String DefaultAddressField(String field) {
        if (StringUtils.isNullOrEmpty(field)) {
            return "n/a";
        }
        return field;
    }

    private FileOutputStream CreateNewFileStream(String filename) {
        try {
            return new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            this.printError = SP.getRS("Cannot_open_file_X_is_it_in_use_by_another_program", filename);
            return null;
        }
    }

    private void writeToDisk(byte[] content, FileOutputStream fileStream) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(fileStream);){
            bos.write(content);
            bos.flush();
        }
    }

    public String escapeXml(String s) {
        String result = s.replaceAll("[\\u2018\\u2019]", "'").replaceAll("[\\u201C\\u201D]", "\"");
        return result.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    private boolean createPackingOrder(DespatchInfo despatchInfo) throws Exception {
        Payload payload = new Payload();
        payload.headers.AccId = this.accountNo;
        payload.headers.ApiKey = this.apiKey;
        payload.headers.ApiPassword = this.apiPassword;
        payload.headers.Vhidx = despatchInfo.getOriginalVhidx();
        payload.headers.CustOrderNum = despatchInfo.getCustomerOrderNumber();
        payload.shipment = this.buildShipment(despatchInfo);
        Gson gson = new Gson();
        String json = gson.toJson((Object)payload);
        try {
            RollingLog.log(RollingLog.LogType.AUSPOST, Level.INFO, "Shipment Request" + System.lineSeparator() + json);
        }
        catch (Exception e) {
            RollingLog.log(RollingLog.LogType.AUSPOST, json, e);
            return false;
        }
        Element result = SP.sParams.OnlineQueryProvider.getOnlineQuery("aps_create_packing_order", json).getXML();
        try {
            RollingLog.log(RollingLog.LogType.AUSPOST, Level.INFO, "Shipment Response" + System.lineSeparator() + XMLUtils.toString(result));
        }
        catch (Exception e) {
            RollingLog.log(RollingLog.LogType.AUSPOST, json, e);
            return false;
        }
        String connote = result.getChild("itemList").getChild("item").getAttributeValue("connoteId");
        String itemId = result.getChild("itemList").getChild("item").getAttributeValue("itemId");
        String labelURL = result.getAttributeValue("labelURL");
        String shipmentId = result.getAttributeValue("shipmentId");
        despatchInfo.setConnoteNumber(connote);
        DateFormat format = DateFormat.getDateTimeInstance();
        despatchInfo.setReadyDateTime(format.format(new Date()));
        despatchInfo.setCarrierIdx(this.carrierIdx);
        despatchInfo.setCarrierName("Australia Post");
        despatchInfo.setFinalCarrierIdx(this.carrierIdx);
        this.lastGeneratedLabelFilename = this.generateLabelsFilename(despatchInfo);
        boolean shipping = this.DownloadFileRetry(labelURL, this.lastGeneratedLabelFilename);
        if (!shipping) {
            DlgMessage.showMessage(null, SP.getRS("Cannot_Download_Label"), StoreParams.res.getString("Stop"), 1);
        }
        this.saveDataToDatabase(shipmentId, despatchInfo.getConnoteNumber(), despatchInfo.getCustomerOrderNumber(), labelURL, payload.shipment.items.get((int)0).product_id, despatchInfo.getCarrierName());
        despatchInfo.setDespatchSuccessful(true);
        return despatchInfo.getDespatchSuccessful();
    }

    private Shipment buildShipment(DespatchInfo despatchInfo) {
        Shipment shipment = new Shipment();
        shipment.customer_reference_1 = despatchInfo.getCustomerOrderNumber();
        shipment.email_tracking_enabled = true;
        shipment.to.name = despatchInfo.getCustomerName();
        shipment.to.business_name = despatchInfo.getCompanyName();
        shipment.to.lines = new String[]{despatchInfo.getAddressLine1(), despatchInfo.getAddressLine2()};
        shipment.to.suburb = despatchInfo.getCity();
        shipment.to.state = despatchInfo.getState();
        shipment.to.postcode = despatchInfo.getPostcode();
        shipment.to.phone = despatchInfo.getBestPhoneNumber();
        shipment.to.email = despatchInfo.getEmail();
        Element storeInfo = SP.sParams.OnlineQueryProvider.getOnlineQuery("get_store_location_info", "").getXML();
        if (storeInfo.getAttribute("tradename") == null) {
            String errorMsg = "No trade store name Found";
            PosUtils.logError(this.printError);
            return null;
        }
        shipment.from.name = storeInfo.getAttribute("tradename").getValue();
        shipment.from.lines = new String[]{storeInfo.getAttribute("address1") != null ? storeInfo.getAttribute("address1").getValue() : "", storeInfo.getAttribute("address2") != null ? storeInfo.getAttribute("address2").getValue() : ""};
        shipment.from.suburb = storeInfo.getAttribute("city") != null ? storeInfo.getAttribute("city").getValue() : null;
        shipment.from.state = storeInfo.getAttribute("state") != null ? storeInfo.getAttribute("state").getValue().toUpperCase() : null;
        shipment.from.postcode = storeInfo.getAttribute("postcode") != null ? storeInfo.getAttribute("postcode").getValue() : null;
        shipment.from.phone = storeInfo.getAttribute("phone") != null ? storeInfo.getAttribute("phone").getValue() : null;
        int packCount = 0;
        for (Pack pack : despatchInfo.getPacks()) {
            if (pack.getCount() <= 0) continue;
            for (int i = 0; i < pack.getCount(); ++i) {
                Item item = new Item();
                item.packaging_type = pack.getAlternativeName();
                item.weight = String.valueOf(pack.getWeight());
                item.width = String.valueOf(pack.getWidth());
                item.height = String.valueOf(pack.getDepth());
                item.length = String.valueOf(pack.getLength());
                item.authority_to_leave = this.authority_to_leave;
                shipment.items.add(item);
                ++packCount;
            }
        }
        String payload = this.accountNo + "," + this.carrierIdx + "," + this.freightOption + "," + packCount + "," + this.apiKey + "," + this.apiPassword;
        Element productPayload = SP.sParams.OnlineQueryProvider.getOnlineQuery("aps_get_product_id", payload).getXML();
        String productId = productPayload.getAttributeValue("productId");
        String productGroup = productPayload.getAttributeValue("group") != null ? productPayload.getAttributeValue("group") : "Parcel Post";
        for (Item item : shipment.items) {
            item.product_id = productId;
            item.group = productGroup;
        }
        return shipment;
    }

    @Override
    public boolean printLabels(DespatchInfo despatchInfo) {
        this.printError = null;
        try {
            String labelError = SP.sParams.PrinterProvider.openDocument(this.lastGeneratedLabelFilename);
            if (!StringUtils.isNullOrEmpty(labelError)) {
                this.printError = labelError;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return StringUtils.isNullOrEmpty(this.printError);
    }

    @Override
    public boolean requestDespatch(DespatchInfo despatchInfo) {
        try {
            boolean bl = this.createPackingOrder(despatchInfo);
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(this.printError);
        }
        finally {
            ShippingLabelFilePurge.getDefault().purgeFolder(SP.sParams.getDeliveryLabelLogDirectory(), this.purgeTime);
            ShippingLabelFilePurge.getDefault().purgeFolder(SP.sParams.getDeliveryLabelDirectory(), this.purgeTime);
        }
        return false;
    }

    @Override
    public boolean canDoDynamicCarrierAllocation() {
        return false;
    }

    private boolean saveDataToDatabase(String shipmentId, String connote, String custOrderNumber, String labelUrl, String productId, String carrierName) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("INSERT INTO AUSPOST_MANIFEST(ID, SHIPMENT_ID, SHIPMENT_DATE, CONNOTE, CORDER_NUM, FREIGHT_OPTION, CARRIERIDX, LABEL_URL, PRODUCT_ID, CARRIER_NAME, MANIFESTED) VALUES ((SELECT GEN_ID(AUSPOST_MANIFEST_ID, 1 ) FROM RDB$DATABASE),?,CURRENT_TIMESTAMP(2),?,?,?,?,?,?,?,0)");){
            stmt.setString(1, shipmentId);
            stmt.setString(2, connote);
            stmt.setString(3, custOrderNumber);
            stmt.setString(4, this.freightOption);
            stmt.setString(5, this.carrierIdx);
            stmt.setString(6, labelUrl);
            stmt.setString(7, productId);
            stmt.setString(8, carrierName);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    private boolean DownloadFile(String url, String filePath, boolean suppressErrors) {
        CloseableHttpResponse response;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
        }
        catch (Exception e) {
            if (suppressErrors) {
                PosUtils.logError("Failed to get " + url);
                PosUtils.logError(e);
            }
            return false;
        }
        HttpEntity entity = response.getEntity();
        if (entity != null && response.getStatusLine().getStatusCode() == 200) {
            try {
                FileOutputStream file = new FileOutputStream(filePath);
                BufferedHttpEntity inputStream = new BufferedHttpEntity(entity);
                inputStream.writeTo((OutputStream)file);
                file.flush();
                file.close();
            }
            catch (IOException e) {
                if (suppressErrors) {
                    PosUtils.logError("Failed to save " + url + " to  " + filePath);
                    PosUtils.logError(e);
                }
                return false;
            }
        } else {
            RollingLog.log(RollingLog.LogType.AUSPOST, Level.WARNING, "Saving File: " + url + " " + filePath);
            return false;
        }
        return true;
    }

    private Boolean DownloadFileRetry(String url, String filePath) {
        if (StringUtils.isNullOrEmpty(url)) {
            return false;
        }
        for (int count = 0; count < downloadRetry; ++count) {
            Boolean result = count == downloadRetry - 1 ? Boolean.valueOf(this.DownloadFile(url, filePath, false)) : Boolean.valueOf(this.DownloadFile(url, filePath, true));
            if (!result.booleanValue()) continue;
            return result;
        }
        return false;
    }

    public class Item {
        public String item_reference;
        public String product_id;
        public String group;
        public String packaging_type;
        public String weight;
        public String length;
        public String width;
        public String height;
        public boolean authority_to_leave;
    }

    public class Address {
        public String name;
        public String business_name;
        public String[] lines;
        public String suburb;
        public String state;
        public String postcode;
        public String country;
        public String phone;
        public String email;
    }

    public class Shipment {
        public String customer_reference_1;
        public boolean email_tracking_enabled;
        public Address from;
        public Address to;
        public Vector<Item> items;

        public Shipment() {
            this.from = new Address();
            this.to = new Address();
            this.items = new Vector();
        }
    }

    public class PayloadHeader {
        public String AccId;
        public String ApiKey;
        public String ApiPassword;
        public long Vhidx;
        public String CustOrderNum;
    }

    public class Payload {
        public PayloadHeader headers;
        public Shipment shipment;

        public Payload() {
            this.headers = new PayloadHeader();
            this.shipment = new Shipment();
        }
    }
}

