/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.outstanding;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import jpos.PosRenderer;
import jpos.custorder.outstanding.OrderTypeString;
import jpos.ui.Colours;
import jpos.ui.Fonts;

public class OrderTypeIconRenderer
extends PosRenderer {
    public OrderTypeIconRenderer(JTable parentTable) {
        super(parentTable);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component renComp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof OrderTypeString && renComp instanceof JLabel) {
            ImageIcon icon;
            OrderTypeString typeString = (OrderTypeString)value;
            JLabel label = (JLabel)renComp;
            label.setFont(Fonts.BoldText);
            Color foreground = null;
            switch (typeString.getUrgency()) {
                case OVERDUE: 
                case CRITICAL: {
                    foreground = Colours.CHART_RED;
                    break;
                }
                case ALERT: {
                    foreground = Colours.CHART_AMBER;
                    break;
                }
                case NORMAL: {
                    foreground = Colours.CHART_DARK_BLUE;
                    break;
                }
            }
            if (foreground != null) {
                label.setForeground(foreground);
            }
            if (typeString.getType() != null && (icon = typeString.getType().getIcon()) != null) {
                label.setIcon(OrderTypeIconRenderer.colourIcon(icon, foreground));
            }
        }
        return renComp;
    }

    private static ImageIcon colourIcon(ImageIcon icon, Color colour) {
        if (colour == null) {
            return icon;
        }
        BufferedImage newImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g = newImage.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        WritableRaster raster = newImage.getRaster();
        for (int x = 0; x < icon.getIconWidth(); ++x) {
            for (int y = 0; y < icon.getIconHeight(); ++y) {
                int[] pixels = raster.getPixel(x, y, (int[])null);
                pixels[0] = colour.getRed();
                pixels[1] = colour.getGreen();
                pixels[2] = colour.getBlue();
                raster.setPixel(x, y, pixels);
            }
        }
        return new ImageIcon(newImage);
    }
}

