/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.outstanding;

import ReceiptPrinter.Receipt;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.LinkStyle;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.SP;
import jpos.Security;
import jpos.StoreParams;
import jpos.SystemSettings;
import jpos.custorder.DlgReassignOrderReasons;
import jpos.custorder.outstanding.CustomerOrder;
import jpos.custorder.outstanding.CustomerOrderTable;
import jpos.custorder.outstanding.OrderPanel;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelStrong;
import jpos.ui.TouchTextField;
import org.jdom.Element;

public class OutstandingOrderDlg
extends PosDialog
implements AutoCloseable {
    private static final String loadedFormat = "<html><nobr><span style=\"font-weight:bold\">%s</span></nobr></html>";
    private static final String loadAll = SP.getRS("Load_All");
    private static final int RESULT_PACK = 1;
    private static final int RESULT_REJECT = 2;
    private static final int RESULT_DO_NOTHING = 3;
    private CustomerOrderTable orderList;
    private OrderPanel orderPanel;
    private DialogButton printButton = new DialogButton("");
    private TouchTextField searchField = new TouchTextField();
    private DialogButton okButton = new DialogButton("");
    private DialogButton cancelButton = new DialogButton("");
    private LabelNormal loadAllLabel = new LabelNormal();
    private LabelStrong loadedLabel = new LabelStrong();
    private String selection = null;
    private PosFrame pFrame;

    public OutstandingOrderDlg(PosFrame frame) {
        super(frame, SP.getRS("Outstanding_Orders"), true);
        this.pFrame = frame;
        this.init();
        this.resizeDialog(frame, 0.98f, 0.9f);
        this.populate(true);
    }

    public String getSelection() {
        return this.selection;
    }

    private void init() {
        this.orderList = new CustomerOrderTable(this);
        this.orderPanel = new OrderPanel();
        this.orderList.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && e.getSource() instanceof ListSelectionModel) {
                    boolean selectionExists = false;
                    ListSelectionModel listModel = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        if (!listModel.isSelectedIndex(i)) continue;
                        selectionExists = true;
                        OutstandingOrderDlg.this.orderPanel.loadOrder(OutstandingOrderDlg.this.orderList.getOrder(i));
                    }
                    if (!selectionExists) {
                        OutstandingOrderDlg.this.orderPanel.clearOrder();
                    }
                }
            }
        });
        this.orderList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && OutstandingOrderDlg.this.orderList.getSelectedRow() > -1) {
                    OutstandingOrderDlg.this.okDialog();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Component focusComp = OutstandingOrderDlg.this.getFocusOwner();
                if (focusComp == null || focusComp != OutstandingOrderDlg.this.orderList && focusComp.getParent() != OutstandingOrderDlg.this.orderList) {
                    if (e.getKeyCode() == 38) {
                        if (OutstandingOrderDlg.this.orderList.getSelectedRow() > 0) {
                            OutstandingOrderDlg.this.orderList.changeSelection(OutstandingOrderDlg.this.orderList.getSelectedRow() - 1, OutstandingOrderDlg.this.orderList.getSelectedColumn(), false, false);
                        }
                    } else if (e.getKeyCode() == 40 && OutstandingOrderDlg.this.orderList.getSelectedRow() < OutstandingOrderDlg.this.orderList.getRowCount() - 1) {
                        OutstandingOrderDlg.this.orderList.changeSelection(OutstandingOrderDlg.this.orderList.getSelectedRow() + 1, OutstandingOrderDlg.this.orderList.getSelectedColumn(), false, false);
                    }
                }
            }
        });
        this.okButton.setText(StoreParams.res.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutstandingOrderDlg.this.okDialog();
            }
        });
        this.cancelButton.setText(StoreParams.res.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutstandingOrderDlg.this.cancelDialog();
            }
        });
        this.printButton.setText(SP.getRS("Print_Picklists"));
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutstandingOrderDlg.this.printPickLists();
            }
        });
        this.printButton.setVisible(this.orderList.isPrintColumnVisible());
        this.loadAllLabel.setText(LinkStyle.UNVISITED.format(loadAll));
        this.loadAllLabel.setToolTipText(SP.getRS("Load_All_Orders"));
        this.loadAllLabel.setVisible(false);
        this.loadAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                OutstandingOrderDlg.this.populate(false);
                OutstandingOrderDlg.this.loadAllLabel.getParent().setCursor(new Cursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                OutstandingOrderDlg.this.loadAllLabel.getParent().setCursor(new Cursor(12));
                OutstandingOrderDlg.this.loadAllLabel.setText(LinkStyle.ACTIVE.format(loadAll));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                OutstandingOrderDlg.this.loadAllLabel.getParent().setCursor(new Cursor(0));
                OutstandingOrderDlg.this.loadAllLabel.setText(LinkStyle.UNVISITED.format(loadAll));
            }
        });
        this.searchField.setHint(SP.getRS("Search_Cust_Order"));
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                OutstandingOrderDlg.this.orderList.filter(OutstandingOrderDlg.this.searchField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OutstandingOrderDlg.this.orderList.filter(OutstandingOrderDlg.this.searchField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                OutstandingOrderDlg.this.orderList.filter(OutstandingOrderDlg.this.searchField.getText());
            }
        });
        this.orderList.getScrollPane().setPreferredSize(new Dimension(0, 0));
        this.orderPanel.setPreferredSize(new Dimension(0, 0));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        controlPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        controlPanel.add((Component)this.loadedLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 0), 0, 0));
        controlPanel.add((Component)this.loadAllLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        controlPanel.add((Component)new JLabel(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 30, 0, 0), 0, 0));
        controlPanel.add((Component)this.printButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 0, 0, 0), 0, 0));
        controlPanel.setPreferredSize(new Dimension(0, controlPanel.getPreferredSize().height));
        JPanel panelMain = new JPanel(new GridBagLayout());
        panelMain.add((Component)this.searchField, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        panelMain.add((Component)this.orderList.getScrollPane(), new GridBagConstraints(0, 1, 1, 1, 0.6, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        panelMain.add((Component)this.orderPanel, new GridBagConstraints(1, 1, 1, 1, 0.4, 1.0, 12, 1, new Insets(5, 5, 0, 5), 0, 0));
        panelMain.add((Component)controlPanel, new GridBagConstraints(0, 2, 1, 1, 0.6, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.getContentPane().add(panelMain);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.searchField);
        v.add(this.orderList);
        v.add(this.okButton);
        v.add(this.printButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void resizeDialog(Window frParent, float scaleWidth, float scaleHeight) {
        Rectangle parentRect = frParent.getBounds();
        int width = (int)((float)parentRect.width * scaleWidth);
        int height = (int)((float)parentRect.height * scaleHeight);
        int x = (int)((float)parentRect.x + (float)parentRect.width / 2.0f - (float)width / 2.0f);
        int y = (int)((float)parentRect.y + (float)parentRect.height / 2.0f - (float)height / 2.0f);
        this.setBounds(x, y, width, height);
    }

    private void populate(boolean limited) {
        this.searchField.setText("");
        this.orderList.populateOutstandingOrders(limited);
        this.orderList.selectFirstRow();
        if ((long)this.orderList.getRowCount() < this.orderList.getTotalOrderCount()) {
            this.loadAllLabel.setVisible(true);
            this.loadedLabel.setText(String.format(loadedFormat, MessageFormat.format(SP.getRS("Orders_Loaded"), MessageFormat.format("<span style=\"font-weight:normal\">{0}/</span>{1}", this.orderList.getRowCount(), this.orderList.getTotalOrderCount()))));
        } else {
            this.loadAllLabel.setVisible(false);
            this.loadedLabel.setText(MessageFormat.format(this.orderList.getRowCount() == 1 ? SP.getRS("Order_Loaded") : SP.getRS("Orders_Loaded"), this.orderList.getRowCount()));
        }
    }

    private void printPickLists() {
        List<CustomerOrder> orders = this.orderList.getOrdersToPrint();
        List<String> dockets = this.orderList.getOrderDocketsToPrint();
        if (dockets.size() > 0) {
            if (!SP.sParams.checkIConn()) {
                DlgMessage.showMessage(this, SP.getRS("must_be_online"), SP.getRS("Offline"), -1, 0);
                return;
            }
            for (CustomerOrder order : orders) {
                int checkSLA = this.canPackOrderUsingSLA(order, true);
                if (checkSLA == 2) {
                    this.rejectOrder(order);
                }
                if (checkSLA == 1) continue;
                int index = orders.indexOf(order);
                dockets.remove(index);
            }
            if (dockets.size() == 0) {
                return;
            }
            if (DlgMessage.showMessage(this, MessageFormat.format(dockets.size() > 1 ? SP.getRS("Print_x_picklists") : SP.getRS("Print_x_picklist"), dockets.size()), SP.getRS("Print_Picklists"), 2, 3) == 0) {
                Receipt r1 = new Receipt(this, SP.getRS("Printing_Picklist"), false, SP.sParams.getDocketConnection(), 0L, false);
                r1.setVisible(true);
                for (String docket : dockets) {
                    Element trans = SP.sParams.OnlineQueryProvider.getOnlineQuery("trans", docket).getXML();
                    if (trans != null) {
                        r1.printCustOrderPicklist(trans);
                        continue;
                    }
                    if (SP.sParams.checkIConn()) continue;
                    DlgMessage.showMessage(this, SP.getRS("must_be_online"), SP.getRS("Offline"), -1, 0);
                    break;
                }
                r1.setVisible(false);
                r1.close();
            }
        } else {
            DlgMessage.showMessage(this, SP.getRS("No_transactions_selected_to_print"), SP.getRS("Print_Picklists"), 1);
        }
    }

    @Override
    public void cancelDialog() {
        this.selection = null;
        this.dispose();
    }

    private void rejectOrder(CustomerOrder order) {
        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ORDER_REASSIGNMENT_REASON_REQUIRED)) {
            DlgReassignOrderReasons dlgReassignOrderReasons = new DlgReassignOrderReasons(this.frParent, StoreParams.res.getString("Confirm_Reassign_Order"), true, order.getVhIdx(), this.frParent.getUser());
            dlgReassignOrderReasons.setVisible(true);
            if (dlgReassignOrderReasons.getHasRejectedOrder()) {
                this.orderList.removeOrder(order);
            }
        } else {
            ((FrSales)this.frParent).rejectCustOrder(order.getVhIdx(), this.frParent.getUser().getMemidx());
            this.orderList.removeOrder(order);
        }
    }

    private int canPackOrderUsingSLA(CustomerOrder order, boolean isPrintView) {
        if (order.getExpectedDeliveryDate() != null && order.getServiceLevelAgreement() != null) {
            boolean canPackOrder;
            boolean bl = canPackOrder = !order.hasPassedSLAHardCutoff();
            if (canPackOrder && order.needPromptSLASoftCutoffWarning()) {
                int softCutoffWarningResult = DlgMessage.showMessage(this, order.getServiceLevelAgreement().getCutoffWarningMessage(), SP.getRS("Cutoff_warning_dlg"), 1, 3);
                if (softCutoffWarningResult == 2 || softCutoffWarningResult == -1) {
                    return 3;
                }
                boolean bl2 = canPackOrder = softCutoffWarningResult == 1;
            }
            if (!canPackOrder) {
                DlgMessage dlgMessage;
                String missPickupMessage = MessageFormat.format(SP.getRS("After_Cutoff_Desp_Time"), order.getCustOrderNum());
                boolean yesToReject = false;
                if (order.getServiceLevelAgreement().getRejectOrderOnMissedPickup()) {
                    missPickupMessage = missPickupMessage + "\n" + SP.getRS("Reject_cust_order");
                    yesToReject = true;
                    dlgMessage = new DlgMessage(this, SP.getRS("After_Cutoff_Desp_Title"), missPickupMessage, 1, 2);
                    dlgMessage.getYesButton().setText(SP.getRS("Reassign_Despatch_Store"));
                } else {
                    dlgMessage = new DlgMessage(this, SP.getRS("After_Cutoff_Desp_Title"), missPickupMessage, 0, 2);
                    dlgMessage.getYesButton().setText(SP.getRS("OK"));
                }
                if (isPrintView) {
                    dlgMessage.getNoButton().setText(SP.getRS("Continue_Printing"));
                } else {
                    dlgMessage.getNoButton().setText(SP.getRS("Continue_Booking"));
                }
                dlgMessage.setCloseAction(2);
                int dlgResult = dlgMessage.showMessage();
                if (dlgResult == 1) {
                    if (Security.hasSecurity(this.frParent, 11172L, this.frParent.getUser().getMemidx(), 2, true)) {
                        return 1;
                    }
                    return 3;
                }
                if (dlgResult == 0 && yesToReject) {
                    return 2;
                }
                return 3;
            }
        }
        return 1;
    }

    @Override
    public void okDialog() {
        CustomerOrder order = this.orderList.getSelectedOrder();
        if (order != null) {
            int checkSLA = this.canPackOrderUsingSLA(order, false);
            if (checkSLA == 2) {
                this.rejectOrder(order);
            }
            if (checkSLA != 1) {
                return;
            }
            this.selection = order.getDocketNum();
            if (this.selection != null && this.selection.startsWith("D")) {
                this.selection = this.selection.substring(1);
            }
        }
        this.pFrame.setFITVisible(false);
        this.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void close() {
        if (this.orderPanel != null) {
            this.orderPanel.close();
        }
    }
}

