/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.scanpack;

import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jpos.SP;
import jpos.StyleLine;
import jpos.custorder.DeliveryInfo;
import jpos.custorder.scanpack.ScanPackLine;
import jpos.custorder.scanpack.ScanPackResult;

public class ScanPackTableModel
extends AbstractTableModel {
    public static final int DESCRIPTION_COLUMN = 0;
    public static final int PACK_COLUMN = 1;
    public static final int PICKUP_COLUMN = 2;
    public static final int CANCEL_COLUMN = 3;
    private static final int COL_COUNT = 4;
    private static final String DESCRIPTION_HEADING = SP.getRS("Description");
    private static final String PACKED_HEADING = SP.getRS("Packed");
    private static final String TAKE_NOW_HEADING = SP.getRS("Take_Now");
    private static final String PICKUP_HEADING = SP.getRS("Pick_Up");
    private static final String CANCEL_HEADING = SP.getRS("Cancel_column");
    private Vector<ScanPackLine> data = new Vector();
    private DeliveryInfo.DeliveryOptions option;
    private boolean cancelItems = false;
    private boolean allowedManual = false;

    public ScanPackTableModel(DeliveryInfo.DeliveryOptions option) {
        this.option = option;
    }

    public ScanPackTableModel(boolean cancelItems) {
        this.cancelItems = cancelItems;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 1: 
            case 3: {
                return true;
            }
            case 2: {
                return this.showPickupColumn();
            }
        }
        return false;
    }

    public boolean allowManualPacking() {
        return !this.cancelItems;
    }

    public boolean allowForceScan() {
        return !this.allowedManual;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.data.size() || row < 0) {
            return "";
        }
        switch (col) {
            case 0: {
                return this.data.elementAt(row).toString();
            }
            case 1: {
                return this.data.elementAt(row).isPacked();
            }
            case 2: {
                return this.data.elementAt(row).isPickup();
            }
            case 3: {
                return this.data.elementAt(row).isCancelled();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row >= this.data.size() || row < 0 || value == null) {
            return;
        }
        switch (col) {
            case 1: {
                if (this.getColumnName(col) != TAKE_NOW_HEADING && (!((Boolean)value).booleanValue() || this.data.elementAt(row).ignoreManualPackingSecurity() || this.allowManualPacking())) {
                    this.data.elementAt(row).setPacked((Boolean)value);
                    break;
                }
                if (this.getColumnName(col) != TAKE_NOW_HEADING || ((Boolean)value).booleanValue() && !this.data.elementAt(row).ignoreManualPackingSecurity() && !this.allowForceScan()) break;
                this.data.elementAt(row).setPacked((Boolean)value);
                break;
            }
            case 2: {
                this.data.elementAt(row).setPickup((Boolean)value);
                break;
            }
            case 3: {
                if ((!this.data.elementAt(row).isCancelled() || ((Boolean)value).booleanValue()) && (this.data.elementAt(row).isCancelled() || !((Boolean)value).booleanValue() || !this.canChangeCancelValue(this.data.elementAt(row)))) break;
                this.data.elementAt(row).setCancelled((Boolean)value);
                break;
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 1: 
            case 2: 
            case 3: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(column);
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return DESCRIPTION_HEADING;
            }
            case 1: {
                return this.option != DeliveryInfo.DeliveryOptions.SPLIT ? PACKED_HEADING : TAKE_NOW_HEADING;
            }
            case 2: {
                return PICKUP_HEADING;
            }
            case 3: {
                return CANCEL_HEADING;
            }
        }
        return "";
    }

    public int getTotalPacked() {
        int total = 0;
        for (ScanPackLine line : this.data) {
            total += line.isPacked() ? 1 : 0;
        }
        return total;
    }

    public int getTotalPickup() {
        int total = 0;
        for (ScanPackLine line : this.data) {
            total += line.isPickup() ? 1 : 0;
        }
        return total;
    }

    public int getTotalCancelled() {
        int total = 0;
        for (ScanPackLine line : this.data) {
            total += line.isCancelled() ? 1 : 0;
        }
        return total;
    }

    public void populate(List<StyleLine> styleLines) {
        for (StyleLine line : styleLines) {
            if (line.getStkFlag() == 0) {
                if (this.option == DeliveryInfo.DeliveryOptions.SPLIT) {
                    line.setPackedQty(line.getTakenQty());
                    line.setPickUpQty(0.0);
                    continue;
                }
                if (this.option == DeliveryInfo.DeliveryOptions.DELIVERY) continue;
            }
            if (this.cancelItems) {
                this.data.addAll(ScanPackLine.createCancelItemLines(line));
                continue;
            }
            this.data.addAll(ScanPackLine.createScanPackLines(line));
        }
    }

    public ScanPackResult packSku(long skuidx) {
        boolean foundSku = false;
        for (ScanPackLine line : this.data) {
            if (line.getSkuidx() != skuidx) continue;
            foundSku = true;
            if (line.isPacked()) continue;
            line.setPacked(true);
            if (!this.showPickupColumn()) {
                line.setPickup(true);
            }
            this.fireTableDataChanged();
            return ScanPackResult.SUCCESS;
        }
        if (foundSku) {
            return ScanPackResult.SKU_FULLY_PACKED;
        }
        return ScanPackResult.NOT_ON_ORDER;
    }

    public boolean canChangeCancelValue(ScanPackLine line) {
        return true;
    }

    public int packRemaining() {
        int packedCount = 0;
        for (ScanPackLine line : this.data) {
            if (line.isPacked()) continue;
            line.setPacked(true);
            ++packedCount;
        }
        if (packedCount > 0) {
            this.fireTableDataChanged();
        }
        return packedCount;
    }

    public void unpackAll() {
        boolean hasChanged = false;
        for (ScanPackLine line : this.data) {
            if (!line.isPacked()) continue;
            line.setPacked(false);
            hasChanged = true;
        }
        if (hasChanged) {
            this.fireTableDataChanged();
        }
    }

    public int cancelRemaining() {
        int canceledCount = 0;
        for (ScanPackLine line : this.data) {
            if (line.isCancelled() || !this.canChangeCancelValue(line)) continue;
            line.setCancelled(true);
            ++canceledCount;
        }
        if (canceledCount > 0) {
            this.fireTableDataChanged();
        }
        return canceledCount;
    }

    public void undoCancel() {
        int undoCount = 0;
        for (ScanPackLine line : this.data) {
            if (!line.isCancelled()) continue;
            line.setCancelled(false);
            ++undoCount;
        }
        if (undoCount > 0) {
            this.fireTableDataChanged();
        }
    }

    public int pickupRemaining() {
        int pickupCount = 0;
        for (ScanPackLine line : this.data) {
            if (!line.isPacked() || line.isPickup()) continue;
            line.setPickup(true);
            ++pickupCount;
        }
        if (pickupCount > 0) {
            this.fireTableDataChanged();
        }
        return pickupCount;
    }

    public boolean showPickupColumn() {
        return !this.cancelItems && this.option != DeliveryInfo.DeliveryOptions.DELIVERY && this.option != DeliveryInfo.DeliveryOptions.SPLIT;
    }

    public boolean showPackColumn() {
        return !this.cancelItems;
    }

    public boolean showCancelColumn() {
        return this.cancelItems;
    }

    public boolean getHasCustomisation() {
        boolean hasCustomisation = false;
        for (ScanPackLine line : this.data) {
            if (!line.hasCustomisation() || !line.isPacked()) continue;
            hasCustomisation = true;
            break;
        }
        return hasCustomisation;
    }
}

