/*
 * Decompiled with CFR 0.152.
 */
package jpos.fitsession;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jpos.FrSales;
import jpos.PaSalesFoot;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.SystemSettings;
import jpos.XMLLocal;
import jpos.XMLUtils;
import jpos.fitsession.FITSession;
import jpos.fitsession.ManualScreen;
import jpos.fitsession.SessionTable;
import jpos.kleber.KleberUtils;
import jpos.person.PersonAttributes;
import jpos.person.PersonInterface;
import jpos.person.PersonSecurity;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelStrong;
import jpos.ui.TouchTextField;
import org.jdom.Element;

public class FITSessionScreen
extends PosDialog
implements AutoCloseable {
    private static final int WIDTH = 800;
    private static final String loadedFormat = "<html><nobr><span style=\"font-weight:bold\">%s</span></nobr></html>";
    private int personIdx = 0;
    private int salesRepIdx = 0;
    private boolean[] loyaltySecurity;
    private boolean[] staffSecurity;
    private SessionTable sessionList;
    private TouchTextField searchField = new TouchTextField();
    private DialogButton okButton = new DialogButton("");
    private DialogButton manualButton = new DialogButton("");
    private DialogButton cancelButton = new DialogButton("");
    private LabelNormal loadAllLabel = new LabelNormal();
    private LabelStrong loadedLabel = new LabelStrong();
    private PersonInterface personInterface;
    PosFrame parentFrame;
    private int selection = -1;

    public FITSessionScreen(PosFrame frame, boolean[] loyaltySecurity, boolean[] staffSecurity) {
        super(frame, SP.getRS("My_Fit_Sessions_Button"), true);
        this.parentFrame = frame;
        this.init();
        this.populate(true);
        this.pack();
        this.resizeDialog(this.parentFrame, 0.4f, 0.4f);
    }

    public int getSelection() {
        return this.selection;
    }

    private void init() {
        this.sessionList = new SessionTable(this);
        this.sessionList.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && e.getSource() instanceof ListSelectionModel) {
                    boolean selectionExists = false;
                    ListSelectionModel listModel = (ListSelectionModel)e.getSource();
                    for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                        if (!listModel.isSelectedIndex(i)) continue;
                        selectionExists = true;
                        FITSessionScreen.this.selection = i;
                    }
                }
            }
        });
        this.sessionList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && FITSessionScreen.this.sessionList.getSelectedRow() > -1) {
                    FITSessionScreen.this.okDialog();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Component focusComp = FITSessionScreen.this.getFocusOwner();
                if (focusComp == null || focusComp != FITSessionScreen.this.sessionList && focusComp.getParent() != FITSessionScreen.this.sessionList) {
                    if (e.getKeyCode() == 38) {
                        if (FITSessionScreen.this.sessionList.getSelectedRow() > 0) {
                            FITSessionScreen.this.sessionList.changeSelection(FITSessionScreen.this.sessionList.getSelectedRow() - 1, FITSessionScreen.this.sessionList.getSelectedColumn(), false, false);
                        }
                    } else if (e.getKeyCode() == 40 && FITSessionScreen.this.sessionList.getSelectedRow() < FITSessionScreen.this.sessionList.getRowCount() - 1) {
                        FITSessionScreen.this.sessionList.changeSelection(FITSessionScreen.this.sessionList.getSelectedRow() + 1, FITSessionScreen.this.sessionList.getSelectedColumn(), false, false);
                    }
                }
            }
        });
        this.manualButton.setText(StoreParams.res.getString("Manual"));
        this.manualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FITSessionScreen.this.manualDialog();
            }
        });
        this.okButton.setText(StoreParams.res.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FITSessionScreen.this.okDialog();
            }
        });
        this.cancelButton.setText(StoreParams.res.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FITSessionScreen.this.cancelDialog();
            }
        });
        this.searchField.setHint(SP.getRS("Search_Fit_Sessions"));
        this.searchField.setFieldWidth(800);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FITSessionScreen.this.sessionList.filter(FITSessionScreen.this.searchField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FITSessionScreen.this.sessionList.filter(FITSessionScreen.this.searchField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FITSessionScreen.this.sessionList.filter(FITSessionScreen.this.searchField.getText());
            }
        });
        this.sessionList.getScrollPane().setPreferredSize(new Dimension(800, 400));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 0), 0, 0));
        controlPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        controlPanel.add((Component)this.manualButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        controlPanel.setPreferredSize(new Dimension(800, controlPanel.getPreferredSize().height));
        JPanel panelMain = new JPanel(new GridBagLayout());
        panelMain.add((Component)this.searchField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        panelMain.add((Component)this.sessionList.getScrollPane(), new GridBagConstraints(0, 1, 1, 1, 0.6, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
        panelMain.add((Component)controlPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.getContentPane().add(panelMain);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.searchField);
        v.add(this.sessionList);
        v.add(this.okButton);
        v.add(this.manualButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.pack();
        this.setFocusTraversalPolicy(ftp);
    }

    private void resizeDialog(Window frParent, float scaleWidth, float scaleHeight) {
        Rectangle parentRect = frParent.getBounds();
        int width = (int)((float)parentRect.width * scaleWidth);
        int height = (int)((float)parentRect.height * scaleHeight);
        int x = parentRect.x + (parentRect.width - width) / 2;
        int y = parentRect.y + (parentRect.height - height) / 2;
        this.setBounds(x, y, width, height);
    }

    private void populate(boolean limited) {
        this.searchField.setText("");
        this.sessionList.populateSessions(limited);
        this.sessionList.selectFirstRow();
        if (this.sessionList.getRowCount() < 20) {
            this.loadAllLabel.setVisible(true);
            this.loadedLabel.setText(String.format(loadedFormat, MessageFormat.format(SP.getRS("Sessions_Loaded"), MessageFormat.format("<span style=\"font-weight:normal\">{0}/</span>{1}", this.sessionList.getRowCount(), 20))));
        } else {
            this.loadAllLabel.setVisible(false);
            this.loadedLabel.setText(MessageFormat.format(this.sessionList.getRowCount() == 1 ? SP.getRS("Session_Loaded") : SP.getRS("Sessions_Loaded"), this.sessionList.getRowCount()));
        }
    }

    @Override
    public void cancelDialog() {
        this.selection = -1;
        this.dispose();
    }

    public void manualDialog() {
        try {
            ManualScreen manual = new ManualScreen(this.parentFrame, this);
            manual.setVisible(true);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            this.dispose();
        }
    }

    @Override
    public void okDialog() {
        FITSession session = this.sessionList.getSelectedSession();
        boolean online = SP.sParams.checkIConn();
        long peridx = session.getPersonIdx();
        if (session != null) {
            if (session.getsRepPeridx() > 0L) {
                ((FrSales)this.parentFrame).setSalesRepViaData(session.getsRepPeridx());
                ((FrSales)this.parentFrame).manageSalesRepLabel();
            }
            if (session.getPersonIdx() > 0L) {
                Element person = null;
                if (online) {
                    person = SP.sParams.OnlineQueryProvider.getOnlineQuery("person", peridx + "," + SP.sParams.getStoreIdx(), false).getXML();
                    long actualPeridx = XMLUtils.getLongValue(person, "peridx");
                    if (actualPeridx != 0L && XMLUtils.getLongValue(person, "widx") == SP.sParams.getStoreIdx()) {
                        person.setAttribute("peridx", String.valueOf(actualPeridx));
                    }
                } else {
                    try {
                        String tempString = "" + session.getPersonIdx();
                        PersonAttributes attributes = new PersonAttributes();
                        boolean showHistory = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.DISPLAY_POS_PERSON_SPENDING);
                        PersonSecurity security = new PersonSecurity(this.parentFrame.getUser(), this.loyaltySecurity, this.staffSecurity, this.parentFrame);
                        person = XMLLocal.getElement(SP.sParams.conn, "person", tempString);
                    }
                    catch (Exception e) {
                        PosUtils.logError(e);
                        this.dispose();
                    }
                }
                String perIdx = "" + session.getPersonIdx();
                try {
                    this.personInterface = new PersonInterface(this, "", person, new PersonAttributes(), StoreParams.createNewConnection(), KleberUtils.getInstance(this.sParams), new PersonSecurity(this.parentFrame.getUser(), this.loyaltySecurity, this.staffSecurity, this.parentFrame), SP.getRS("Done"));
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                    this.dispose();
                }
                this.personInterface.loadPerson(online, perIdx);
                ((FrSales)this.parentFrame).setPerson(person);
                ((FrSales)this.parentFrame).addAllLoyaltyCards(true);
                ((PaSalesFoot)((FrSales)this.parentFrame).paFoot).setSelfFit(0L);
            }
            this.setMyFitSess(session.getFitSession());
        }
        this.dispose();
    }

    public void setMyFitSess(String SessionId) {
        ((FrSales)this.parentFrame).setMyFitSessionId(SessionId);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void close() {
        this.dispose();
    }
}

