/*
 * Decompiled with CFR 0.152.
 */
package jpos.fitsession;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PaSalesFoot;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.fitsession.FITSessionScreen;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class ManualScreen
extends PosDialog
implements AutoCloseable {
    private static final String loadedFormat = "<html><nobr><span style=\"font-weight:bold\">%s</span></nobr></html>";
    private String FITSession;
    private TouchTextField searchField = new TouchTextField();
    private DialogButton okButton = new DialogButton("");
    private DialogButton cancelButton = new DialogButton("");
    protected static final int PAD0 = 0;
    protected static final int PAD1 = 5;
    protected static final int PAD2 = 10;
    protected static final int PAD3 = 20;
    private LabelSubHeading sessionPrompt = new LabelSubHeading();
    PosFrame parentFrame;
    FITSessionScreen parentScreen;

    public ManualScreen(PosFrame frame, FITSessionScreen screen) {
        super(frame, SP.getRS("My_Fit_Sessions_Button"), true);
        this.parentFrame = frame;
        this.parentScreen = screen;
        this.init();
    }

    public String getManualFIT() {
        return this.FITSession;
    }

    public void setFITSession(String sessionId) {
        this.FITSession = sessionId;
    }

    private void init() {
        this.okButton.setText(StoreParams.res.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualScreen.this.okDialog();
            }
        });
        this.cancelButton.setText(StoreParams.res.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualScreen.this.cancelDialog();
            }
        });
        this.sessionPrompt.setText(SP.getRS("ManualEntry"));
        this.searchField.setHint(SP.getRS("FITSession"));
        this.searchField.setFieldWidth(400);
        this.searchField.setHorizontalAlignment(2);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ManualScreen.this.setFITSession(ManualScreen.this.searchField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ManualScreen.this.setFITSession(ManualScreen.this.searchField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ManualScreen.this.setFITSession(ManualScreen.this.searchField.getText());
            }
        });
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((Component)this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
        controlPanel.add((Component)this.cancelButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
        controlPanel.setPreferredSize(new Dimension(0, controlPanel.getPreferredSize().height));
        JPanel panelMain = new JPanel(new GridBagLayout());
        panelMain.add((Component)this.sessionPrompt, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 20, 5, 20), 0, 0));
        panelMain.add((Component)this.searchField, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 20, 5, 20), 0, 0));
        panelMain.add((Component)controlPanel, new GridBagConstraints(0, 2, 1, 1, 0.6, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.getContentPane().add(panelMain);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.searchField);
        v.add(this.okButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.pack();
        this.setFocusTraversalPolicy(ftp);
        PosUtils.centreWindow(this);
    }

    private void resizeDialog(Window frParent, float scaleWidth, float scaleHeight) {
        Rectangle parentRect = frParent.getBounds();
        int width = (int)((float)parentRect.width * scaleWidth);
        int height = (int)((float)parentRect.height * scaleHeight);
        int x = (int)((float)parentRect.x + (float)parentRect.width / 2.0f - (float)width / 2.0f);
        int y = (int)((float)parentRect.y + (float)parentRect.height / 2.0f - (float)height / 2.0f);
        this.setBounds(x, y, width, height);
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }

    @Override
    public void okDialog() {
        if (this.FITSession.length() > 100) {
            DlgMessage.showMessage(this, StoreParams.res.getString("FITTooBig"), StoreParams.res.getString("FITSession"), -1, 0);
        } else {
            this.parentScreen.setMyFitSess(this.FITSession);
            ((PaSalesFoot)((FrSales)this.parentFrame).paFoot).setSelfFit(0L);
            this.dispose();
            this.parentScreen.dispose();
        }
    }

    public void setMyFitSess(String SessionId) {
        ((FrSales)this.parentFrame).setMyFitSessionId(SessionId);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void close() {
        this.dispose();
    }
}

