/*
 * Decompiled with CFR 0.152.
 */
package jpos.fitsession;

import jpos.SP;
import jpos.fitsession.FITSession;
import jpos.fitsession.IOrderCellValue;

public enum SessionColumn implements IOrderCellValue
{
    TimeCreated(0, "Time Created", 200, true, FITSession::getTimeCreated),
    custName(1, SP.getRS("Person"), 250, true, FITSession::getCustName),
    memName(2, SP.getRS("SalesRep"), 150, true, FITSession::getMemName);

    private final int id;
    private final String name;
    private final int width;
    private final boolean resizable;
    private final IOrderCellValue func;

    private SessionColumn(int id, String name, int width, boolean resizable, IOrderCellValue func) {
        this.id = id;
        this.name = name;
        this.width = width;
        this.resizable = resizable;
        this.func = func;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public Object getValue(FITSession session) {
        return this.func.getValue(session);
    }

    public static SessionColumn getById(int id) {
        for (SessionColumn col : SessionColumn.values()) {
            if (col.getId() != id) continue;
            return col;
        }
        return null;
    }
}

