/*
 * Decompiled with CFR 0.152.
 */
package jpos.fitsession;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import jpos.StringUtils;
import jpos.fitsession.FITSession;
import jpos.fitsession.SessionColumn;

public class SessionTableModel
extends AbstractTableModel {
    List<SessionPickPair> visibleSessions = new ArrayList<SessionPickPair>();
    List<FITSession> allSessions = new ArrayList<FITSession>();
    List<SessionColumn> columns = new ArrayList<SessionColumn>();
    String previousFilter = "";

    @Override
    public int getRowCount() {
        return this.visibleSessions.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.visibleSessions.size() || row < 0) {
            return "";
        }
        SessionColumn column = this.getColumnType(col);
        if (column == null) {
            return "";
        }
        FITSession session = this.visibleSessions.get(row).getKey();
        if (session != null) {
            return column.getValue(session);
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        SessionColumn column = this.getColumnType(col);
        return column != null ? column.getName() : "";
    }

    public SessionColumn getColumnType(int col) {
        if (col >= this.columns.size() || col < 0) {
            return null;
        }
        return this.columns.get(col);
    }

    public void addSession(FITSession session) {
        this.allSessions.add(session);
        this.resetFilter();
    }

    public void removeSession(FITSession session) {
        this.allSessions.remove(session);
        this.visibleSessions.remove(session);
        this.resetFilter();
    }

    public void addSessions(List<FITSession> sessions, boolean overwrite) {
        if (overwrite) {
            this.allSessions = new ArrayList<FITSession>(sessions);
        } else {
            this.allSessions.addAll(sessions);
        }
        this.resetFilter();
    }

    public void addColumn(SessionColumn column) {
        this.columns.add(column);
        this.fireTableStructureChanged();
    }

    public FITSession getSession(int row) {
        if (row >= this.visibleSessions.size() || row < 0) {
            return null;
        }
        return this.visibleSessions.get(row).getKey();
    }

    public int getSessionRow(FITSession session) {
        for (int i = 0; i < this.visibleSessions.size(); ++i) {
            if (this.visibleSessions.get(i).getKey() != session) continue;
            return i;
        }
        return -1;
    }

    private void resetFilter() {
        this.visibleSessions.clear();
        for (FITSession session : this.allSessions) {
            this.visibleSessions.add(new SessionPickPair(session));
        }
        this.fireTableDataChanged();
    }

    public void filter(String searchString) {
        if ((searchString = StringUtils.nullToEmpty(searchString).trim().toUpperCase()).isEmpty()) {
            this.resetFilter();
        } else if (this.previousFilter.isEmpty() || !searchString.contains(this.previousFilter)) {
            this.applyFilter(searchString, false);
        } else if (searchString.startsWith(this.previousFilter)) {
            String[] words = searchString.split("\\s+");
            if (words.length > 0) {
                this.applyFilter(words[words.length - 1], true);
            }
        } else {
            this.applyFilter(searchString, true);
        }
        this.previousFilter = searchString;
    }

    private void applyFilter(String searchString, boolean onExistingFilter) {
        if (onExistingFilter) {
            Iterator<SessionPickPair> iterator = this.visibleSessions.iterator();
            while (iterator.hasNext()) {
                SessionPickPair sessionPick = iterator.next();
                if (sessionPick.getKey().search(searchString)) continue;
                iterator.remove();
            }
        } else {
            this.visibleSessions.clear();
            for (FITSession session : this.allSessions) {
                if (!session.search(searchString)) continue;
                this.visibleSessions.add(new SessionPickPair(session));
            }
        }
        this.fireTableDataChanged();
    }

    private static class SessionPickPair
    implements Map.Entry<FITSession, Boolean> {
        FITSession session;
        boolean pick;

        @Override
        public FITSession getKey() {
            return this.session;
        }

        @Override
        public Boolean getValue() {
            return this.pick;
        }

        @Override
        public Boolean setValue(Boolean value) {
            if (this.pick == value) {
                return false;
            }
            this.pick = value;
            return true;
        }

        public SessionPickPair(FITSession session) {
            this.session = session;
            this.pick = false;
        }
    }
}

