/*
 * Decompiled with CFR 0.152.
 */
package jpos.kleber;

import com.teamdev.jxbrowser.js.JsAccessible;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.logging.Level;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.SystemSettings;
import jpos.basscom.utils.Utils;
import jpos.kleber.KleberApi;
import jpos.kleber.KleberApiException;
import jpos.kleber.KleberModels;
import jpos.logging.RollingLog;
import org.jdom.Element;

public class KleberUtils {
    private boolean kleberEnabled = false;
    private String kleberURL;
    private boolean emailValidationEnabled = false;
    private boolean phoneValidationEnabled = false;
    private boolean addressValidationEnabled = false;
    private int minAlphaChars = 3;
    private boolean auAddressValidationEnabled = false;
    private boolean nzAddressValidationEnabled = false;
    private boolean ukAddressValidationEnabled = false;
    private boolean caAddressValidationEnabled = false;
    private boolean otherAddressValidationEnabled = false;
    private String token = null;
    private static KleberUtils kleberUtils = null;
    public static final String DEFAULT_URL = "https://kleber.datatoolscloud.net.au";
    public static final String SYSPARAM_DISABLED = "SysparamDisabled";
    public static final String AUSTRALIA = "AU";
    public static final String NEWZEALAND = "NZ";
    public static final String CANADA = "CA";
    public static final String UNITEDKINGDOM = "GB";
    private StoreParams sParams;
    private KleberApi api;
    private Instant tokenExpiryDate;

    @JsAccessible
    public boolean isKleberEnabled() {
        return this.kleberEnabled;
    }

    @JsAccessible
    public String getKleberURL() {
        return this.kleberURL;
    }

    @JsAccessible
    public boolean isEmailValidationEnabled() {
        return this.emailValidationEnabled;
    }

    @JsAccessible
    public boolean isPhoneValidationEnabled() {
        return this.phoneValidationEnabled;
    }

    @JsAccessible
    public boolean isAddressValidationEnabled() {
        return this.addressValidationEnabled;
    }

    @JsAccessible
    public int getMinAlphaChars() {
        return this.minAlphaChars;
    }

    @JsAccessible
    public boolean isAuAddressValidationEnabled() {
        return this.auAddressValidationEnabled;
    }

    @JsAccessible
    public boolean isNzAddressValidationEnabled() {
        return this.nzAddressValidationEnabled;
    }

    @JsAccessible
    public boolean isUkAddressValidationEnabled() {
        return this.ukAddressValidationEnabled;
    }

    @JsAccessible
    public boolean isCaAddressValidationEnabled() {
        return this.caAddressValidationEnabled;
    }

    @JsAccessible
    public boolean isOtherAddressValidationEnabled() {
        return this.otherAddressValidationEnabled;
    }

    @JsAccessible
    public String getToken() {
        return this.token;
    }

    @JsAccessible
    public void writeLog(String log) {
        RollingLog.log(RollingLog.LogType.KLEBER, Level.INFO, log);
    }

    public static KleberUtils getInstance(StoreParams psParams) {
        try {
            if (kleberUtils == null) {
                kleberUtils = new KleberUtils(psParams);
            }
            if (KleberUtils.kleberUtils.token == null || KleberUtils.kleberUtils.token.isEmpty() || KleberUtils.kleberUtils.tokenExpiryDate == null || KleberUtils.kleberUtils.tokenExpiryDate.isBefore(Instant.now())) {
                kleberUtils.RefreshToken(true);
            } else if (KleberUtils.kleberUtils.tokenExpiryDate.isBefore(Instant.now().plusSeconds(86400L))) {
                kleberUtils.RefreshToken(false);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return kleberUtils;
    }

    public KleberUtils(StoreParams psParams) {
        try {
            this.sParams = psParams;
            if (this.sParams == null) {
                throw new IllegalArgumentException("Argument psParams is invalid");
            }
            long sysParamBlobidx = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.KLEBER_DATA_VERIFICATION);
            boolean bl = this.kleberEnabled = sysParamBlobidx > 0L;
            if (!this.kleberEnabled) {
                return;
            }
            String blob = Utils.getBLOBText(psParams.conn, sysParamBlobidx);
            String[] tokens = blob.split(String.valueOf('\u0003'));
            if (tokens.length < 7 && tokens.length != 3) {
                this.kleberEnabled = false;
                return;
            }
            this.kleberURL = tokens[1];
            if (this.kleberURL.isEmpty()) {
                this.kleberURL = DEFAULT_URL;
            }
            if (!this.kleberURL.startsWith("https")) {
                this.kleberURL = this.kleberURL.startsWith("http") ? this.kleberURL.replaceFirst("http", "https") : "https://" + this.kleberURL;
            }
            this.emailValidationEnabled = tokens[2].equalsIgnoreCase("1");
            if (tokens.length >= 7) {
                this.phoneValidationEnabled = tokens[3].equalsIgnoreCase("1");
                this.addressValidationEnabled = tokens[4].equalsIgnoreCase("1");
                try {
                    this.minAlphaChars = Integer.parseInt(tokens[5]);
                    if (this.minAlphaChars < 1 || this.minAlphaChars > 10) {
                        this.minAlphaChars = 3;
                    }
                }
                catch (NumberFormatException ex) {
                    this.minAlphaChars = 3;
                }
                String[] addressTokens = tokens[6].split(",");
                if (addressTokens.length == 5) {
                    this.auAddressValidationEnabled = addressTokens[0].equalsIgnoreCase("1") && this.addressValidationEnabled;
                    this.nzAddressValidationEnabled = addressTokens[1].equalsIgnoreCase("1") && this.addressValidationEnabled;
                    this.ukAddressValidationEnabled = addressTokens[2].equalsIgnoreCase("1") && this.addressValidationEnabled;
                    this.caAddressValidationEnabled = addressTokens[3].equalsIgnoreCase("1") && this.addressValidationEnabled;
                    this.otherAddressValidationEnabled = addressTokens[4].equalsIgnoreCase("1") && this.addressValidationEnabled;
                }
                this.addressValidationEnabled = this.addressValidationEnabled && (this.auAddressValidationEnabled || this.nzAddressValidationEnabled || this.ukAddressValidationEnabled || this.caAddressValidationEnabled || this.otherAddressValidationEnabled);
            }
            this.GetExistingToken();
            this.api = new KleberApi(this.kleberURL);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void GetExistingToken() {
        try (PreparedStatement stmt = this.sParams.conn.prepareStatement("SELECT TEMP_TOKEN, EXPIRY FROM KLEBER_AUTH WHERE EXPIRY > current_timestamp AND IDX = 1");
             ResultSet result = stmt.executeQuery();){
            if (result.next()) {
                this.token = result.getString(1);
                this.tokenExpiryDate = result.getTimestamp("EXPIRY").toInstant();
                return;
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        this.token = null;
        this.tokenExpiryDate = null;
    }

    private <T> KleberModels.KleberResponse<T> RunWithRefresh(KleberAPIFunction<String, KleberModels.KleberResponse<T>> func) throws KleberApiException {
        try {
            return func.run(this.token);
        }
        catch (KleberApiException e) {
            if (e.getErrorMessage() == "Temporary Request Key has expired") {
                this.RefreshToken(true);
                return func.run(this.token);
            }
            throw e;
        }
    }

    private void RefreshToken(boolean needNewToken) {
        block36: {
            if (this.kleberEnabled) {
                Instant now = Instant.now();
                String newToken = "";
                long expirySeconds = 0L;
                String errorMessage = "";
                Element apiResponse = SP.sParams.OnlineQueryProvider.getOnlineQuery("kleber_api", "").getXML();
                if (apiResponse == null) {
                    errorMessage = "Null response from POS Gateway";
                } else if (apiResponse.getChild("TemporaryRequestKey") == null && apiResponse.getChild("ErrorMessage") != null) {
                    errorMessage = apiResponse.getChild("ErrorMessage").getValue();
                    if (errorMessage.equals(SYSPARAM_DISABLED)) {
                        this.kleberEnabled = false;
                        return;
                    }
                } else {
                    newToken = apiResponse.getChild("TemporaryRequestKey").getValue();
                    expirySeconds = Long.parseLong(apiResponse.getChild("ExpirySeconds").getValue());
                }
                if (newToken.length() > 0) {
                    this.token = newToken;
                    this.tokenExpiryDate = now.plusSeconds(expirySeconds);
                    try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE KLEBER_AUTH SET TEMP_TOKEN = ?, EXPIRY = ? WHERE IDX = 1");){
                        stmt.setString(1, this.token);
                        stmt.setTimestamp(2, Timestamp.from(this.tokenExpiryDate));
                        int updatedRows = stmt.executeUpdate();
                        if (updatedRows != 0) break block36;
                        try (PreparedStatement stmtInner = SP.sParams.conn.prepareStatement("INSERT INTO KLEBER_AUTH (IDX, TEMP_TOKEN, EXPIRY) VALUES (1, ?, ?)");){
                            stmtInner.setString(1, this.token);
                            stmtInner.setTimestamp(2, Timestamp.from(this.tokenExpiryDate));
                            stmtInner.execute();
                        }
                        catch (SQLException e) {
                            PosUtils.logError(e);
                            if (needNewToken) {
                                throw new IllegalStateException("Failed to update Kleber token in DB", e);
                            }
                        }
                    }
                    catch (SQLException e) {
                        PosUtils.logError(e);
                        if (!needNewToken) break block36;
                        throw new IllegalStateException("Failed to update Kleber token in DB", e);
                    }
                }
            }
        }
    }

    public boolean EmailValidationEnabled() {
        return this.emailValidationEnabled;
    }

    public KleberModels.KleberResponse<KleberModels.DtResponse.EmailResult> ValidateEmail(String email) throws KleberApiException {
        if (this.emailValidationEnabled) {
            return this.RunWithRefresh(t -> this.api.validateEmail(email, (String)t));
        }
        return this.FeatureDisabledResponse();
    }

    public boolean PhoneValidationEnabled() {
        return this.phoneValidationEnabled;
    }

    public KleberModels.KleberResponse<KleberModels.DtResponse.PhoneResult> ValidatePhone(String phone, String countryCode) throws KleberApiException {
        if (this.phoneValidationEnabled && (countryCode.equals(AUSTRALIA) || countryCode.equals(NEWZEALAND))) {
            return this.RunWithRefresh(t -> this.api.validatePhone(phone, (String)t));
        }
        return this.FeatureDisabledResponse();
    }

    public int GetMinAlphaChars() {
        return this.minAlphaChars;
    }

    public boolean AddressValidationEnabled() {
        return this.addressValidationEnabled;
    }

    public boolean AddressValidationEnabledForCountry(String countryCode) {
        if (countryCode == null || countryCode.isEmpty()) {
            return false;
        }
        switch (countryCode) {
            case "AU": {
                return this.auAddressValidationEnabled;
            }
            case "NZ": {
                return this.nzAddressValidationEnabled;
            }
            case "CA": {
                return this.caAddressValidationEnabled;
            }
            case "GB": {
                return this.ukAddressValidationEnabled;
            }
        }
        return this.otherAddressValidationEnabled;
    }

    public KleberModels.KleberResponse<KleberModels.DtResponse.AddressSearchResult> SearchAddress(String address, String countryCode) throws KleberApiException {
        if (this.AddressValidationEnabledForCountry(countryCode)) {
            KleberModels.KleberResponse<KleberModels.DtResponse.AddressSearchResult> result = this.RunWithRefresh(t -> this.api.searchAddress(address, countryCode, (String)t));
            return result == null ? this.FeatureDisabledResponse() : result;
        }
        return this.FeatureDisabledResponse();
    }

    public KleberModels.KleberResponse<KleberModels.DtResponse.AddressRetrieveResult> RetrieveAddress(String recordId) throws KleberApiException {
        return this.RunWithRefresh(t -> this.api.retrieveAddress(recordId, (String)t));
    }

    public KleberModels.KleberResponse<KleberModels.DtResponse.AddressVerifyResult> VerifyAddress(KleberModels.DtResponse.Address req, String countryCode) throws KleberApiException {
        if (this.AddressValidationEnabledForCountry(countryCode)) {
            KleberModels.KleberResponse<KleberModels.DtResponse.AddressVerifyResult> result = this.RunWithRefresh(t -> this.api.verifyAddress(req, countryCode, (String)t));
            return result == null ? this.FeatureDisabledResponse() : result;
        }
        return this.FeatureDisabledResponse();
    }

    private <T> KleberModels.KleberResponse<T> FeatureDisabledResponse() {
        KleberModels.KleberResponse response = new KleberModels.KleberResponse();
        response.FeatureEnabled = false;
        return response;
    }

    @FunctionalInterface
    public static interface KleberAPIFunction<T, R> {
        public R run(T var1) throws KleberApiException;
    }
}

