/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import jpos.SP;
import jpos.StringUtils;
import jpos.labelprinting.LabelEnums;

public class LabelFormat {
    public static final String DEFAULT_TEMPLATE_FILENAME = "DefaultCsvLabelTemplate.properties";
    private String name;
    private String standardTemplate;
    private String markdownTemplate;
    private String headerTemplate;
    private String validationError;
    private Boolean isDefaultFormat = false;
    private Vector<LabelEnums.PrintLevel> printlevels = new Vector();

    public String getStandardTemplate() {
        return StringUtils.nullToEmpty(this.standardTemplate);
    }

    public String getMarkdownTemplate() {
        return !StringUtils.isNullOrEmpty(this.markdownTemplate) ? this.markdownTemplate : this.getStandardTemplate();
    }

    public String getHeaderTemplate() {
        return StringUtils.nullToEmpty(this.headerTemplate);
    }

    public String getTemplate(boolean isProductMarkedDown) {
        if (isProductMarkedDown) {
            return this.getMarkdownTemplate();
        }
        return this.getStandardTemplate();
    }

    public LabelFormat(String name, String standardTemplate, String markdownTemplate, String headerTemplate) {
        this.name = name;
        this.standardTemplate = !StringUtils.isNullOrEmpty(standardTemplate) ? standardTemplate : DEFAULT_TEMPLATE_FILENAME;
        this.markdownTemplate = markdownTemplate;
        this.headerTemplate = headerTemplate;
        this.validationError = "";
    }

    public LabelFormat(String filename) {
        this.name = SP.getRS("Label_Print_Default_Name");
        if (StringUtils.isNullOrEmpty(filename)) {
            filename = DEFAULT_TEMPLATE_FILENAME;
        }
        this.standardTemplate = this.readFileText(filename);
        this.validationError = "";
    }

    public LabelFormat copy() {
        LabelFormat copy = new LabelFormat(this.name, this.standardTemplate, this.markdownTemplate, this.headerTemplate);
        for (LabelEnums.PrintLevel level : this.printlevels) {
            copy.addPrintLevel(level);
        }
        copy.validationError = this.validationError;
        return copy;
    }

    public boolean hasMarkdownTemplate() {
        return !StringUtils.isNullOrEmpty(this.markdownTemplate);
    }

    public boolean hasHeaderTemplate() {
        return !StringUtils.isNullOrEmpty(this.headerTemplate);
    }

    public boolean validate() {
        this.validationError = "";
        if (this.getStandardTemplate().isEmpty()) {
            this.validationError = SP.getRS("Label_Print_Template_File_Doesnt_Exist_Verbose", this.toString());
            return false;
        }
        return true;
    }

    public String getValidationError() {
        return StringUtils.nullToEmpty(this.validationError);
    }

    public String toString() {
        return StringUtils.nullToEmpty(this.name);
    }

    private String readFileText(String fileName) {
        char[] chr = new char[4096];
        StringBuffer buffer = new StringBuffer();
        try (FileReader reader = new FileReader(fileName);){
            int len;
            while ((len = reader.read(chr)) > 0) {
                buffer.append(chr, 0, len);
            }
        }
        catch (IOException e) {
            return null;
        }
        return buffer.toString().trim();
    }

    public Vector<LabelEnums.PrintLevel> getPrintLevels() {
        return this.printlevels;
    }

    public void addPrintLevel(LabelEnums.PrintLevel level) {
        if (!this.printlevels.contains((Object)level)) {
            this.printlevels.add(level);
        }
    }

    public Boolean getIsDefaultFormat() {
        return this.isDefaultFormat;
    }

    public void setIsDefaultFormat(Boolean isDefaultFormat) {
        this.isDefaultFormat = isDefaultFormat;
    }
}

