/*
 * Decompiled with CFR 0.152.
 */
package jpos.labelprinting;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.StringUtils;
import jpos.labelprinting.HeaderLabel;
import jpos.labelprinting.LabelEnums;
import jpos.labelprinting.LabelFormat;
import jpos.labelprinting.PrinterLabel;
import jpos.labelprinting.SkuLabel;

public class PrinterLabelFactory {
    public static final String SKU_LABEL_KEY = "K";
    public static final String HEADER_LABEL_KEY = "H";
    private static final String UNICODE_END_OF_TEXT = "\u0003";
    private static final String BULK_PRINT_PROC = "POSREPS.BulkLabelPrint";
    private static final String BYPASS_GENREP_CHECK_STRING = "-1";

    /*
     * Exception decompiling
     */
    public static SkuLabel createSkuLabel(long skuidx, Timestamp priceDate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static HeaderLabel createHeaderLabel(String rcIdxList) {
        String[] rcIdxListSplit = StringUtils.nullToEmpty(rcIdxList).split(",", -1);
        Vector<Reference> referenceList = new Vector<Reference>();
        for (String rcIdxStr : rcIdxListSplit) {
            long rcIdx = PosUtils.longVal(rcIdxStr);
            if (rcIdx > 0L) {
                referenceList.add(new Reference(rcIdx));
                continue;
            }
            referenceList.add(new Reference("", "", 0L));
        }
        return !referenceList.isEmpty() ? new HeaderLabel(referenceList) : null;
    }

    public static PrinterLabel createLabel(String labelData) {
        return PrinterLabelFactory.createLabel(labelData, null);
    }

    public static PrinterLabel createLabel(String labelData, Timestamp labelDate) {
        String[] keyVal = StringUtils.nullToEmpty(labelData).split(":");
        if (labelDate == null) {
            labelDate = new Timestamp(new Date().getTime());
        }
        switch (keyVal[0].trim().toUpperCase()) {
            case "H": {
                if (keyVal.length < 2) {
                    return null;
                }
                return PrinterLabelFactory.createHeaderLabel(keyVal[1]);
            }
            case "K": {
                if (keyVal.length < 2) {
                    return null;
                }
                String[] skuAndQty = keyVal[1].split(",");
                long skuIdx = PosUtils.longVal(skuAndQty[0]);
                if (skuIdx > 0L) {
                    SkuLabel label = PrinterLabelFactory.createSkuLabel(skuIdx, labelDate);
                    if (label != null && skuAndQty.length > 1) {
                        int qty = Math.max(PosUtils.intVal(skuAndQty[1]), 1);
                        label.setPrintQuantity(qty);
                    }
                    return label;
                }
                return null;
            }
        }
        return null;
    }

    public static Vector<PrinterLabel> createLabelList(String allLabelData, LabelFormat format, Timestamp labelDate, int qtyPerUnit, float extraFactor) {
        Vector<PrinterLabel> labels = new Vector<PrinterLabel>();
        LabelFormat formatCopy = format != null ? format.copy() : null;
        Timestamp labelDateCopy = labelDate != null ? new Timestamp(labelDate.getTime()) : null;
        for (String labelData : allLabelData.split(";")) {
            PrinterLabel label = PrinterLabelFactory.createLabel(labelData, labelDateCopy);
            if (label == null) continue;
            label.setLabelFormat(formatCopy);
            label.setPrintQuantity(Math.round((float)(label.getPrintQuantity() * qtyPerUnit) * extraFactor));
            labels.add(label);
        }
        return labels;
    }

    public static Vector<PrinterLabel> executeBulkLabelReport(LabelFormat format, Timestamp priceDate, int qtyPerUnit, LabelEnums.PrintLevel printLevel, float extraFactor, String sqlWhere, long memIdx) throws ReportException {
        String result;
        StringBuffer repCommand = new StringBuffer();
        repCommand.append(memIdx);
        repCommand.append(UNICODE_END_OF_TEXT);
        repCommand.append(1);
        repCommand.append(UNICODE_END_OF_TEXT);
        repCommand.append(BYPASS_GENREP_CHECK_STRING);
        repCommand.append(UNICODE_END_OF_TEXT);
        repCommand.append(sqlWhere);
        repCommand.append(UNICODE_END_OF_TEXT);
        repCommand.append(" ");
        repCommand.append(UNICODE_END_OF_TEXT);
        repCommand.append(printLevel.getKey());
        repCommand.append(UNICODE_END_OF_TEXT);
        try {
            result = SP.sParams.OnlineReportProvider.executeAndReturnReport(BULK_PRINT_PROC, repCommand.toString());
        }
        catch (Exception e) {
            throw new ReportException(SP.getRS("Label_Print_Bulk_Report_Error"), e);
        }
        int startIndex = result.indexOf(33);
        int endIndex = result.lastIndexOf(33);
        if (startIndex < 0 || startIndex == endIndex) {
            throw new ReportException(SP.getRS("Label_Print_Bulk_Report_Format_Error"));
        }
        result = result.substring(startIndex + 1, endIndex);
        return PrinterLabelFactory.createLabelList(result, format, priceDate, qtyPerUnit, extraFactor);
    }

    public static class ReportException
    extends Exception {
        public ReportException(String message) {
            super(message);
        }

        public ReportException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

