/*
 * Decompiled with CFR 0.152.
 */
package jpos.omneo;

import com.teamdev.jxbrowser.browser.callback.InjectJsCallback;
import com.teamdev.jxbrowser.browser.event.TitleChanged;
import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.js.JsAccessible;
import com.teamdev.jxbrowser.js.JsObject;
import com.teamdev.jxbrowser.navigation.event.FrameLoadFailed;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.RestRequest;
import jpos.SP;
import jpos.browser.BrowserControl;
import jpos.omneo.OmneoLoyaltySetup;
import jpos.omneo.OmneoUtils;

public class DlgOmneoPerson
extends JDialog
implements AutoCloseable,
KeyEventDispatcher {
    private String baseUrl;
    private BrowserControl browserControl;
    private long peridx;
    private String cardNumber;
    private String docketNumber;
    private PosFrame parent;
    private boolean failedToLoad = false;
    private boolean personSelected = false;

    public DlgOmneoPerson(PosFrame parent) {
        super(parent, SP.getRS("Loading_dots"), true);
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    DlgOmneoPerson.this.setVisible(false);
                }
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        OmneoLoyaltySetup setup = new OmneoLoyaltySetup();
        this.baseUrl = RestRequest.formatBaseURL(setup.getPersonScreenUrl());
        this.browserControl = new BrowserControl();
        this.browserControl.getBrowser().set(InjectJsCallback.class, (Callback)((InjectJsCallback)params -> {
            JsObject value = (JsObject)params.frame().executeJavaScript("window");
            value.putProperty("storeportal", (Object)new JavaBridge());
            return InjectJsCallback.Response.proceed();
        }));
        this.browserControl.getBrowser().navigation().on(FrameLoadFailed.class, event -> {
            if (event.frame().isMain()) {
                this.failedToLoad = true;
                this.setVisible(false);
            }
        });
        this.browserControl.getBrowser().on(TitleChanged.class, event -> this.setTitle(event.browser().title()));
        this.add(this.browserControl);
        Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        this.setSize((int)((double)screenSize.width * 0.8), screenSize.height);
        this.browserControl.initialiseSplitterPosition(screenSize.height);
        PosUtils.centreWindow(this);
    }

    public void setPersonFromAp21(long peridx) {
        this.peridx = peridx;
        this.cardNumber = OmneoUtils.getCardNumberFromDatabase(this.peridx);
    }

    private void setPersonFromOmneo(String cardNumber) {
        this.cardNumber = cardNumber;
        this.peridx = OmneoUtils.getPeridxFromDatabase(this.cardNumber);
        this.personSelected = true;
    }

    public long getPersonId() {
        return this.peridx;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getDocketNumber() {
        return this.docketNumber;
    }

    public void loadPage() {
        String url = this.baseUrl + "/";
        if (this.cardNumber != null && this.cardNumber.length() > 0) {
            url = url + this.cardNumber + "/";
        }
        url = url + "?storeID=" + SP.sParams.getStore(SP.sParams.getStoreIdx()).getCode();
        url = url + "&staffID=" + this.parent.getUser().getMemidx();
        url = url + "&terminalID=" + SP.sParams.tillnum;
        url = url + "&type=POS";
        this.browserControl.loadURL(url);
    }

    public boolean hasFailedToLoad() {
        return this.failedToLoad;
    }

    public boolean isPersonSelected() {
        return this.personSelected;
    }

    @Override
    public void close() throws Exception {
        if (this.browserControl != null) {
            this.browserControl.disposeBrowserObjects();
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (this.isActive()) {
            this.processKeyEvent(e);
        }
        return false;
    }

    public class JavaBridge {
        @JsAccessible
        public void memberProfile_addToSale(String memberID) {
            DlgOmneoPerson.this.setPersonFromOmneo(memberID);
            DlgOmneoPerson.this.setVisible(false);
        }

        @JsAccessible
        public void memberProfile_returnToPOS() {
            DlgOmneoPerson.this.setVisible(false);
        }

        @JsAccessible
        public void memberProfile_loadTransaction(String memberID, String transactionID) {
            DlgOmneoPerson.this.docketNumber = transactionID;
            DlgOmneoPerson.this.setPersonFromOmneo(memberID);
            DlgOmneoPerson.this.setVisible(false);
        }
    }
}

