/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jpos.DecimalField;
import jpos.FrSales;
import jpos.PosFocusTraversalPolicy;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.PayType;
import jpos.pay.PayUtils;
import jpos.pay.RetTranP;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;

public class CustOrderCancelDlg
extends PayDialog {
    private GridBagLayout gridBagLayoutAll = new GridBagLayout();
    private GridBagLayout gridBagLayoutDets = new GridBagLayout();
    private JPanel panelDets = new JPanel(this.gridBagLayoutDets);
    private LabelNormal lTotalPayments = new LabelNormal();
    private DecimalField dfTotalPayments;
    private double totalPayments;
    private LabelNormal lRefund;
    private DecimalField dfRefund;
    private double refund;
    private GridBagLayout gridBagLayoutFooter;
    private JPanel panelFooter;
    private DialogButton bOk;
    private DialogButton bCancel;

    public CustOrderCancelDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfTotalPayments = new DecimalField(SP.sParams.storeCurrency);
        this.lRefund = new LabelNormal();
        this.dfRefund = new DecimalField(SP.sParams.storeCurrency);
        this.gridBagLayoutFooter = new GridBagLayout();
        this.panelFooter = new JPanel(this.gridBagLayoutFooter);
        this.bOk = new DialogButton("", this);
        this.bCancel = new DialogButton("", this);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.lTotalPayments.setText(SP.getRS("total_payments"));
        this.dfTotalPayments.setEnabled(false);
        this.lRefund.setText(SP.getRS("refund"));
        this.dfRefund.setEnabled(false);
        this.panelDets.setBorder(BorderFactory.createEtchedBorder());
        this.panelDets.add((Component)this.lTotalPayments, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 50, 0));
        this.panelDets.add((Component)this.dfTotalPayments, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(20, 10, 10, 20), 160, 0));
        this.panelDets.add((Component)this.lRefund, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 50, 0));
        this.panelDets.add((Component)this.dfRefund, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 160, 0));
        this.dfTotalPayments.setText("");
        this.dfRefund.setText("");
        this.setOkButton(this.bOk);
        this.setCancelButton(this.bCancel);
        this.panelFooter.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.setLayout(this.gridBagLayoutFooter);
        this.panelAll.setLayout(this.gridBagLayoutAll);
        this.panelAll.add((Component)this.panelDets, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 10, 20), 1, 1));
        this.panelAll.add((Component)this.panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 1, 1));
        this.getContentPane().add(this.panelAll);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.bOk);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    @Override
    public boolean initDialog() {
        this.populateFields();
        return super.initDialog();
    }

    private void populateFields() {
        this.dfTotalPayments.setText(this.totalPayments);
        this.dfRefund.setText(this.refund);
    }

    public double getRefundAmt() {
        return this.refund;
    }

    @Override
    public void okDialog() {
        this.refund = this.dfRefund.getDouble();
        super.okDialog();
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    public void setOrderDets(List<?> pOldTendersXML) {
        Vector<RetTranP> vOldRetTranPs = new Vector<RetTranP>();
        this.totalPayments = PayUtils.tendersXMLToVRetTranPs(pOldTendersXML, vOldRetTranPs);
        this.setOrderDets(this.totalPayments);
    }

    public void setOrderDets(double pTotalPayments) {
        this.totalPayments = pTotalPayments;
        this.refund = PayType.roundDec(this.totalPayments);
        this.lTotalPayments.setText(SP.getRS("total_payments"));
        this.setTitle(SP.getRS("cancel_customer_order"));
    }

    @Override
    protected boolean myKeyPressed(KeyEvent k) {
        return false;
    }
}

