/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.DecimalField;
import jpos.FrSales;
import jpos.PosDateField;
import jpos.PosDateFormatter;
import jpos.PosFocusTraversalPolicy;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.SP;
import jpos.TransTypes;
import jpos.pay.PayDialog;
import jpos.pay.PayHistTM;
import jpos.pay.PayHistTbl;
import jpos.pay.PayUtils;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class OrderHistoryDlg
extends PayDialog {
    private GridBagLayout gridBagLayoutAll = new GridBagLayout();
    private LabelSubHeading lOrderNumber = new LabelSubHeading();
    private GridBagLayout gridBagLayoutDates = new GridBagLayout();
    private JPanel panelDates = new JPanel(this.gridBagLayoutDates);
    private LabelNormal lNextPayDate = new LabelNormal();
    private PosDateField dfNextPayDate = new PosDateField(this);
    private PosDateFormatter nextPayDate = new PosDateFormatter(null, 3, 3, 0);
    private DialogButton bNextPayDate = new DialogButton("", this);
    private LabelNormal lFinalPayDate = new LabelNormal();
    private PosDateField dfFinalPayDate = new PosDateField(this);
    private PosDateFormatter finalPayDate = new PosDateFormatter(null, 3, 3, 0);
    private DialogButton bFinalPayDate = new DialogButton("", this);
    private GridBagLayout gridBagLayoutDets = new GridBagLayout();
    private JPanel panelDets = new JPanel(this.gridBagLayoutDets);
    private LabelSubHeading lOrderTotal = new LabelSubHeading();
    private DecimalField dfOrderTotal;
    private double orderTotal;
    private PayHistTM payHistTM;
    private PayHistTbl payHistTbl;
    private PosScrollPane spPayHist;
    private LabelSubHeading lTotalPaid;
    private DecimalField dfTotalPaid;
    private double totalPaid;
    private LabelSubHeading lOutstanding;
    private DecimalField dfOutstanding;
    private double outstanding;
    private GridBagLayout gridBagLayoutFooter;
    private JPanel panelFooter;
    private DialogButton bOk;
    private DialogButton bCancel;
    private String laybyNumber;
    private boolean allowChangeLaybyDate;
    private boolean editable;
    private boolean cancelledLayby;
    private int transType;

    public OrderHistoryDlg(FrSales parentFrame, String title) {
        super((Frame)parentFrame, title);
        this.dfOrderTotal = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.payHistTM = new PayHistTM();
        this.payHistTbl = new PayHistTbl(this.payHistTM);
        this.spPayHist = new PosScrollPane(this.payHistTbl);
        this.lTotalPaid = new LabelSubHeading();
        this.dfTotalPaid = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.lOutstanding = new LabelSubHeading();
        this.dfOutstanding = new DecimalField(SP.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.gridBagLayoutFooter = new GridBagLayout();
        this.panelFooter = new JPanel(this.gridBagLayoutFooter);
        this.bOk = new DialogButton("", this){

            @Override
            public int getButtonWidth() {
                return 200;
            }
        };
        this.bCancel = new DialogButton("", this);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.panelAll.setLayout(this.gridBagLayoutAll);
        this.initPanelDates();
        this.initPanelDetails();
        this.initPanelFooter();
        this.panelAll.add((Component)this.lOrderNumber, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(20, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelDates, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(20, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelDets, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 1, new Insets(10, 20, 10, 20), 0, 0));
        this.panelAll.add((Component)this.panelFooter, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add(this.panelAll);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void initPanelDates() {
        this.lNextPayDate.setText(SP.getRS("next_payment_due"));
        this.setDateFieldProp(this.dfNextPayDate);
        this.dfNextPayDate.setEnabled(false);
        this.dfNextPayDate.setDisabledTextColor(Colours.BLACK);
        this.bNextPayDate.setText(SP.getRS("F7_change_date"));
        this.bNextPayDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!OrderHistoryDlg.this.isRunning && OrderHistoryDlg.this.isVisible()) {
                    OrderHistoryDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OrderHistoryDlg.this.changeNextLaybyDate();
                            OrderHistoryDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.lFinalPayDate.setText(SP.getRS("final_payment_due"));
        this.setDateFieldProp(this.dfFinalPayDate);
        this.dfFinalPayDate.setEnabled(false);
        this.dfFinalPayDate.setDisabledTextColor(Colours.BLACK);
        this.bFinalPayDate.setText(SP.getRS("F5_change_date"));
        this.bFinalPayDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!OrderHistoryDlg.this.isRunning && OrderHistoryDlg.this.isVisible()) {
                    OrderHistoryDlg.this.isRunning = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OrderHistoryDlg.this.changeFinalLaybyDate();
                            OrderHistoryDlg.this.isRunning = false;
                        }
                    });
                }
            }
        });
        this.panelDates.setBorder(BorderFactory.createEtchedBorder());
        this.panelDates.add((Component)this.lNextPayDate, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelDates.add((Component)this.dfNextPayDate, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(20, 10, 10, 10), 0, 0));
        this.panelDates.add((Component)this.bNextPayDate, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(20, 10, 10, 20), 0, 0));
        this.panelDates.add((Component)this.lFinalPayDate, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 20, 20, 10), 0, 0));
        this.panelDates.add((Component)this.dfFinalPayDate, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelDates.add((Component)this.bFinalPayDate, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 10, 20, 20), 0, 0));
        this.dfNextPayDate.setValue("");
        this.dfFinalPayDate.setValue("");
    }

    private void initPanelDetails() {
        this.lOrderTotal.setText(SP.getRS("layby_total"));
        this.setAmtFieldProp(this.dfOrderTotal);
        this.dfOrderTotal.setEnabled(false);
        this.payHistTbl.revalidate();
        this.spPayHist.setPreferredSize(new Dimension(500, 100));
        this.spPayHist.setMinimumSize(new Dimension(500, 100));
        this.lTotalPaid.setText(SP.getRS("total_paid"));
        this.setAmtFieldProp(this.dfTotalPaid);
        this.dfTotalPaid.setEnabled(false);
        this.lOutstanding.setText(SP.getRS("balance_due"));
        this.setAmtFieldProp(this.dfOutstanding);
        this.dfOutstanding.setEnabled(false);
        this.panelDets.setBorder(BorderFactory.createEtchedBorder());
        this.panelDets.add((Component)new LabelNormal(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.lOrderTotal, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(20, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfOrderTotal, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(20, 10, 10, 20), 0, 0));
        this.panelDets.add((Component)this.spPayHist, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(10, 20, 10, 20), 0, 100));
        this.panelDets.add((Component)this.lTotalPaid, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfTotalPaid, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.panelDets.add((Component)this.lOutstanding, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 20, 10, 10), 0, 0));
        this.panelDets.add((Component)this.dfOutstanding, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 20), 0, 0));
        this.dfOrderTotal.setText("");
        this.dfTotalPaid.setText("");
        this.dfOutstanding.setText("");
    }

    private void initPanelFooter() {
        this.setOkButton(this.bOk);
        this.bOk.setText(SP.getRS("return_to_layby"));
        this.setCancelButton(this.bCancel);
        this.panelFooter.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 20, 10), 0, 0));
        this.panelFooter.setLayout(this.gridBagLayoutFooter);
    }

    @Override
    public boolean initDialog() {
        this.allowChangeLaybyDate = !this.editable ? false : this.frSales.hasSecurity(11131L, 0);
        this.populateFields();
        return super.initDialog();
    }

    private void populateFields() {
        if (this.nextPayDate.getTimestamp() != null) {
            this.dfNextPayDate.setValue(new Timestamp(this.nextPayDate.getTime()));
        } else {
            this.dfNextPayDate.setValue("");
        }
        if (this.finalPayDate.getTimestamp() != null) {
            this.dfFinalPayDate.setValue(new Timestamp(this.finalPayDate.getTime()));
        } else {
            this.dfFinalPayDate.setValue("");
        }
        this.lOrderNumber.setForeground(Colours.BLACK);
        if (this.cancelledLayby) {
            this.lOrderTotal.setVisible(false);
            this.dfOrderTotal.setVisible(false);
            this.dfOutstanding.setVisible(false);
            this.lOutstanding.setVisible(false);
            this.lOrderNumber.setText(SP.getRS("Cancelled") + " " + this.laybyNumber);
        } else {
            this.lOrderTotal.setVisible(true);
            this.dfOrderTotal.setVisible(true);
            this.lOutstanding.setVisible(true);
            this.dfOutstanding.setVisible(true);
            this.dfOrderTotal.setText(this.orderTotal);
            this.dfOutstanding.setText(this.outstanding);
            Timestamp dTmp = new Timestamp(new java.util.Date().getTime());
            PosDateFormatter.truncateTime(dTmp);
            if (TransTypes.isLayby(this.transType) && this.nextPayDate.getTimestamp() != null && this.nextPayDate.getTime() < dTmp.getTime()) {
                this.lOrderNumber.setText(SP.getRS("Overdue1") + " " + this.laybyNumber);
                this.lOrderNumber.setForeground(Colours.RED);
            } else {
                this.lOrderNumber.setText(this.laybyNumber);
            }
        }
        this.dfTotalPaid.setText(this.totalPaid);
        this.bNextPayDate.setEnabled(this.allowChangeLaybyDate);
        this.bFinalPayDate.setEnabled(this.allowChangeLaybyDate);
    }

    @Override
    public void okDialog() {
        if (this.allowChangeLaybyDate) {
            long newFinalPayDate;
            long newNextPayDate;
            try {
                newNextPayDate = this.dfNextPayDate.getDateFormatter().getTime();
            }
            catch (Exception ex) {
                this.dfNextPayDate.requestFocus();
                this.dfNextPayDate.selectAll();
                return;
            }
            try {
                newFinalPayDate = this.dfFinalPayDate.getDateFormatter().getTime();
            }
            catch (Exception ex) {
                this.dfFinalPayDate.requestFocus();
                this.dfFinalPayDate.selectAll();
                return;
            }
            if (newNextPayDate > newFinalPayDate) {
                newNextPayDate = newFinalPayDate;
                this.dfNextPayDate.setValue(new Timestamp(newFinalPayDate));
                return;
            }
            this.nextPayDate.setTime(newNextPayDate);
            this.finalPayDate.setTime(newFinalPayDate);
        }
        super.okDialog();
    }

    @Override
    public boolean myKeyPressed(KeyEvent k) {
        if (k.getKeyCode() == 116) {
            this.bFinalPayDate.doClick();
            return true;
        }
        if (k.getKeyCode() == 118) {
            this.bNextPayDate.doClick();
            return true;
        }
        return false;
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    public void setOrderDets(boolean pEditable, boolean pCanceled, int transType, String pOrderNumber, double pOrderTotal, Date pNextPayDate, Date pFinalPayDate, List<?> pOldTendersXML) {
        this.editable = pEditable;
        this.cancelledLayby = pCanceled;
        this.transType = transType;
        this.laybyNumber = pOrderNumber;
        if (TransTypes.isLayby(transType)) {
            this.nextPayDate.setTime(pNextPayDate.getTime());
            this.finalPayDate.setTime(pFinalPayDate.getTime());
            this.setTitle(SP.getRS("layby_history"));
            this.lOrderTotal.setText(SP.getRS("layby_total"));
            this.bOk.setText(SP.getRS("return_to_layby"));
            this.panelDates.setVisible(true);
        } else if (TransTypes.isSpecialOrder(transType)) {
            this.setTitle(SP.getRS("special_order_history"));
            this.lOrderTotal.setText(SP.getRS("special_order_total"));
            this.bOk.setText(SP.getRS("return_to_special_order"));
            this.panelDates.setVisible(false);
        } else if (TransTypes.isCustOrder(transType)) {
            this.setTitle(SP.getRS("customer_order_history"));
            this.lOrderTotal.setText(SP.getRS("customer_order_total"));
            this.bOk.setText(SP.getRS("return_to_customer_order"));
            this.panelDates.setVisible(false);
        }
        this.orderTotal = pOrderTotal;
        this.totalPaid = PayUtils.tendersXMLToVRetTranPs(pOldTendersXML, this.payHistTM.getRetTranPs());
        this.payHistTM.fireTableDataChanged();
        this.outstanding = this.orderTotal - this.totalPaid;
    }

    public void changeNextLaybyDate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OrderHistoryDlg.this.frSales != null && OrderHistoryDlg.this.frSales.isLoggedIn(false)) {
                    OrderHistoryDlg.this.dfNextPayDate.actionSearch();
                }
            }
        });
    }

    public void changeFinalLaybyDate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (OrderHistoryDlg.this.frSales != null && OrderHistoryDlg.this.frSales.isLoggedIn(false)) {
                    OrderHistoryDlg.this.dfFinalPayDate.actionSearch();
                }
            }
        });
    }

    public Date getNextPayDate() {
        return new Date(this.nextPayDate.getTime());
    }

    public Date getFinalPayDate() {
        return new Date(this.finalPayDate.getTime());
    }

    public boolean getAllowChangeLaybyDate() {
        return this.allowChangeLaybyDate;
    }
}

