/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import jpos.SP;

public class Printer {
    private String posPrint;
    private PrintService[] services;
    private Pattern portPattern;
    private Matcher portMatcher;
    private Pattern serverPattern;
    private Matcher serverMatcher;
    private Pattern filePattern;
    private Matcher fileMatcher;
    private static final String PORT_PATTERN = "^(LPT\\d{1,}|COM\\d{1,}|PRN).*$";
    private static final String FILE_PATTERN = "^(\\w+)(:[\\\\|/])(.*)$";
    private static final String SERVER_SHARENAME_PATTERN = "^([\\\\|/]{2,})(.+?)([\\\\|/]{1,})(.+?)(([\\\\|/]{1,})(.*?))*$";
    private static final List<String> LOCALHOST = Arrays.asList("localhost", "127.0.0.1");
    private static final boolean isOnline = true;

    public Printer() {
        this.posPrint = SP.sParams.printerPort;
        this.services = PrintServiceLookup.lookupPrintServices(null, null);
    }

    public Boolean checkPrinter() {
        PrintService service = null;
        this.portPattern = Pattern.compile(PORT_PATTERN);
        this.portMatcher = this.portPattern.matcher(this.posPrint.toUpperCase());
        this.serverPattern = Pattern.compile(SERVER_SHARENAME_PATTERN);
        this.serverMatcher = this.serverPattern.matcher(this.posPrint);
        this.filePattern = Pattern.compile(FILE_PATTERN);
        this.fileMatcher = this.filePattern.matcher(this.posPrint);
        try {
            if (this.portMatcher.find()) {
                return true;
            }
            if (this.fileMatcher.find()) {
                return true;
            }
            service = this.serverMatcher.find() ? this.getPrintServiceByServerPath() : this.getPrintServiceByPrinterName(this.posPrint);
        }
        catch (Exception e) {
            return true;
        }
        if (service == null) {
            return true;
        }
        if (this.getIsPrinterAcceptingJobs(service).booleanValue()) {
            try {
                if (Integer.parseInt(this.getPrinterStatus(service.getName())) == 1) {
                    return false;
                }
                return true;
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    private Boolean getIsPrinterAcceptingJobs(PrintService service) {
        PrinterIsAcceptingJobs acceptingJobs = (PrinterIsAcceptingJobs)service.getAttributes().get(PrinterIsAcceptingJobs.class);
        return acceptingJobs != null && acceptingJobs.getValue() == 1;
    }

    private PrintService getPrintServiceByPrinterName(String prtName) throws Exception {
        for (int j = 0; j < this.services.length; ++j) {
            if (!this.services[j].getName().equals(prtName)) continue;
            return this.services[j];
        }
        return null;
    }

    private PrintService getPrintServiceByServerPath() throws Exception {
        String servPath = "";
        String namePath = "";
        String printerName = "";
        if (this.serverMatcher.matches()) {
            servPath = this.serverMatcher.group(2);
            namePath = this.serverMatcher.group(4);
            servPath = LOCALHOST.contains(servPath.toLowerCase()) ? this.getLocalHostName() : servPath;
            printerName = SP.sParams.PrinterProvider.getPrinterName(servPath, namePath);
        }
        if (!printerName.isEmpty()) {
            return this.getPrintServiceByPrinterName(printerName);
        }
        return null;
    }

    private String getPrinterStatus(String prtName) throws Exception {
        return SP.sParams.PrinterProvider.getPrinterStatus(prtName);
    }

    private String getLocalHostName() throws IOException {
        return InetAddress.getLocalHost().getHostName();
    }
}

