/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.afterpay;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import jpos.PosUtils;
import jpos.RestRequest;
import jpos.Settings;
import jpos.pay.afterpay.AfterpayOnlineAPIEntity;
import jpos.pay.afterpay.AfterpayOnlineAPIErrorException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;

public class AfterpayOnlineAPI {
    public static final String CREATE_REFUND_PATH = "/v1/payments/%s/refund";
    public static final String GET_ORDER_PATH = "/v1/payments/%s";
    public static final String AUTH_HEADER_PREFIX = "Basic ";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CHARSET_UTF8 = "utf-8";
    public static final RequestConfig TIMEOUT_OPEN10_READ20 = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(20000).build();
    public static final RequestConfig TIMEOUT_OPEN10_READ70 = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(Settings.getAfterpayOrderTimeout()).build();
    public static String refundError = "Failed to submit refund.";
    public static String orderError = "Failed to get order.";
    private String apiUrl;
    private String userAgent;
    private String authorisation;

    public AfterpayOnlineAPI(String apiUrl, String userAgent, String merchantId, String key) {
        this.apiUrl = RestRequest.formatBaseURL(apiUrl);
        this.userAgent = userAgent;
        try {
            this.authorisation = AUTH_HEADER_PREFIX + Base64.getEncoder().encodeToString((merchantId + ":" + key).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            PosUtils.logError(e);
        }
    }

    public AfterpayOnlineAPIEntity.RefundResponse createRefund(AfterpayOnlineAPIEntity.RefundRequest request, String orderId) throws AfterpayOnlineAPIErrorException {
        return AfterpayOnlineAPI.apiPost(AfterpayOnlineAPIEntity.RefundResponse.class, request, this.apiUrl + String.format(CREATE_REFUND_PATH, AfterpayOnlineAPI.UrlEncode(orderId)), this.getHeaders(), TIMEOUT_OPEN10_READ70, refundError, false);
    }

    public AfterpayOnlineAPIEntity.OrderResponse getOrder(String orderId) throws AfterpayOnlineAPIErrorException {
        return AfterpayOnlineAPI.apiGet(AfterpayOnlineAPIEntity.OrderResponse.class, this.apiUrl + String.format(GET_ORDER_PATH, AfterpayOnlineAPI.UrlEncode(orderId)), this.getHeaders(), TIMEOUT_OPEN10_READ20, orderError, false);
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", CONTENT_TYPE_JSON);
        headers.put("Accept", CONTENT_TYPE_JSON);
        headers.put("Accept-Charset", CHARSET_UTF8);
        headers.put("User-Agent", this.userAgent);
        headers.put("Authorization", this.authorisation);
        return headers;
    }

    private static String UrlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            PosUtils.logError(e);
            return value;
        }
    }

    private static <T> T apiGet(Class<T> responseClass, String url, Map<String, String> headers, RequestConfig reqConfig, String errorMsg, boolean secret) throws AfterpayOnlineAPIErrorException {
        return AfterpayOnlineAPI.apiRequest(responseClass, (HttpRequestBase)new HttpGet(url), null, headers, reqConfig, errorMsg, secret);
    }

    private static <T> T apiPost(Class<T> responseClass, Object request, String url, Map<String, String> headers, RequestConfig reqConfig, String errorMsg, boolean secret) throws AfterpayOnlineAPIErrorException {
        return AfterpayOnlineAPI.apiRequest(responseClass, (HttpRequestBase)new HttpPost(url), request, headers, reqConfig, errorMsg, secret);
    }

    private static <T> T apiRequest(Class<T> responseClass, HttpRequestBase requestBase, Object requestPayload, Map<String, String> headers, RequestConfig reqConfig, String errorMsg, boolean secret) throws AfterpayOnlineAPIErrorException {
        try {
            RestRequest rest = new RestRequest();
            if (reqConfig != null) {
                rest.setConfig(reqConfig);
            }
            if (requestPayload != null) {
                rest.setPostJson(requestPayload);
            }
            RestRequest.Response resp = rest.request(requestBase, headers, secret);
            Gson gson = new Gson();
            if (resp.isSuccess()) {
                return (T)(responseClass != null ? gson.fromJson(resp.Content, responseClass) : null);
            }
            AfterpayOnlineAPIEntity.ErrorResponse error = !resp.Content.isEmpty() ? (AfterpayOnlineAPIEntity.ErrorResponse)gson.fromJson(resp.Content, AfterpayOnlineAPIEntity.ErrorResponse.class) : new AfterpayOnlineAPIEntity.ErrorResponse("", "", "", resp.StatusCode);
            throw new AfterpayOnlineAPIErrorException(errorMsg, error);
        }
        catch (IOException e) {
            throw new AfterpayOnlineAPIErrorException(errorMsg, e);
        }
    }
}

