/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.openpay;

import bass.eftpos.ETran;
import java.util.Vector;
import jpos.SP;
import jpos.StyleLine;
import jpos.pay.openpay.CartItem;
import jpos.pay.openpay.CustomerJourney;
import jpos.pay.openpay.Openpay;

public class OpenpayTran
extends ETran {
    private CustomerJourney customerJourney;
    private OpenpayStatus openpayStatus;
    private String salesRepName;
    private Vector<CartItem> cart;

    public OpenpayTran(boolean refund, double amount) throws Exception {
        super("", refund, amount, 0.0, SP.sParams.storeCurrency.getCode().toUpperCase(), "");
    }

    public String toString() {
        return "Openpay Tran\nRefund: " + this.getRefund() + "\nAmount: " + this.getAmount() + "\nOpenpay Order Id: " + this.getStan();
    }

    public String getSalesRepName() {
        return this.salesRepName;
    }

    public void setSalesRepName(String salesRepName) {
        this.salesRepName = salesRepName;
    }

    public CustomerJourney getCustomerJourney() {
        return this.customerJourney;
    }

    public void setCustomerJourney(String salesRep, String customerId) {
        this.customerJourney = new CustomerJourney("PosApp", null, salesRep, customerId);
    }

    public OpenpayStatus getOpenpayStatus() {
        return this.openpayStatus;
    }

    public void setOpenpayStatus(Openpay.OrderStatus orderStatus, Openpay.PlanStatus planStatus) {
        this.openpayStatus = new OpenpayStatus(orderStatus, planStatus);
    }

    public void setCustomerId(String customerId) {
        this.customerJourney.PosApp.CustomerId = customerId;
    }

    public void setCart(Vector<StyleLine> styleLines) {
        this.cart = new Vector();
        for (int i = 0; i < styleLines.size(); ++i) {
            StyleLine line = styleLines.elementAt(i);
            if (!(line.getQty() > 0.0)) continue;
            int unitPrice = SP.sParams.bUsingExtendedTax ? (int)(SP.sParams.rnd((line.getPrice() - line.getDisc() / line.getQty()) * (1.0 + line.getExtTaxPer() / 100.0)) * 100.0) : (int)(SP.sParams.rnd(line.getPrice() - line.getDisc() / line.getQty()) * 100.0);
            int lineAmount = (int)((double)unitPrice * line.getQty());
            this.cart.add(new CartItem(line.getSkuDescription(), line.getSkuCode(), unitPrice, line.getQty(), lineAmount));
        }
    }

    public Vector<CartItem> getCart() {
        return this.cart;
    }

    public class OpenpayStatus {
        public Openpay.OrderStatus OrderStatus;
        public Openpay.PlanStatus PlanStatus;

        public OpenpayStatus(Openpay.OrderStatus orderStatus, Openpay.PlanStatus planStatus) {
            this.OrderStatus = orderStatus;
            this.PlanStatus = planStatus;
        }
    }
}

