/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.qantas;

import bass.eftpos.ETran;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import jpos.SP;
import jpos.basscom.utils.Utils;
import jpos.pay.qantas.QantasTransactionStatus;

public class QantasTransaction
extends ETran {
    private String membershipNumber;
    private String transactionNumber;
    private String ap21QantasTransId;
    private String burnReference;
    private int timeout;
    private int undoRetryCount = 0;
    private QantasTransactionStatus status = QantasTransactionStatus.Created;
    private int version = 0;
    private boolean burnSelected = false;
    private int pointsBurnt;
    private double dollarValue;
    private String receipt = "";

    public QantasTransaction(boolean refund, double amount) throws Exception {
        super("", refund, amount, 0.0, SP.sParams.storeCurrency.getCode().toUpperCase(), "");
    }

    public String getMembershipNumber() {
        return this.membershipNumber;
    }

    public void setMembershipNumber(String membershipNumber) {
        this.membershipNumber = membershipNumber;
    }

    public String getTransactionNumber() {
        return this.transactionNumber;
    }

    public String getBurnReference() {
        return this.burnReference;
    }

    public void setBurnReference(String burnReference) {
        this.burnReference = burnReference;
    }

    public boolean isBurnSelected() {
        return this.burnSelected;
    }

    public void setBurnSelected(boolean burn) {
        this.burnSelected = burn;
    }

    public void setQantasTransactionId(String id) {
        this.transactionNumber = id;
    }

    public String getAp21TransactionId() {
        return this.ap21QantasTransId;
    }

    public void setAp21TransactionId(String id) {
        this.ap21QantasTransId = id;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int time) {
        this.timeout = time;
    }

    public QantasTransactionStatus getStatus() {
        return this.status;
    }

    public void setStatus(QantasTransactionStatus newStatus) {
        this.status = newStatus;
    }

    public int getPointsBurnt() {
        return this.pointsBurnt;
    }

    public void setPointsBurnt(int points) {
        this.pointsBurnt = points;
    }

    public double getSelectedValue() {
        return this.dollarValue;
    }

    public void setSelectedValue(double value) {
        this.dollarValue = value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int value) {
        this.version = value;
    }

    public String getReceipt() {
        return this.receipt;
    }

    public void addUndoRetryCount() {
        ++this.undoRetryCount;
    }

    public int getUndoRetryCount() {
        return this.undoRetryCount;
    }

    public void generateReceipt() {
        DecimalFormat decFormatter = new DecimalFormat("#,##0.00");
        StringBuilder receipt = new StringBuilder();
        receipt.append("-----------------------------------");
        receipt.append("\r\n");
        receipt.append("          QANTAS POINTS");
        receipt.append("\r\n");
        receipt.append("Date                       ");
        receipt.append(new SimpleDateFormat("dd/MM/yy").format(new Date()).toUpperCase());
        receipt.append("\r\n");
        receipt.append("Time                       ");
        receipt.append(new SimpleDateFormat("HH:mm:ss").format(new Date()).toUpperCase());
        receipt.append("\r\n");
        receipt.append("\r\n");
        receipt.append("POINTS USED");
        String pointsBurnt = Integer.toString(this.pointsBurnt);
        receipt.append(Utils.padRight(pointsBurnt, " ", 24));
        receipt.append("\r\n");
        receipt.append("DOLLAR VALUE");
        String dollarValue = decFormatter.format(this.dollarValue);
        receipt.append(Utils.padRight(dollarValue, " ", 23));
        receipt.append("\r\n");
        receipt.append("             -------");
        receipt.append("\r\n");
        receipt.append("            COMPLETED");
        receipt.append("\r\n");
        receipt.append("\r\n");
        receipt.append("PLEASE RETAIN AS RECORD OF PURCHASE");
        receipt.append("\r\n");
        receipt.append("-----------------------------------");
        this.receipt = receipt.toString();
    }

    public static String maskCharacters(String input) {
        if (input == null || input.length() <= 6) {
            return input;
        }
        StringBuilder maskedString = new StringBuilder();
        maskedString.append(input.substring(0, 3));
        for (int i = 3; i < input.length() - 3; ++i) {
            maskedString.append("*");
        }
        maskedString.append(input.substring(input.length() - 3));
        return maskedString.toString();
    }
}

