/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.zip;

import bass.eftpos.ETran;
import java.time.Instant;
import jpos.SP;
import jpos.pay.zip.Order;
import jpos.pay.zip.ZipStatus;

public class ZipPayTran
extends ETran {
    private Instant requestAt;
    private Instant responseAt;
    private boolean needReverse;
    private String shopInStoreCode;
    private Order order;
    private String salesRepName;
    private ZipStatus zipStatus;

    public ZipPayTran(boolean refund, double amount) throws Exception {
        super("", refund, amount, 0.0, SP.sParams.storeCurrency.getCode().toUpperCase(), "");
    }

    public String toString() {
        return "ZipPay Tran\nRequest Id: " + this.getRequestId() + "\nReference: " + this.getReference() + "\nRefund: " + this.getRefund() + "\nAmount: " + this.getAmount() + "\nZipPay Receipt Num: " + this.getStan();
    }

    public Instant getRequestAt() {
        return this.requestAt;
    }

    public void setRequestAt(Instant requestAt) {
        this.requestAt = requestAt;
    }

    public Instant getResponseAt() {
        return this.responseAt;
    }

    public void setResponseAt(Instant responseAt) {
        this.requestAt = responseAt;
    }

    public boolean getNeedReverse() {
        return this.needReverse;
    }

    public void setNeedReverse(boolean needReverse) {
        this.needReverse = needReverse;
    }

    public String getShopInStoreCode() {
        return this.shopInStoreCode;
    }

    public void setShopInStoreCode(String shopInStoreCode) {
        this.shopInStoreCode = shopInStoreCode;
    }

    public void setAccountType(String accountType) {
        throw new UnsupportedOperationException();
    }

    public void setCardType(String cardType) {
        throw new UnsupportedOperationException();
    }

    public void setCashout(double cashout) {
        throw new UnsupportedOperationException();
    }

    public void setAuthCode(String authCode) {
        throw new UnsupportedOperationException();
    }

    public void setSettlement(String settlement) {
        throw new UnsupportedOperationException();
    }

    public void setReceipt(String receipt) {
        throw new UnsupportedOperationException();
    }

    public Order getOrder() {
        return this.order;
    }

    public String getSalesRepName() {
        return this.salesRepName;
    }

    public ZipStatus getZipStatus() {
        return this.zipStatus;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public void setSalesRepName(String salesRepName) {
        this.salesRepName = salesRepName;
    }

    public void setZipStatus(ZipStatus status) {
        this.zipStatus = status;
    }

    public String getZipStatusDesc() {
        if (this.zipStatus != null) {
            if (this.zipStatus == ZipStatus.Cancelled) {
                return SP.getRS("zippay_payment_cancelled");
            }
            if (this.zipStatus == ZipStatus.Expired) {
                return SP.getRS("zippay_payment_expired");
            }
            if (this.zipStatus == ZipStatus.Declined) {
                return SP.getRS("zippay_payment_declined");
            }
            if (this.zipStatus == ZipStatus.Approved) {
                return SP.getRS("zippay_payment_approved");
            }
            return this.zipStatus.toString();
        }
        return "";
    }
}

