/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jpos.DlgMessage;
import jpos.PosDateField;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.RefCombo;
import jpos.Reference;
import jpos.SP;
import jpos.Security;
import jpos.StoreParams;
import jpos.basscom.utils.Utils;
import jpos.browser.ListWrapper;
import jpos.person.PersonContext;
import jpos.searchfields.HintTextField;
import jpos.searchfields.SearchButton;
import jpos.searchfields.SearchPanel;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;

public class DlgEditLoyalty
extends PosDialog {
    private PersonContext.Loyalty loyalty;
    private ListWrapper<PersonContext.Loyalty> existingLoyalties;
    private EditLoyaltyMode editMode;
    private boolean managerSecurityOverridden;
    private EditLoyaltyResult result = EditLoyaltyResult.CANCEL;
    private LabelNormal programLabel;
    private LabelNormal cardNumberLabel;
    private LabelNormal expiryDateLabel;
    private RefCombo programField;
    private HintTextField cardNumberField;
    private PosDateField expiryDateField;
    private DialogButton okButton;
    private DialogButton cancelButton;

    public DlgEditLoyalty(PosFrame frame, JDialog dlgParent, PersonContext.Loyalty loyalty, ListWrapper<PersonContext.Loyalty> existingLoyalties, EditLoyaltyMode editMode, boolean managerSecurityOverridden) {
        super(frame, dlgParent, SP.getRS("Edit_Loyalty"), true);
        this.loyalty = loyalty;
        this.existingLoyalties = existingLoyalties;
        this.editMode = editMode;
        this.managerSecurityOverridden = managerSecurityOverridden;
        this.initialiseScreen();
    }

    private void initialiseScreen() {
        if (this.editMode == EditLoyaltyMode.ADD_NEW) {
            this.setTitle(SP.getRS("Add_New_Loyalty"));
        }
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelBody = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        this.programLabel = new LabelNormal(SP.getRS("Loyalty_Program"));
        this.cardNumberLabel = new LabelNormal(SP.getRS("Card_Number"));
        this.expiryDateLabel = new LabelNormal(SP.getRS("Expiry_Date"));
        this.programField = new RefCombo(366L, "R.RCIDX <> 787", "R.NAME");
        this.programField.setShowName(true);
        this.programField.setFieldWidth(200);
        this.programField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgEditLoyalty.this.processProgramChange();
            }
        });
        this.cardNumberField = new HintTextField(SP.getRS("System_Assigned"));
        this.cardNumberField.setFieldWidth(200);
        this.cardNumberField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DlgEditLoyalty.this.cardNumberField.selectAll();
            }
        });
        this.expiryDateField = new PosDateField(this);
        this.expiryDateField.setFieldWidth(200);
        this.expiryDateField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DlgEditLoyalty.this.expiryDateField.selectAll();
            }
        });
        this.okButton = new DialogButton("");
        this.okButton.setText(StoreParams.res.getString("Save"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgEditLoyalty.this.okDialog();
            }
        });
        this.cancelButton = new DialogButton("");
        this.cancelButton.setText(StoreParams.res.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgEditLoyalty.this.cancelDialog();
            }
        });
        SearchPanel expiryDateSearchPanel = new SearchPanel(this.expiryDateField, SearchButton.SearchIcon.CALENDAR);
        this.getContentPane().add(panelMain);
        panelMain.add((Component)panelBody, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 16, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelBody.add((Component)this.programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 5, 5), 0, 0));
        panelBody.add((Component)this.cardNumberLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 5, 5), 0, 0));
        panelBody.add((Component)this.expiryDateLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 13, 0, new Insets(10, 10, 10, 5), 0, 0));
        panelBody.add((Component)this.programField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 5, 5, 10), 0, 0));
        panelBody.add((Component)this.cardNumberField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(10, 5, 5, 10), 0, 0));
        panelBody.add((Component)expiryDateSearchPanel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 5, 10, 10), 0, 0));
        panelFooter.add((Component)this.okButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 14, 0, new Insets(15, 10, 10, 5), 0, 0));
        panelFooter.add((Component)this.cancelButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 16, 0, new Insets(15, 5, 10, 10), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.programField);
        tabOrder.add(this.cardNumberField);
        tabOrder.add(this.expiryDateField);
        tabOrder.add(this.okButton);
        tabOrder.add(this.cancelButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        this.setResizable(false);
        PosUtils.centreWindow(this);
        this.populate();
        this.setVisible(true);
    }

    private void populate() {
        if (this.editMode == EditLoyaltyMode.EDIT_EXISTING) {
            this.programField.selectRcidx(this.loyalty.loyaltyIdx);
            this.cardNumberField.setText(this.loyalty.cardNumber);
        } else {
            this.programField.setSelectedIndex(-1);
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
            calendar.set(1, calendar.get(1) + 1);
            this.loyalty.expiryDate.setTime(calendar.getTime().getTime());
        }
        this.expiryDateField.setValue(this.loyalty.expiryDate.getTimestamp());
    }

    @Override
    public void cancelDialog() {
        this.result = EditLoyaltyResult.CANCEL;
        this.setVisible(false);
    }

    @Override
    public void okDialog() {
        if (this.save()) {
            this.result = EditLoyaltyResult.SAVE;
            this.setVisible(false);
        }
    }

    private boolean save() {
        if (!this.validateInput()) {
            return false;
        }
        Reference selectedProgram = (Reference)this.programField.getSelectedItem();
        this.loyalty.loyaltyIdx = selectedProgram.getIdx();
        this.loyalty.loyaltyCode = selectedProgram.getCode();
        this.loyalty.programName = selectedProgram.getName();
        this.loyalty.cardNumber = this.cardNumberField.getText();
        this.loyalty.expiryDate.setTimestamp(this.expiryDateField.getDateFormatter().getTimestamp());
        this.loyalty.expiryDateStr = this.loyalty.expiryDate.toString();
        return true;
    }

    private boolean validateInput() {
        if (this.programField.getSelectedIndex() < 0 || this.programField.getSelectedItem() == null) {
            this.programField.requestFocus();
            DlgMessage.showMessage(this, SP.getRS("select_loyalty"), SP.getRS("Invalid_CardType"), 0);
            return false;
        }
        if (!this.expiryDateField.isValidDate()) {
            this.expiryDateField.actionValidate();
            if (!this.expiryDateField.isValidDate()) {
                return false;
            }
        }
        Reference selectedProgram = (Reference)this.programField.getSelectedItem();
        Vector<String> toks = new Vector<String>();
        Utils.stringTokenize(selectedProgram.getBlobText(), "\u0003", toks);
        boolean bl = this.loyalty.managerOnly = toks.size() > 6 ? PosUtils.booleanVal(toks.get(6)) : false;
        if (this.loyalty.managerOnly && !this.managerSecurityOverridden && !Security.hasSecurity(this.frParent, 11165L, this.frParent.getUser().getMemidx(), 0, true)) {
            this.programField.requestFocus();
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("cant_apply_manager_loyalty"), selectedProgram.toString()), SP.getRS("Insufficient_security"), -1, 0);
            return false;
        }
        for (int i = 0; i < this.existingLoyalties.size(); ++i) {
            PersonContext.Loyalty existingLoyalty = this.existingLoyalties.get(i);
            if (existingLoyalty == this.loyalty || existingLoyalty.loyaltyIdx == 0L || existingLoyalty.loyaltyIdx != selectedProgram.getIdx()) continue;
            this.programField.requestFocus();
            DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("CardType_Already_Exists"), selectedProgram.toString()), SP.getRS("Invalid_CardType"), 0);
            return false;
        }
        this.cardNumberField.setText(this.cardNumberField.getText().toUpperCase());
        String cardNumber = this.cardNumberField.getText();
        if (!cardNumber.equals("") && !cardNumber.equals(this.loyalty.cardNumber.toUpperCase())) {
            if (cardNumber.startsWith("LM")) {
                if (cardNumber.length() < 3) {
                    this.cardNumberField.requestFocus();
                    DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("CardNo_too_short_"), cardNumber), SP.getRS("Invalid_CardNo"), 0);
                    return false;
                }
            } else if (cardNumber.startsWith("L")) {
                if (!cardNumber.startsWith(selectedProgram.getCode().toUpperCase(), 1)) {
                    this.cardNumberField.requestFocus();
                    DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("first_two_digs"), selectedProgram.getCode().toUpperCase()), SP.getRS("Invalid_CardNo"), 0);
                    return false;
                }
                if (cardNumber.length() < 4) {
                    this.cardNumberField.requestFocus();
                    DlgMessage.showMessage(this, MessageFormat.format(SP.getRS("CardNo_too_short_"), cardNumber), SP.getRS("Invalid_CardNo"), 0);
                    return false;
                }
            } else {
                cardNumber = cardNumber.length() > 2 && cardNumber.startsWith(selectedProgram.getCode().toUpperCase()) ? "L" + cardNumber : "LM" + cardNumber;
                this.cardNumberField.setText(cardNumber);
            }
        }
        return true;
    }

    private void processProgramChange() {
        if (this.programField.getSelectedIndex() >= 0 && this.programField.getSelectedItem() != null) {
            Reference selectedProgram = (Reference)this.programField.getSelectedItem();
            if (this.loyalty.loyaltyIdx == 0L || selectedProgram.getIdx() != this.loyalty.loyaltyIdx) {
                if (!this.cardNumberField.getText().toUpperCase().startsWith("LM") && !this.cardNumberField.getText().toUpperCase().startsWith("L" + selectedProgram.getCode())) {
                    this.cardNumberField.setText("");
                }
            } else if (this.cardNumberField.getText().equals("") && this.loyalty.cardNumber != null) {
                this.cardNumberField.setText(this.loyalty.cardNumber);
            }
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    public EditLoyaltyResult getResult() {
        return this.result;
    }

    public static enum EditLoyaltyMode {
        ADD_NEW,
        EDIT_EXISTING;

    }

    public static enum EditLoyaltyResult {
        SAVE,
        CANCEL;

    }
}

