/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.StoreParams;
import jpos.kleber.KleberModels;
import jpos.ui.FormButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelStrong;

public class DlgPickAddress
extends PosDialog {
    private PickAddressResult result = PickAddressResult.CANCEL;
    private FormButton useNewAddressButton;
    private FormButton useOldAddressButton;
    private LabelNormal newAddressLabel;
    private LabelNormal oldAddressLabel;
    private LabelNormal messageLabel = new LabelNormal("We could not locate your entered address of");
    private LabelStrong headingLabel = new LabelStrong("Did you mean...?");
    private KleberModels.DtResponse.Address newAddress;
    private KleberModels.DtResponse.Address oldAddress;

    public DlgPickAddress(PosFrame frame, JDialog dlgParent, KleberModels.DtResponse.Address newAddress, KleberModels.DtResponse.Address oldAddress) {
        super(frame, dlgParent, StoreParams.res.getString("Address_Validation"), true);
        this.newAddress = newAddress;
        this.oldAddress = oldAddress;
        this.initialiseScreen();
    }

    private void initialiseScreen() {
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelBody = new JPanel(new GridBagLayout());
        JPanel panelNewAddress = new JPanel(new GridBagLayout());
        JPanel panelOldAddress = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        Dimension containerDimension = new Dimension(500, 300);
        Dimension contentsDimension = new Dimension(containerDimension.width - 10, containerDimension.height - 10);
        this.setMinimumSize(containerDimension);
        panelMain.setPreferredSize(contentsDimension);
        this.headingLabel.setFont(this.headingLabel.getFont().deriveFont(1));
        String newAddressText = this.newAddress.AddressLine1 + (this.newAddress.AddressLine2 == null || this.newAddress.AddressLine2.isEmpty() ? "" : ", " + this.newAddress.AddressLine2) + ", " + this.newAddress.City + ", " + (this.newAddress.State == null || this.newAddress.State.isEmpty() ? "" : this.newAddress.State + ", ") + this.newAddress.Postcode;
        this.newAddressLabel = new LabelNormal(newAddressText);
        this.newAddressLabel.setHorizontalAlignment(0);
        String oldAddressText = this.oldAddress.AddressLine1 + (this.oldAddress.AddressLine2 == null || this.oldAddress.AddressLine2.isEmpty() ? "" : ", " + this.oldAddress.AddressLine2) + ", " + this.oldAddress.City + ", " + (this.oldAddress.State == null || this.oldAddress.State.isEmpty() ? "" : this.oldAddress.State + ", ") + this.oldAddress.Postcode;
        this.oldAddressLabel = new LabelNormal(oldAddressText);
        this.oldAddressLabel.setFont(this.oldAddressLabel.getFont().deriveFont(2));
        this.oldAddressLabel.setHorizontalAlignment(0);
        this.useNewAddressButton = new FormButton("");
        this.useNewAddressButton.setText("Yes, Use Suggested Address");
        this.useNewAddressButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPickAddress.this.result = PickAddressResult.NEW;
                DlgPickAddress.this.okDialog();
            }
        });
        this.useOldAddressButton = new FormButton("");
        this.useOldAddressButton.setText("No, Use Entered Address");
        this.useOldAddressButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgPickAddress.this.result = PickAddressResult.OLD;
                DlgPickAddress.this.okDialog();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add(panelMain);
        panelMain.add((Component)panelBody, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelBody.add((Component)panelNewAddress, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelBody.add((Component)panelOldAddress, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelNewAddress.add((Component)this.headingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 10, 0), 0, 0));
        panelNewAddress.add((Component)this.newAddressLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelOldAddress.add((Component)this.messageLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
        panelOldAddress.add((Component)this.oldAddressLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelFooter.add((Component)this.useNewAddressButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 15, 1, new Insets(10, 5, 10, 10), 5, 5));
        panelFooter.add((Component)this.useOldAddressButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 15, 1, new Insets(10, 10, 10, 5), 5, 5));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.useNewAddressButton);
        tabOrder.add(this.useOldAddressButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        this.setResizable(false);
        PosUtils.centreWindow(this);
        this.populate();
        this.setVisible(true);
    }

    private void populate() {
    }

    @Override
    public void cancelDialog() {
        this.result = PickAddressResult.CANCEL;
        this.setVisible(false);
    }

    @Override
    public void okDialog() {
        this.setVisible(false);
    }

    public PickAddressResult getResult() {
        return this.result;
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    public static enum PickAddressResult {
        NEW,
        OLD,
        CANCEL;

    }
}

