/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import com.teamdev.jxbrowser.js.JsAccessible;
import com.teamdev.jxbrowser.js.JsObject;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.browser.ListWrapper;
import jpos.crypt.PersonCrypt;
import jpos.crypt.StringTransform;
import jpos.kleber.KleberUtils;
import jpos.person.DlgPersonSearchResult;
import jpos.person.JSPerson;
import jpos.person.PersonAttributes;
import jpos.person.PersonContext;
import jpos.person.PersonInterfaceUtils;
import jpos.person.PersonSecurity;
import org.jdom.Element;

public class PersonInterface
implements AutoCloseable {
    private Connection privateConnection;
    private PosDialog parent;
    private Element personElement;
    private String accountCustIdx;
    private PersonAttributes attributes;
    public PersonInterfaceUtils utils;
    private PersonSecurity security;
    private String attachButtonLabel;
    private volatile boolean dialogClosed = false;
    @JsAccessible
    public PersonContext context;

    public PersonInterface(PosDialog parent, String accountCustIdx, Element person, PersonAttributes attributes, Connection privateConnection, KleberUtils kleberUtils, PersonSecurity security, String attachButtonLabel) {
        this.privateConnection = privateConnection;
        this.parent = parent;
        this.personElement = person;
        this.context = new PersonContext();
        this.attributes = attributes;
        PersonContext.updateContextFromPersonXml(this.personElement, this.context, attributes);
        this.accountCustIdx = accountCustIdx;
        this.security = security;
        this.attachButtonLabel = attachButtonLabel;
        this.utils = new PersonInterfaceUtils(parent, attributes, accountCustIdx, kleberUtils, privateConnection, security);
    }

    @JsAccessible
    public boolean isOnline() {
        return SP.sParams.checkIConn(this.privateConnection);
    }

    @JsAccessible
    public String getAttachButtonLabel() {
        return this.attachButtonLabel;
    }

    @JsAccessible
    public PersonSecurity getSecurity() {
        return this.security;
    }

    @JsAccessible
    public PersonAttributes getAttributes() {
        return this.attributes;
    }

    @JsAccessible
    public int showMessage(String message, String title, int buttonType, int iconType) {
        return DlgMessage.showMessage(this.parent, message, title, buttonType, iconType);
    }

    @JsAccessible
    public boolean loadPerson(final boolean online, final String perIdx) {
        try {
            ResultRunnable<PersonContext> runnable = new ResultRunnable<PersonContext>(){

                @Override
                public PersonContext execute() {
                    return PersonInterface.this.utils.loadPerson(perIdx, online, PersonInterface.this.personElement, null);
                }
            };
            this.invokeOnEventDispatchThread(runnable);
            if (runnable.getResult() != null) {
                this.context = (PersonContext)runnable.getResult();
                return true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    @JsAccessible
    public boolean showSearch() {
        boolean online = SP.sParams.checkIConn(this.privateConnection);
        DlgPersonSearchResult.Result result = DlgPersonSearchResult.showDialog(this.parent.frParent, this.parent, SP.getRS("Person_Search"), true, online, this.accountCustIdx);
        if (result.getButtonPressed() == DlgPersonSearchResult.Button.NEW) {
            this.newPerson();
            this.utils.prePopulateNewPerson(result, this.context);
            return true;
        }
        if (result.getButtonPressed() == DlgPersonSearchResult.Button.CANCEL) {
            if (StringUtils.isNullOrEmpty(this.context.perIdx)) {
                this.exit();
            }
            return false;
        }
        if (result.getButtonPressed() == DlgPersonSearchResult.Button.OK && result.getPerIdx() != 0L) {
            return this.loadPerson(online, String.valueOf(result.getPerIdx()));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JsAccessible
    public String getPerIdx(String email) {
        if (StringUtils.isNullOrEmpty(email)) {
            return "";
        }
        List<String> persons = this.getMatchingPerIdxList(email);
        if (persons.isEmpty()) {
            return "";
        }
        String matchingIdxs = String.join((CharSequence)",", persons);
        try (SqlQuery sql = new SqlQuery(this.privateConnection, "SELECT P.PERIDX FROM PERSON P WHERE P.PERIDX IN ( " + matchingIdxs + " ) AND P.\"ACTIVE\" = 1 " + SP.sParams.sWhseRefSecWherePERSON);){
            if (!sql.next()) return "";
            String string = sql.getString(1);
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "";
    }

    private List<String> getMatchingPerIdxList(String email) {
        if (PersonCrypt.getInstance().keyExists()) {
            return PersonCrypt.getInstance().searchEmail(this.privateConnection, email, StringTransform.NO_TRANSFORMATION);
        }
        return Collections.emptyList();
    }

    @JsAccessible
    public boolean showMatchingPerson(String perIdx) {
        if (StringUtils.isNullOrEmpty(perIdx)) {
            return false;
        }
        boolean online = SP.sParams.checkIConn(this.privateConnection);
        String currentPerIdx = XMLUtils.getValue(this.personElement, "peridx");
        final Object[] objs = new Object[]{StringUtils.isNullOrEmpty(currentPerIdx) ? "create" : "update", "\n", "\n", "\n", "\n"};
        try {
            ResultRunnable<Boolean> runnable = new ResultRunnable<Boolean>(){

                @Override
                public Boolean execute() {
                    return DlgMessage.showMessage(PersonInterface.this.parent, MessageFormat.format(StoreParams.res.getString("per_exists"), objs), StoreParams.res.getString("Stop"), 0, 3) == 0;
                }
            };
            this.invokeOnEventDispatchThread(runnable);
            if (((Boolean)runnable.getResult()).booleanValue()) {
                return this.loadPerson(online, perIdx);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    @JsAccessible
    public void showHistory() {
        if (!StringUtils.isNullOrEmpty(this.context.perIdx)) {
            ResultRunnable<Boolean> runnable = new ResultRunnable<Boolean>(){

                @Override
                public Boolean execute() {
                    return PersonInterface.this.utils.historySearch(PersonInterface.this.context.perIdx, true);
                }
            };
            try {
                this.invokeOnEventDispatchThread(runnable);
                if (((Boolean)runnable.getResult()).booleanValue()) {
                    this.exit();
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        } else {
            DlgMessage.showMessage(this.parent, StoreParams.res.getString("select_person"), StoreParams.res.getString("Stop"), 2);
        }
    }

    @JsAccessible
    public void newPerson() {
        this.utils.clearPerson(this.personElement);
        this.context = new PersonContext();
    }

    @JsAccessible
    public boolean savePerson(JsObject person) {
        try {
            final PersonInterfaceUtils.ContextContainer container = new PersonInterfaceUtils.ContextContainer();
            final JSPerson jsPerson = new JSPerson(person, this.attributes);
            jsPerson.setLoyalties(this.utils.JsLoyaltyToList(person.property("loyalties").orElse(null)));
            ResultRunnable<Boolean> runnable = new ResultRunnable<Boolean>(){

                @Override
                public Boolean execute() {
                    return PersonInterface.this.utils.createOrUpdatePerson(PersonInterface.this.context, jsPerson, PersonInterface.this.personElement, container);
                }
            };
            this.invokeOnEventDispatchThread(runnable);
            if (container.context != null) {
                this.context = container.context;
            }
            return (Boolean)runnable.getResult();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    @JsAccessible
    public void deletePerson(JsObject person) {
        final JSPerson jsPerson = new JSPerson(person, this.attributes);
        jsPerson.setLoyalties(this.utils.JsLoyaltyToList(person.property("loyalties").orElse(null)));
        if (!XMLUtils.getValue(this.personElement, "peridx").equals(StringUtils.nullToEmpty(jsPerson.getPerIdx()))) {
            PosUtils.logError("Element / JSPerson mismatch");
            return;
        }
        if (!StringUtils.isNullOrEmpty(jsPerson.getPerIdx())) {
            ResultRunnable<Boolean> runnable = new ResultRunnable<Boolean>(){

                @Override
                public Boolean execute() {
                    return PersonInterface.this.utils.deletePerson(PersonInterface.this.context, jsPerson, PersonInterface.this.personElement);
                }
            };
            try {
                this.invokeOnEventDispatchThread(runnable);
                if (((Boolean)runnable.getResult()).booleanValue()) {
                    this.exit();
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        } else {
            DlgMessage.showMessage(this.parent, StoreParams.res.getString("select_person"), StoreParams.res.getString("Stop"), 2);
        }
    }

    @JsAccessible
    public void scanFingerPrint(String memName) {
        if (!this.security.canEditFingerPrints()) {
            return;
        }
        try {
            this.invokeOnEventDispatchThread(() -> this.utils.scanFingerPrint(memName));
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    @JsAccessible
    public boolean attachPerson() {
        if (!XMLUtils.getValue(this.personElement, "peridx").equals(StringUtils.nullToEmpty(this.context.perIdx))) {
            PosUtils.logError("Element / PersonContext mismatch");
            return false;
        }
        try {
            ResultRunnable<Boolean> runnable = new ResultRunnable<Boolean>(){

                @Override
                public Boolean execute() {
                    return PersonInterface.this.utils.acceptPerson(PersonInterface.this.context, PersonInterface.this.personElement);
                }
            };
            this.invokeOnEventDispatchThread(runnable);
            if (((Boolean)runnable.getResult()).booleanValue()) {
                this.dialogClosed = true;
                SwingUtilities.invokeLater(() -> this.parent.okDialog());
                return true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    @JsAccessible
    public void exit() {
        this.dialogClosed = true;
        SwingUtilities.invokeLater(() -> this.parent.cancelDialog());
    }

    @JsAccessible
    public void viewTransaction(final int trType, final String docket) {
        try {
            ResultRunnable<Boolean> runnable = new ResultRunnable<Boolean>(){

                @Override
                public Boolean execute() {
                    return ((PersonInterface)PersonInterface.this).parent.frParent.menu.populate(((PersonInterface)PersonInterface.this).parent.frParent, trType, docket);
                }
            };
            this.invokeOnEventDispatchThread(runnable);
            if (((Boolean)runnable.getResult()).booleanValue()) {
                this.exit();
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    @JsAccessible
    public ListWrapper<PersonContext.Loyalty> addLoyalty(final List<PersonContext.Loyalty> loyalties) {
        try {
            ResultRunnable<ListWrapper<PersonContext.Loyalty>> runnable = new ResultRunnable<ListWrapper<PersonContext.Loyalty>>(){

                @Override
                public ListWrapper<PersonContext.Loyalty> execute() {
                    return PersonInterface.this.utils.addLoyaltyCard(PersonInterface.this.utils.LoyaltyToListWrapper(loyalties));
                }
            };
            this.invokeOnEventDispatchThread(runnable);
            return (ListWrapper)runnable.getResult();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return this.context.loyalties;
        }
    }

    @JsAccessible
    public ListWrapper<PersonContext.Loyalty> editLoyalty(final int cardId, final List<PersonContext.Loyalty> loyalties) {
        try {
            ResultRunnable<ListWrapper<PersonContext.Loyalty>> runnable = new ResultRunnable<ListWrapper<PersonContext.Loyalty>>(){

                @Override
                public ListWrapper<PersonContext.Loyalty> execute() {
                    return PersonInterface.this.utils.editLoyaltyCard(cardId, PersonInterface.this.utils.LoyaltyToListWrapper(loyalties));
                }
            };
            this.invokeOnEventDispatchThread(runnable);
            return (ListWrapper)runnable.getResult();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return this.context.loyalties;
        }
    }

    @JsAccessible
    public boolean rewardsSignUp(String perIdx) {
        if (StringUtils.isNullOrEmpty(perIdx) || !perIdx.equals(this.context.perIdx)) {
            return false;
        }
        try {
            ResultRunnable<Boolean> runnable = new ResultRunnable<Boolean>(){

                @Override
                public Boolean execute() {
                    return PersonInterface.this.utils.rewardsSignUp(PersonInterface.this.context, PersonInterface.this.personElement);
                }
            };
            this.invokeOnEventDispatchThread(runnable);
            return (Boolean)runnable.getResult();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    @JsAccessible
    public boolean redeemRewardsManual(String accountIdx) {
        if (StringUtils.isNullOrEmpty(accountIdx) || !accountIdx.equals(this.context.rewardsAccountIdx)) {
            return false;
        }
        try {
            ResultRunnable<Boolean> runnable = new ResultRunnable<Boolean>(){

                @Override
                public Boolean execute() {
                    return PersonInterface.this.utils.manualRewardsRedeem(PersonInterface.this.context);
                }
            };
            this.invokeOnEventDispatchThread(runnable);
            return (Boolean)runnable.getResult();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    @JsAccessible
    public boolean reissueRewardsManual(String accountIdx, final double maxAmount, final String parentIdx) {
        if (StringUtils.isNullOrEmpty(accountIdx) || !accountIdx.equals(this.context.rewardsAccountIdx)) {
            return false;
        }
        try {
            ResultRunnable<Boolean> runnable = new ResultRunnable<Boolean>(){

                @Override
                public Boolean execute() {
                    return PersonInterface.this.utils.manualRewardsReissue(PersonInterface.this.context, maxAmount, parentIdx);
                }
            };
            this.invokeOnEventDispatchThread(runnable);
            return (Boolean)runnable.getResult();
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    private void invokeOnEventDispatchThread(Runnable runnable) throws InvocationTargetException, InterruptedException, IllegalStateException {
        if (this.dialogClosed) {
            throw new IllegalStateException("PersonInteface.invokeOnEventDispatchThread called after close.");
        }
        SwingUtilities.invokeLater(() -> this.parent.setCursor(StoreParams.waitCursor));
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                runnable.run();
            }
        }
        finally {
            SwingUtilities.invokeLater(() -> this.parent.setCursor(StoreParams.normalCursor));
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.privateConnection != null) {
            try {
                this.privateConnection.close();
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
            this.privateConnection = null;
        }
    }

    private static abstract class ResultRunnable<T>
    implements Runnable {
        private T result;

        private ResultRunnable() {
        }

        public abstract T execute();

        @Override
        public void run() {
            this.result = this.execute();
        }

        public T getResult() {
            return this.result;
        }
    }
}

