/*
 * Decompiled with CFR 0.152.
 */
package jpos.pointspartner;

import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import jpos.Barcode;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.pointspartner.DlgMembershipNumber;
import jpos.pointspartner.IMembershipStrategy;
import jpos.pointspartner.PointsPartner;

public class PointsPartnerManager
implements IMembershipStrategy {
    public static final String PREFIX_SEPARATOR = ",";
    private List<PointsPartner> partners = new ArrayList<PointsPartner>();
    boolean alwaysPrompt = false;
    private PointsPartner currentPartner = null;
    private String membershipNumber = "";

    public List<PointsPartner> getPartners() {
        return this.partners;
    }

    public PointsPartner getCurrentPartner() {
        return this.currentPartner;
    }

    public void setCurrentPartner(PointsPartner currentPartner) {
        this.currentPartner = currentPartner;
    }

    public void setCurrentPartner(long currentPartnerRcidx) {
        for (PointsPartner existing : this.partners) {
            if (existing.getPartnerIdx() != currentPartnerRcidx) continue;
            this.currentPartner = existing;
            return;
        }
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT R.RCIDX, R.NAME, P.CARD_PREFIXES, COALESCE(P.VALIDATION_FLAG,0),  COALESCE(P.ALWAYS_PROMPT_FLAG,0), NVL(P.OVERRIDE_DOCKET_FLAG,0), COALESCE(OVERRIDE_DOCKET_TEXT, '') COALESCE(P.OVERRIDE_DISPLAY_MESSAGE_FLAG,0), COALESCE(P.OVERRIDE_DISPLAY_MESSAGE_TEXT, '') FROM REFCODE R JOIN POINTS_PARTNER P ON R.RCIDX = P.RCIDX WHERE R.RGIDX = 443 AND R.RCIDX = " + currentPartnerRcidx);){
            if (sql.next()) {
                long partnerIdx = sql.getLong(1);
                String partnerName = StringUtils.nullToEmpty(sql.getString(2));
                String[] cardPrefixes = StringUtils.nullToEmpty(sql.getString(3)).split(PREFIX_SEPARATOR);
                Barcode.BarcodeType barcodeType = Barcode.BarcodeType.getBarcodeType(sql.getInt(4));
                boolean prompt = sql.getBoolean(5);
                boolean overrideDocket = sql.getBoolean(6);
                String overrideText = StringUtils.nullToEmpty(sql.getString(7));
                boolean overrideDisplayText = sql.getBoolean(8);
                String displayText = StringUtils.nullToEmpty(sql.getString(9));
                this.currentPartner = new PointsPartner(partnerIdx, partnerName, cardPrefixes, barcodeType, prompt, overrideDocket, overrideText, displayText, overrideDisplayText);
                return;
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        this.currentPartner = new PointsPartner(currentPartnerRcidx, "", null, null, false, false, "", "", false);
    }

    public String getMembershipNumber() {
        return this.membershipNumber != null ? this.membershipNumber : "";
    }

    public void setMembershipNumber(String membershipNumber) {
        this.membershipNumber = membershipNumber;
    }

    public boolean isAlwaysPrompt() {
        return this.alwaysPrompt;
    }

    public PointsPartnerManager() {
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT R.RCIDX, R.NAME, P.CARD_PREFIXES, COALESCE(P.VALIDATION_FLAG,0),  COALESCE(P.ALWAYS_PROMPT_FLAG,0), COALESCE(P.OVERRIDE_DOCKET_FLAG,0), COALESCE(OVERRIDE_DOCKET_TEXT, ''), COALESCE(P.OVERRIDE_DISPLAY_MESSAGE_FLAG,0), COALESCE(P.OVERRIDE_DISPLAY_MESSAGE_TEXT, '') FROM REFCODE R JOIN POINTS_PARTNER P ON R.RCIDX = P.RCIDX WHERE R.RGIDX = 443 AND R.\"ACTIVE\" = 1 ORDER BY R.NAME, R.RCIDX");){
            while (sql.next()) {
                long partnerIdx = sql.getLong(1);
                String partnerName = StringUtils.nullToEmpty(sql.getString(2));
                String[] cardPrefixes = StringUtils.nullToEmpty(sql.getString(3)).split(PREFIX_SEPARATOR);
                Barcode.BarcodeType barcodeType = Barcode.BarcodeType.getBarcodeType(sql.getInt(4));
                boolean prompt = sql.getBoolean(5);
                boolean overrideDocket = sql.getBoolean(6);
                String overrideText = StringUtils.nullToEmpty(sql.getString(7));
                boolean overrideDisplayText = sql.getBoolean(8);
                String displayText = StringUtils.nullToEmpty(sql.getString(9));
                if (prompt) {
                    this.alwaysPrompt = true;
                }
                this.partners.add(new PointsPartner(partnerIdx, partnerName, cardPrefixes, barcodeType, prompt, overrideDocket, overrideText, displayText, overrideDisplayText));
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public void promptForMembershipNumber(PosFrame parent) {
        DlgMembershipNumber dialog = new DlgMembershipNumber(parent, this.getPromptTitle(), this.getPromptLabel(), this, this.partners.size() == 1 ? null : this.getPromptList());
        dialog.setVisible(true);
        dialog.dispose();
    }

    private String getPromptTitle() {
        if (this.partners.size() == 1) {
            return MessageFormat.format(SP.getRS("points_partner_title_single"), this.partners.get(0).getPartnerName());
        }
        return SP.getRS("points_partner_title_multi");
    }

    private String getPromptLabel() {
        if (this.partners.size() == 1) {
            if (this.partners.get(0).isOverrideDisplayText() && !StringUtils.isNullOrEmpty(this.partners.get(0).GetDisplayText())) {
                return this.partners.get(0).GetDisplayText();
            }
            return SP.getRS("points_partner_prompt_single", this.partners.get(0).getPartnerName());
        }
        return SP.getRS("points_partner_prompt_multi");
    }

    private String getPromptList() {
        StringBuilder listBuilder = new StringBuilder();
        listBuilder.append('(');
        boolean first = true;
        for (PointsPartner partner : this.partners) {
            if (first) {
                first = false;
            } else {
                listBuilder.append(SP.getRS("points_partner_prompt_multi_separator"));
            }
            listBuilder.append(partner.getPartnerName());
        }
        listBuilder.append(')');
        return listBuilder.toString();
    }

    @Override
    public boolean setMembership(PointsPartner partner, String membershipNumber, StringBuilder message) {
        boolean needValidatePrefix;
        if (partner == null && this.partners.size() == 1) {
            partner = this.partners.get(0);
        }
        if (partner != null) {
            needValidatePrefix = true;
        } else {
            partner = this.getPartnerFromBarcode(membershipNumber);
            needValidatePrefix = false;
            if (partner == null) {
                message.append(SP.getRS("points_partner_error_no_partner"));
                return false;
            }
        }
        if (!partner.validateMembership(membershipNumber, needValidatePrefix, message)) {
            return false;
        }
        this.currentPartner = partner;
        this.membershipNumber = membershipNumber;
        message.append(SP.getRS("points_partner_confirmed", partner.getPartnerName()));
        return true;
    }

    @Override
    public PointsPartner getPartnerFromBarcode(String barcode) {
        for (PointsPartner partner : this.partners) {
            if (!partner.validatePrefix(barcode)) continue;
            return partner;
        }
        return null;
    }
}

