/*
 * Decompiled with CFR 0.152.
 */
package jpos.reservation.auto;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jpos.FrSales;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.pay.TransactionDetail;
import jpos.reservation.auto.AutoReservation;
import jpos.reservation.auto.ReservationDetail;
import jpos.reservation.model.ResvTranDetail;
import jpos.reservation.model.ResvTranHeader;

public class RetReasonReservation
extends AutoReservation {
    private Map<Integer, Long> retReasonResrv = this.getReturnReasonMapping();
    private static final String retReasonTemplate = "D%s%s - (Auto Reserved due to Return)";

    public RetReasonReservation(FrSales frSales) {
        super(frSales);
    }

    private Map<Integer, Long> getReturnReasonMapping() {
        this.retReasonResrv = new HashMap<Integer, Long>();
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT RESVTYPE, RET_REASON FROM RESV_RETURN rr JOIN REFCODE r ON rr.RESVTYPE = r.RCIDX  WHERE r.ACTIVE = 1 AND rr.ACTIVE = 1");){
            while (sql.next()) {
                this.retReasonResrv.put(sql.getInt("RET_REASON"), sql.getLong("RESVTYPE"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.retReasonResrv;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReservationDetail addRetTransHeader(Long resvType, String docNum, TransactionDetail transactionDetail) {
        Throwable throwable;
        SqlQuery sql;
        ReservationDetail resvDetail;
        block45: {
            resvDetail = null;
            try {
                sql = new SqlQuery(this.sParams.conn, "SELECT VHIDX, TR_TYPE, WIDX, SREPIDX, DOCKET_NUMBER, MEMBER_GENERATEDIDX, REF1, REF2, REF3, STAFF_SALE_FLAG, TILL_NUMBER, TRAND, TRANS_NUMBER, \"ACTIVE\", COMPLETE, COUNTRY_CODE, TRANSMEMIDX, TRANSSREPIDX, SALE_DATE, TILL_BALANCE_TYPE FROM RET_TRANH WHERE VHIDX = ?", String.valueOf(transactionDetail.getVhidx()));
                throwable = null;
                try {
                    if (!sql.next()) break block45;
                    long newVhidx = this.sParams.nextVal("XRET_TRANH");
                    try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("INSERT INTO RET_TRANH ( VHIDX, TR_TYPE, WIDX, SREPIDX, DOCKET_NUMBER, MEMBER_GENERATEDIDX, REF1, REF2, REF3, STAFF_SALE_FLAG, TILL_NUMBER, TRAND, TRANS_NUMBER, \"ACTIVE\", COMPLETE, COUNTRY_CODE, TRANSMEMIDX, TRANSSREPIDX, SALE_DATE, TILL_BALANCE_TYPE, SELFFIT, RESRVETYPEIDX, RESERVE_NOTES) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                        prepStmt.setLong(1, newVhidx);
                        prepStmt.setInt(2, 614);
                        prepStmt.setLong(3, this.sParams.getStoreIdx());
                        prepStmt.setLong(4, sql.getLong("SREPIDX"));
                        prepStmt.setString(5, docNum);
                        prepStmt.setLong(6, sql.getLong("MEMBER_GENERATEDIDX"));
                        prepStmt.setString(7, sql.getString("REF1"));
                        prepStmt.setString(8, sql.getString("REF2"));
                        prepStmt.setString(9, sql.getString("REF3"));
                        prepStmt.setInt(10, sql.getInt("STAFF_SALE_FLAG"));
                        prepStmt.setString(11, sql.getString("TILL_NUMBER"));
                        prepStmt.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
                        prepStmt.setString(13, docNum);
                        prepStmt.setInt(14, 1);
                        prepStmt.setInt(15, 0);
                        prepStmt.setString(16, sql.getString("COUNTRY_CODE"));
                        prepStmt.setLong(17, sql.getLong("TRANSMEMIDX"));
                        prepStmt.setLong(18, sql.getLong("TRANSSREPIDX"));
                        prepStmt.setTimestamp(19, sql.getTimestamp("SALE_DATE"));
                        prepStmt.setInt(20, sql.getInt("TILL_BALANCE_TYPE"));
                        prepStmt.setInt(21, 0);
                        prepStmt.setLong(22, resvType);
                        prepStmt.setString(23, null);
                        prepStmt.executeUpdate();
                        resvDetail = new ReservationDetail(newVhidx);
                        resvDetail.setResvtypeidx(resvType);
                        resvDetail.setResvnotes(String.format(retReasonTemplate, this.sParams.getStore().getStoreNo(), sql.getString("DOCKET_NUMBER")));
                    }
                    catch (SQLException e) {
                        ReservationDetail reservationDetail = resvDetail;
                        if (sql == null) return reservationDetail;
                        if (throwable == null) {
                            sql.close();
                            return reservationDetail;
                        }
                        try {
                            sql.close();
                            return reservationDetail;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return reservationDetail;
                        }
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (sql != null) {
                        if (throwable != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                return resvDetail;
            }
        }
        try {
            sql = new SqlQuery(this.sParams.conn, "SELECT DCKTPRNT, LBLPRNT, LBLCODE FROM RESVBUCKET WHERE RESVTYPE = ? AND ACTIVE = 1;", resvType);
            throwable = null;
            try {
                if (!sql.next()) return resvDetail;
                resvDetail.setDcktpnt(sql.getInt("DCKTPRNT"));
                resvDetail.setLblprnt(sql.getInt("LBLPRNT"));
                resvDetail.setLblcode(sql.getString("LBLCODE"));
                return resvDetail;
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (sql != null) {
                    if (throwable != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ReservationDetail addRetTransDetail(ReservationDetail resvDetail, TransactionDetail transactionDetail) {
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT rt.VSHIDX, rt.VHIDX, rt.GROSS, rt.LINE_CODE, rt.LINE_TYPE, rt.NET, rt.PRICE, rt.SEQUENCE_NUMBER, rt.SKUIDX, rt.STKFLAG, rt.TAXPER, rt.ACTIVE, rt.QTY, rt.ORIG_PRICE, rt.POS_MKDMSGIDX, rt.EXT_TAXRATE, rt.TAKEN, rt.PACKED, rt.OLD_HELD_VALUE, rt.TAX_DONOTREFRESH_FLAG, rt.GVGATE_ISDIGITAL, rt.SREPIDX, rr.RESVTYPE, r.NAME FROM RET_TRAND rt LEFT JOIN RESV_RETURN rr ON rt.RET_REASIDX = rr.RET_REASON AND rr.ACTIVE = 1 LEFT JOIN REFCODE r ON r.RCIDX = rt.RET_REASIDX AND r.ACTIVE = 1 WHERE rt.VHIDX = ? AND rt.ACTIVE = 1 AND rr.RESVTYPE = ?", String.valueOf(transactionDetail.getVhidx()), resvDetail.getResvtypeidx());){
            while (sql.next()) {
                PreparedStatement prepStmt;
                block24: {
                    prepStmt = this.sParams.conn.prepareStatement("INSERT INTO RET_TRAND (VSHIDX, VHIDX, GROSS, LINE_CODE, LINE_TYPE, NET, PRICE, SEQUENCE_NUMBER, SKUIDX, STKFLAG, TAXPER, ACTIVE, QTY, ORIG_PRICE, POS_MKDMSGIDX, EXT_TAXRATE, TAKEN, PACKED, OLD_HELD_VALUE, TAX_DONOTREFRESH_FLAG, GVGATE_ISDIGITAL, SREPIDX) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    Throwable throwable = null;
                    try {
                        prepStmt.setLong(1, this.sParams.nextVal("XRET_TRAND"));
                        prepStmt.setLong(2, resvDetail.getVhidx());
                        prepStmt.setDouble(3, sql.getDouble("GROSS") * -1.0);
                        prepStmt.setString(4, sql.getString("LINE_CODE"));
                        prepStmt.setLong(5, sql.getLong("LINE_TYPE"));
                        prepStmt.setDouble(6, sql.getDouble("NET") * -1.0);
                        prepStmt.setDouble(7, sql.getDouble("PRICE"));
                        prepStmt.setLong(8, sql.getLong("SEQUENCE_NUMBER"));
                        prepStmt.setString(9, sql.getString("SKUIDX"));
                        prepStmt.setString(10, sql.getString("STKFLAG"));
                        prepStmt.setLong(11, sql.getLong("TAXPER"));
                        prepStmt.setInt(12, 1);
                        prepStmt.setLong(13, sql.getLong("QTY") * -1L);
                        prepStmt.setLong(14, sql.getLong("ORIG_PRICE"));
                        prepStmt.setLong(15, sql.getLong("POS_MKDMSGIDX"));
                        prepStmt.setLong(16, sql.getLong("EXT_TAXRATE"));
                        prepStmt.setInt(17, sql.getInt("TAKEN"));
                        prepStmt.setLong(18, sql.getLong("PACKED"));
                        prepStmt.setLong(19, sql.getLong("OLD_HELD_VALUE"));
                        prepStmt.setInt(20, sql.getInt("TAX_DONOTREFRESH_FLAG"));
                        prepStmt.setInt(21, sql.getInt("GVGATE_ISDIGITAL"));
                        prepStmt.setLong(22, sql.getLong("SREPIDX"));
                        prepStmt.executeUpdate();
                        if (prepStmt == null) continue;
                        if (throwable == null) break block24;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (prepStmt == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    prepStmt.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            prepStmt.close();
                            throw throwable3;
                        }
                    }
                    try {
                        prepStmt.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                prepStmt.close();
            }
            return resvDetail;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private void updateRetTransHeader(ReservationDetail resvDetail) {
        try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("UPDATE RET_TRANH SET COMPLETE = 1, RESRVETYPEIDX = ?, RESERVE_NOTES = ? WHERE VHIDX = ?");){
            prepStmt.setLong(1, resvDetail.getResvtypeidx());
            prepStmt.setString(2, resvDetail.getResvnotes());
            prepStmt.setLong(3, resvDetail.getVhidx());
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            return;
        }
    }

    @Override
    public void setTranH(ResvTranHeader tranh) {
    }

    @Override
    public void executeReservation(List<ResvTranDetail> retrDetails) {
        Long resvType;
        HashMap<Long, List> resvTypeGroups = new HashMap<Long, List>();
        for (TransactionDetail transactionDetail : retrDetails) {
            if (transactionDetail.getRetReasidx() <= 0 || (resvType = this.retReasonResrv.get(transactionDetail.getRetReasidx())) == null) continue;
            resvTypeGroups.computeIfAbsent(resvType, k -> new ArrayList()).add(transactionDetail);
        }
        if (!resvTypeGroups.isEmpty()) {
            for (Map.Entry entry : resvTypeGroups.entrySet()) {
                resvType = (Long)entry.getKey();
                List detailsList = (List)entry.getValue();
                try {
                    String docNum = PosUtils.padZeroes(this.sParams.getNextDocketNum("PosFrame.setDocketnum, Screen " + PosMenuController.getScreenName(11)), 8);
                    SP.sParams.bDoingNewSave = true;
                    ReservationDetail resvDetail = this.addRetTransHeader(resvType, docNum, (TransactionDetail)detailsList.get(0));
                    if (resvDetail != null) {
                        resvDetail = this.addRetTransDetail(resvDetail, (TransactionDetail)detailsList.get(0));
                        this.updateRetTransHeader(resvDetail);
                        this.finalizeReservation(resvDetail.getVhidx());
                    }
                    SP.sParams.bDoingNewSave = false;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

