/*
 * Decompiled with CFR 0.152.
 */
package jpos.reservation.model;

import java.sql.Timestamp;
import org.jdom.Element;

public class ResvTranHeader {
    private long vhidx;
    private int trType;
    private long widx;
    private long srepidx;
    private String docketNumber;
    private long fromWidx;
    private long memberGeneratedidx;
    private String ref1;
    private String ref2;
    private String ref3;
    private int staffSaleFlag;
    private String tillNumber;
    private Timestamp trand;
    private String transNumber;
    private int active;
    private int complete;
    private String countryCode;
    private long transmemidx;
    private long transsrepidx;
    private Timestamp saleDate;
    private int tillBalanceType;

    public ResvTranHeader(Element element) {
        this.loadFromElement(element);
    }

    private void loadFromElement(Element element) {
        try {
            this.vhidx = this.getLongValue(element, "vhidx");
            this.trType = this.getIntValue(element, "trType");
            this.widx = this.getLongValue(element, "widx");
            this.srepidx = this.getLongValue(element, "headerSrepidx");
            this.docketNumber = this.getStringValue(element, "docketNumber");
            this.fromWidx = this.getLongValue(element, "fromWidx");
            this.memberGeneratedidx = this.getLongValue(element, "memberGeneratedidx");
            this.ref1 = this.getStringValue(element, "ref1");
            this.ref2 = this.getStringValue(element, "ref2");
            this.ref3 = this.getStringValue(element, "ref3");
            this.staffSaleFlag = this.getIntValue(element, "staffSaleFlag");
            this.tillNumber = this.getStringValue(element, "tillNumber");
            this.trand = this.getTimestampValue(element, "trand");
            this.transNumber = this.getStringValue(element, "transNumber");
            this.active = this.getIntValue(element, "tranhActive");
            this.complete = 0;
            this.countryCode = this.getStringValue(element, "countryCode");
            this.transmemidx = this.getLongValue(element, "transmemidx");
            this.transsrepidx = this.getLongValue(element, "transsrepidx");
            this.saleDate = this.getTimestampValue(element, "saleDate");
            this.tillBalanceType = this.getIntValue(element, "tillBalanceType");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getIntValue(Element element, String attributeName) {
        try {
            return element.getAttribute(attributeName) != null ? Integer.parseInt(element.getAttribute(attributeName).getValue()) : 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    private long getLongValue(Element element, String attributeName) {
        try {
            return element.getAttribute(attributeName) != null ? Long.parseLong(element.getAttribute(attributeName).getValue()) : 0L;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private String getStringValue(Element element, String attributeName) {
        try {
            return element.getAttribute(attributeName) != null ? element.getAttribute(attributeName).getValue() : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Timestamp getTimestampValue(Element element, String attributeName) {
        try {
            if (element.getAttribute(attributeName) != null) {
                String dateStr = element.getAttribute(attributeName).getValue();
                String[] parts = dateStr.split(" ");
                String[] dateParts = parts[0].split("/");
                String[] timeParts = parts[1].split(":");
                int hour = Integer.parseInt(timeParts[0]);
                if (parts[2].equalsIgnoreCase("PM") && hour != 12) {
                    hour += 12;
                } else if (parts[2].equalsIgnoreCase("AM") && hour == 12) {
                    hour = 0;
                }
                String formattedDate = String.format("%s-%s-%s %02d:%s:%s", dateParts[2], dateParts[1], dateParts[0], hour, timeParts[1], timeParts[2]);
                return Timestamp.valueOf(formattedDate);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public long getVhidx() {
        return this.vhidx;
    }

    public int getTrType() {
        return this.trType;
    }

    public long getWidx() {
        return this.widx;
    }

    public long getSrepidx() {
        return this.srepidx;
    }

    public String getDocketNumber() {
        return this.docketNumber;
    }

    public long getFromWidx() {
        return this.fromWidx;
    }

    public long getMemberGeneratedidx() {
        return this.memberGeneratedidx;
    }

    public String getRef1() {
        return this.ref1;
    }

    public String getRef2() {
        return this.ref2;
    }

    public String getRef3() {
        return this.ref3;
    }

    public int getStaffSaleFlag() {
        return this.staffSaleFlag;
    }

    public String getTillNumber() {
        return this.tillNumber;
    }

    public Timestamp getTrand() {
        return this.trand;
    }

    public String getTransNumber() {
        return this.transNumber;
    }

    public int getActive() {
        return this.active;
    }

    public int getComplete() {
        return this.complete;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public long getTransmemidx() {
        return this.transmemidx;
    }

    public long getTranssrepidx() {
        return this.transsrepidx;
    }

    public Timestamp getSaleDate() {
        return this.saleDate;
    }

    public int getTillBalanceType() {
        return this.tillBalanceType;
    }
}

