/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.util.Vector;
import javax.swing.JPanel;
import jpos.ui.Colours;
import jpos.ui.LabelSmall;

public class CircularProgressBar
extends JPanel {
    private int min = 0;
    private int max = 100;
    private int[] progress = new int[]{0};
    private double[] percent = new double[]{0.0};
    private int radius;
    private int lineThickness = 8;
    private Color[] barColors = new Color[]{Colours.PROGRESS_GREEN};
    private Color blankLineColor = Colours.PROGRESS_BLANK;
    private BasicStroke thickStroke = new BasicStroke(this.lineThickness, 1, 1);
    private BasicStroke thinStroke = new BasicStroke(3.0f);
    private LabelSmall label = new LabelSmall();

    public CircularProgressBar() {
        super(new GridLayout());
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
        this.add(this.label);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CircularProgressBar.this.radius = Math.min(e.getComponent().getHeight(), e.getComponent().getWidth()) / 2 - CircularProgressBar.this.lineThickness / 2;
                CircularProgressBar.this.repaint();
            }
        });
    }

    public void updateProgress(int[] value, String text) {
        this.progress = value;
        this.percent = new double[this.progress.length];
        int totalProgress = 0;
        for (int i = 0; i < this.progress.length; ++i) {
            int remaining;
            if (this.progress[i] < this.min) {
                this.progress[i] = this.min;
            }
            if (this.progress[i] > (remaining = this.max - totalProgress)) {
                this.progress[i] = remaining;
            }
            totalProgress += this.progress[i];
            this.percent[i] = (double)(this.progress[i] - this.min) / (double)(this.max - this.min) * 100.0;
        }
        this.label.setText(text);
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        int i;
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        Stroke origStroke = g2.getStroke();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate(this.getWidth() / 2, this.getHeight() / 2);
        Ellipse2D.Float lineCircle = new Ellipse2D.Float();
        lineCircle.setFrameFromCenter(new Point(0, 0), new Point(this.radius, this.radius));
        g2.setColor(this.blankLineColor);
        g2.setStroke(this.thinStroke);
        g2.draw(lineCircle);
        Vector<Arc2D.Float> arcs = new Vector<Arc2D.Float>();
        double angleStart = 270.0;
        for (i = 0; i < this.progress.length; ++i) {
            Arc2D.Float arc = null;
            if (this.progress[i] > this.min) {
                arc = new Arc2D.Float(0);
                arc.setFrameFromCenter(new Point(0, 0), new Point(this.radius, this.radius));
                arc.setAngleStart(angleStart);
                double degrees = -this.percent[i] * 3.6;
                arc.setAngleExtent(degrees);
                angleStart += degrees;
            }
            arcs.add(arc);
        }
        g2.setStroke(this.thickStroke);
        for (i = arcs.size() - 1; i >= 0; --i) {
            if (arcs.elementAt(i) == null) continue;
            g2.setColor(this.barColors[i % this.barColors.length]);
            g2.draw((Shape)arcs.elementAt(i));
        }
        g2.setStroke(origStroke);
    }

    public void setBarColors(Color[] barColors) {
        this.barColors = barColors;
    }

    public void setRange(int min, int max) {
        if (min < 0) {
            throw new IllegalArgumentException("min must be greater than or equal to 0");
        }
        if (max <= 0) {
            throw new IllegalArgumentException("max must be greater than 0");
        }
        if (max < min) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

