/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;
import jpos.ui.Colours;
import jpos.ui.Fonts;

public class ColourPanel
extends JPanel {
    private Color baseColour;
    private Color toColour;
    private Timer mainTimer;
    private long tickCount = 0L;
    private double redIncrement = 0.0;
    private double greenIncrement = 0.0;
    private double blueIncrement = 0.0;
    private int refreshRateMilliseconds = 40;
    private double defaultColourChangeSeconds = 0.8;

    public Color getBaseColour() {
        return this.baseColour;
    }

    public ColourPanel(Color baseColour, double defaultColourChangeSeconds) {
        this(baseColour);
        this.defaultColourChangeSeconds = defaultColourChangeSeconds;
    }

    public ColourPanel(Color baseColour) {
        this.baseColour = baseColour != null ? baseColour : Colours.WHITE;
        this.setBackground(baseColour);
        this.setFont(Fonts.H2);
        this.redIncrement = 0.0;
        this.greenIncrement = 0.0;
        this.blueIncrement = 0.0;
        this.tickCount = 0L;
        this.mainTimer = new Timer(this.refreshRateMilliseconds, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColourPanel.this.tickCount++;
                int nextRed = (int)((double)ColourPanel.this.baseColour.getRed() + ColourPanel.this.redIncrement * (double)ColourPanel.this.tickCount);
                int nextGreen = (int)((double)ColourPanel.this.baseColour.getGreen() + ColourPanel.this.greenIncrement * (double)ColourPanel.this.tickCount);
                int nextBlue = (int)((double)ColourPanel.this.baseColour.getBlue() + ColourPanel.this.blueIncrement * (double)ColourPanel.this.tickCount);
                boolean redMet = false;
                boolean greenMet = false;
                boolean blueMet = false;
                if (ColourPanel.this.redIncrement <= 0.0 && nextRed <= ColourPanel.this.toColour.getRed() || ColourPanel.this.redIncrement >= 0.0 && nextRed >= ColourPanel.this.toColour.getRed()) {
                    redMet = true;
                    nextRed = ColourPanel.this.toColour.getRed();
                }
                if (ColourPanel.this.greenIncrement <= 0.0 && nextGreen <= ColourPanel.this.toColour.getGreen() || ColourPanel.this.greenIncrement >= 0.0 && nextGreen >= ColourPanel.this.toColour.getGreen()) {
                    greenMet = true;
                    nextGreen = ColourPanel.this.toColour.getGreen();
                }
                if (ColourPanel.this.blueIncrement <= 0.0 && nextBlue <= ColourPanel.this.toColour.getBlue() || ColourPanel.this.blueIncrement >= 0.0 && nextBlue >= ColourPanel.this.toColour.getBlue()) {
                    blueMet = true;
                    nextBlue = ColourPanel.this.toColour.getBlue();
                }
                if (redMet && blueMet && greenMet) {
                    ColourPanel.this.mainTimer.stop();
                    ColourPanel.this.setBackground(ColourPanel.this.toColour);
                    ColourPanel.this.baseColour = ColourPanel.this.toColour;
                } else {
                    ColourPanel.this.setBackground(new Color(nextRed, nextGreen, nextBlue));
                }
                ColourPanel.this.repaint();
            }
        });
        this.mainTimer.setRepeats(true);
        this.mainTimer.setCoalesce(true);
    }

    public int getRefreshRateMilliseconds() {
        return this.refreshRateMilliseconds;
    }

    public void setRefreshRateMilliseconds(int refreshRateMilliseconds) {
        this.refreshRateMilliseconds = refreshRateMilliseconds;
    }

    public void setBaseColour(Color colour) {
        if (this.mainTimer.isRunning()) {
            this.mainTimer.stop();
        }
        this.baseColour = colour;
        this.setBackground(colour);
    }

    public double getDefaultColourChangeSeconds() {
        return this.defaultColourChangeSeconds;
    }

    public void setDefaultColourChangeSeconds(double defaultColourChangeSeconds) {
        this.defaultColourChangeSeconds = defaultColourChangeSeconds;
    }

    public void changePanelColour(Color toColour) {
        this.changePanelColour(toColour, this.defaultColourChangeSeconds);
    }

    public void changePanelColour(Color toColour, double seconds) {
        Color background = this.getBackground();
        if (background == null) {
            background = this.baseColour;
            this.setBackground(background);
        }
        this.baseColour = background;
        this.toColour = toColour;
        this.redIncrement = (double)(toColour.getRed() - background.getRed()) / (seconds * 1000.0 / (double)this.refreshRateMilliseconds);
        this.greenIncrement = (double)(toColour.getGreen() - background.getGreen()) / (seconds * 1000.0 / (double)this.refreshRateMilliseconds);
        this.blueIncrement = (double)(toColour.getBlue() - background.getBlue()) / (seconds * 1000.0 / (double)this.refreshRateMilliseconds);
        this.startTimer(this.mainTimer);
    }

    private void startTimer(Timer timer) {
        if (timer.isRunning()) {
            timer.stop();
        }
        this.tickCount = 0L;
        timer.start();
    }

    public boolean isColourChanging() {
        return this.mainTimer.isRunning();
    }

    public void reset() {
        if (this.mainTimer.isRunning()) {
            this.mainTimer.stop();
        }
        this.setBackground(this.baseColour);
    }
}

