/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import jpos.ui.Colours;

public class GlowBorder
extends AbstractBorder {
    private int thickness;
    private Color baseColour = null;
    private JPanel parent = null;
    private int[] gradient;

    public GlowBorder(Color baseColour, int maxThickness) {
        this.baseColour = baseColour;
        this.generateGradient(maxThickness);
    }

    public GlowBorder(JPanel parent, int maxThickness) {
        this.parent = parent;
        this.generateGradient(maxThickness);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.thickness > 0 && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            RenderingHints oldHints = g2d.getRenderingHints();
            g2d.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            Color background = c.getParent() != null ? c.getParent().getBackground() : Colours.BLACK;
            Color fadeFromColour = this.transformColour(this.getBaseColour());
            int alphaIncrement = fadeFromColour.getAlpha() / this.gradient.length;
            Color paintColour = new Color(fadeFromColour.getRed(), fadeFromColour.getGreen(), fadeFromColour.getBlue(), 0);
            for (int i = this.gradient.length - 1; i >= 0; --i) {
                paintColour = new Color(paintColour.getRed(), paintColour.getGreen(), paintColour.getBlue(), paintColour.getAlpha() + alphaIncrement);
                g2d.setColor(paintColour);
                int offs = this.gradient[i];
                int size = offs + offs;
                Rectangle outer = new Rectangle(x, y, width, height);
                Rectangle inner = new Rectangle(x += offs, y += offs, width -= size, height -= size);
                Path2D.Double path = new Path2D.Double(0);
                path.append(outer, false);
                path.append(inner, false);
                g2d.setColor(background);
                g2d.fill(path);
                g2d.setColor(paintColour);
                g2d.fill(path);
            }
            g2d.setRenderingHints(oldHints);
            g2d.setColor(oldColor);
        }
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(this.thickness, this.thickness, this.thickness, this.thickness);
        return insets;
    }

    public int getThickness() {
        return this.thickness;
    }

    public JComponent getParent() {
        return this.parent;
    }

    public Color getBaseColour() {
        if (this.baseColour != null) {
            return this.baseColour;
        }
        if (this.parent != null && this.parent.getBackground() != null) {
            return this.parent.getBackground();
        }
        return Colours.GREY;
    }

    public void setColour(Color colour) {
        this.baseColour = colour;
    }

    public Color transformColour(Color colour) {
        return Colours.lighten(colour, 0.1f);
    }

    private void generateGradient(int maxThickness) {
        this.thickness = 0;
        this.gradient = new int[maxThickness];
        for (int i = 0; i < maxThickness; ++i) {
            this.gradient[i] = maxThickness - i;
            this.thickness += this.gradient[i];
        }
    }
}

