/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.awt.Window;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.PosDateFormatter;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.pay.RetTranP;
import jpos.voucher.CreditNoteAdapter;
import jpos.voucher.DlgStatusDetails;

public class CreditNoteRedeemAdapter
extends CreditNoteAdapter {
    private Vector<RetTranP> existingPayments;
    private Window parentWindow;

    public CreditNoteRedeemAdapter(Window parentWindow, Vector<RetTranP> existingPayments) {
        this.existingPayments = existingPayments;
        this.parentWindow = parentWindow;
    }

    @Override
    public boolean processNumber(String creditNoteNumber) {
        if (creditNoteNumber == null || creditNoteNumber.equals("")) {
            return false;
        }
        if (creditNoteNumber.length() < 4) {
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this.parentWindow, MessageFormat.format(StoreParams.res.getString("CN_Invalid"), objs), SP.getRS("Stop"), -1, 0);
            return false;
        }
        for (int i = 0; i < this.existingPayments.size(); ++i) {
            RetTranP retTranP = this.existingPayments.elementAt(i);
            if (!retTranP.getPayType().isCreditNote || !PosUtils.PadRight(creditNoteNumber, 20, "0").equals(PosUtils.PadRight(retTranP.getPaymentNum(), 20, "0"))) continue;
            DlgMessage.showMessage(this.parentWindow, SP.getRS("CN_AlreadyRedeemed"), SP.getRS("Stop"), -1, 0);
            return false;
        }
        this.createCreditNote(creditNoteNumber);
        if (!this.getVoucher().isIssued()) {
            DlgMessage.showMessage(this.parentWindow, SP.getRS("CN_NotIssued"), SP.getRS("Stop"), -1, 0);
            this.destroyVoucher();
            return false;
        }
        if (!this.getVoucher().getCurrencyIdx().equals("") && !this.getVoucher().getCurrencyIdx().equals(SP.sParams.storeCurrency.getIdx())) {
            Object[] objs = new Object[]{"Credit Note", this.getVoucher().getNumber(), this.getVoucher().getCurrencyCode(), SP.sParams.storeCurrency.getCode()};
            DlgMessage.showMessage(this.parentWindow, MessageFormat.format(SP.getRS("voucher_creditnote_wrong_currency"), objs), StoreParams.res.getString("Stop"), 0);
            this.destroyVoucher();
            return false;
        }
        if (this.getVoucher().getAvailableAmount() <= 0.0) {
            DlgMessage dlgMessage = new DlgMessage(this.parentWindow, SP.getRS("Stop"), SP.getRS("CN_AlreadyRedeemed"), 2, 0);
            dlgMessage.getOkButton().setText(SP.getRS("Details"));
            dlgMessage.getCancelButton().setText(SP.getRS("Close"));
            if (dlgMessage.showMessage() == 0) {
                DlgStatusDetails dlgStatusDetails = new DlgStatusDetails((PosFrame)this.parentWindow, StoreParams.res.getString("Credit_Note_Enquiry"), true);
                dlgStatusDetails.loadDetails(this);
                dlgStatusDetails.setVisible(true);
            }
            this.destroyVoucher();
            return false;
        }
        if (this.getVoucher().getExpiryDate() != null) {
            java.sql.Date dToday = new java.sql.Date(new Date().getTime());
            PosDateFormatter.truncateTime(dToday);
            PosDateFormatter.truncateTime(this.getVoucher().getExpiryDate());
            if (dToday.getTime() > this.getVoucher().getExpiryDate().getTime()) {
                PosDateFormatter dateFormatter = new PosDateFormatter(new Timestamp(this.getVoucher().getExpiryDate().getTime()), 3, 3, 0);
                Object[] objs = new Object[]{dateFormatter.toString()};
                DlgMessage dlgMessage = new DlgMessage(this.parentWindow, SP.getRS("Stop"), MessageFormat.format(SP.getRS("CN_Expired"), objs), 2, 0);
                dlgMessage.getOkButton().setText(SP.getRS("Details"));
                dlgMessage.getCancelButton().setText(SP.getRS("Close"));
                if (dlgMessage.showMessage() == 0) {
                    DlgStatusDetails dlgStatusDetails = new DlgStatusDetails((PosFrame)this.parentWindow, StoreParams.res.getString("Credit_Note_Enquiry"), true);
                    dlgStatusDetails.loadDetails(this);
                    dlgStatusDetails.setVisible(true);
                }
                this.destroyVoucher();
                return false;
            }
        }
        return true;
    }
}

