/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.text.MessageFormat;
import jpos.SP;
import jpos.voucher.BaseAdapter;
import jpos.voucher.BaseVoucher;
import jpos.voucher.GatewayVoucher;
import jpos.voucher.IVoucherGateway;
import jpos.voucher.Voucher;
import jpos.voucher.VoucherGatewayManager;
import jpos.voucher.VoucherType;

public abstract class VoucherAdapter
extends BaseAdapter {
    private Voucher voucher;
    private GatewayVoucher gatewayVoucher;

    @Override
    public abstract boolean processNumber(String var1);

    protected void createVoucher(VoucherType voucherType, String voucherNumber) {
        this.voucher = new Voucher(voucherType, voucherNumber);
        this.gatewayVoucher = null;
    }

    protected void createGatewayVoucher(IVoucherGateway gateway, String voucherNumber) {
        this.gatewayVoucher = new GatewayVoucher(gateway, voucherNumber);
        this.voucher = null;
    }

    protected void setGatewayVoucher(GatewayVoucher gatewayVoucher) {
        this.gatewayVoucher = gatewayVoucher;
        this.voucher = null;
    }

    @Override
    protected void destroyVoucher() {
        this.voucher = null;
        this.gatewayVoucher = null;
    }

    @Override
    public Voucher getVoucher() {
        return this.voucher;
    }

    public GatewayVoucher getGatewayVoucher() {
        return this.gatewayVoucher;
    }

    public BaseVoucher getBaseVoucher() {
        return this.voucher != null ? this.voucher : this.gatewayVoucher;
    }

    @Override
    public String getDisplayText(BaseAdapter.DisplayText displayText) {
        switch (displayText) {
            case ScanDialogTitle: {
                return SP.getRS("scan_voucher_2");
            }
            case LastUsedTitle: {
                return SP.getRS("Last_Used");
            }
            case RedeemedMsg: {
                return SP.getRS("voucher_redeemed_cant_modify");
            }
            case VoucherNumberDsiplay: {
                String outMsg = "";
                outMsg = this.voucher != null ? MessageFormat.format(SP.getRS("Voucher_Type_Voucher_Number"), this.voucher.getVoucherType().getName(), this.voucher.getDisplayNumber()) : MessageFormat.format(SP.getRS("Voucher_Type_Voucher_Number"), VoucherGatewayManager.getInstance().getGatewayTypeName(), this.gatewayVoucher.getNumber());
                return outMsg;
            }
            case WrittenOffMsg: {
                return SP.getRS("voucher_written_off_cant_modify");
            }
        }
        return "";
    }

    @Override
    public long getSecurity() {
        return 11155L;
    }
}

