/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.awt.Frame;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.PosDateFormatter;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.pay.RetTranP;
import jpos.pay.VoucherPinDlg;
import jpos.voucher.DlgStatusDetails;
import jpos.voucher.GatewayVoucher;
import jpos.voucher.VoucherAdapter;
import jpos.voucher.VoucherGatewayException;
import jpos.voucher.VoucherGatewayManager;
import jpos.voucher.VoucherType;
import jpos.voucher.VoucherUtils;

public class VoucherRedeemAdapter
extends VoucherAdapter {
    private Vector<RetTranP> existingPayments;
    private PosFrame parentWindow;
    private VoucherType voucherType;
    private boolean promptForPin;

    public VoucherRedeemAdapter(PosFrame parentWindow, Vector<RetTranP> existingPayments) {
        this.existingPayments = existingPayments;
        this.parentWindow = parentWindow;
    }

    public boolean promptForPin() {
        return this.promptForPin;
    }

    @Override
    public boolean processNumber(String voucherNumber) {
        String mappedVoucher;
        if (voucherNumber == null || voucherNumber.equals("")) {
            return false;
        }
        this.voucherType = VoucherUtils.getVoucherType(voucherNumber);
        if (this.voucherType != null && !StringUtils.isNullOrEmpty(mappedVoucher = VoucherGatewayManager.getMappedVoucher(voucherNumber))) {
            voucherNumber = mappedVoucher;
            this.voucherType = null;
        }
        if (this.voucherType == null && VoucherGatewayManager.isGatewayInUse() && VoucherGatewayManager.getInstance().isValidGatewayVoucher(voucherNumber)) {
            if (!VoucherGatewayManager.isGatewayReady(this.parentWindow)) {
                return false;
            }
            VoucherPinDlg dlgPin = new VoucherPinDlg((Frame)this.parentWindow, SP.getRS("enter_pin"));
            dlgPin.setVisible(true);
            dlgPin.dispose();
            if (dlgPin.getResult()) {
                try {
                    GatewayVoucher voucher = VoucherGatewayManager.getInstance().getGateway().getBalance(voucherNumber, dlgPin.getPin());
                    if (!(voucher.getAvailableAmount() > 0.0)) {
                        DlgMessage dlgMessage = new DlgMessage(this.parentWindow, SP.getRS("Stop"), SP.getRS("voucher_gateway_no_available_funds"), 2, 0);
                        dlgMessage.getOkButton().setText(SP.getRS("Details"));
                        dlgMessage.getCancelButton().setText(SP.getRS("Close"));
                        if (dlgMessage.showMessage() == 0) {
                            this.setGatewayVoucher(voucher);
                            DlgStatusDetails dlgStatusDetails = new DlgStatusDetails(this.parentWindow, SP.getRS("Gift_Voucher_Balance_Enquiry"), true);
                            dlgStatusDetails.loadDetails(this);
                            dlgStatusDetails.setVisible(true);
                            this.destroyVoucher();
                        }
                        return false;
                    }
                    voucher.setPin(dlgPin.getPin());
                    voucher.setGatewayTransactionId(null);
                    this.setGatewayVoucher(voucher);
                }
                catch (VoucherGatewayException e) {
                    DlgMessage.showMessage(this.parentWindow, e.getMessage(), SP.getRS("Error"), 0);
                    return false;
                }
            }
            return true;
        }
        if (this.voucherType == null) {
            if ((voucherNumber = VoucherUtils.getInternalNum(voucherNumber)) != null) {
                this.voucherType = VoucherUtils.getVoucherType(voucherNumber);
            }
            if (this.voucherType == null) {
                DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_number_not_valid"), StoreParams.res.getString("Stop"), 0);
                return false;
            }
        }
        for (int i = 0; i < this.existingPayments.size(); ++i) {
            RetTranP retTranP = this.existingPayments.elementAt(i);
            if (!retTranP.getPayType().isVoucher || !PosUtils.PadRight(voucherNumber, 20, "0").equals(PosUtils.PadRight(retTranP.getPaymentNum(), 20, "0"))) continue;
            DlgMessage.showMessage(this.parentWindow, SP.getRS("GV_AlreadyRedeemed"), SP.getRS("Stop"), -1, 0);
            return false;
        }
        if (!this.voucherType.isActive() && this.voucherType.getIssueType() == VoucherType.IssueType.PROMO) {
            if (!this.voucherType.isRangeAtStore()) {
                DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_not_at_store"), StoreParams.res.getString("Stop"), 0);
            } else {
                DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_type_suspended"), StoreParams.res.getString("Stop"), 0);
            }
            return false;
        }
        if ((this.voucherType.getIssueType() == VoucherType.IssueType.SOLD || this.voucherType.getIssueType() == VoucherType.IssueType.PROMO && this.voucherType.isIssueWithSale()) && !VoucherUtils.isVoucherNumberExists(voucherNumber)) {
            DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_number_not_valid"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        if (this.voucherType.useCheckDigit() && !VoucherUtils.verifyCheckDigit(voucherNumber)) {
            DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_number_not_valid"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        this.createVoucher(this.voucherType, voucherNumber);
        if (!this.getVoucher().isIssued()) {
            DlgMessage.showMessage(this.parentWindow, SP.getRS("GV_NotIssued"), SP.getRS("Stop"), -1, 0);
            this.destroyVoucher();
            return false;
        }
        if (!this.getVoucher().getCurrencyIdx().equals("") && !this.getVoucher().getCurrencyIdx().equals(SP.sParams.storeCurrency.getIdx())) {
            Object[] objs = new Object[]{"Gift voucher", this.getVoucher().getNumber(), this.getVoucher().getCurrencyCode(), SP.sParams.storeCurrency.getCode()};
            DlgMessage.showMessage(this.parentWindow, MessageFormat.format(SP.getRS("voucher_creditnote_wrong_currency"), objs), StoreParams.res.getString("Stop"), 0);
            this.destroyVoucher();
            return false;
        }
        if (SP.sParams.storeCurrency.round(this.getVoucher().getAvailableAmount()) <= 0.0) {
            DlgMessage dlgMessage = new DlgMessage(this.parentWindow, SP.getRS("Stop"), StoreParams.res.getString("GV_AlreadyRedeemed"), 2, 0);
            dlgMessage.getOkButton().setText(SP.getRS("Details"));
            dlgMessage.getCancelButton().setText(SP.getRS("Close"));
            if (dlgMessage.showMessage() == 0) {
                DlgStatusDetails dlgStatusDetails = new DlgStatusDetails(this.parentWindow, StoreParams.res.getString("Gift_Voucher_Balance_Enquiry"), true);
                dlgStatusDetails.loadDetails(this);
                dlgStatusDetails.setVisible(true);
            }
            this.destroyVoucher();
            return false;
        }
        if (this.getVoucher().getExpiryDate() != null) {
            Date dToday = new Date(new java.util.Date().getTime());
            PosDateFormatter.truncateTime(dToday);
            PosDateFormatter.truncateTime(this.getVoucher().getExpiryDate());
            if (dToday.getTime() > this.getVoucher().getExpiryDate().getTime()) {
                PosDateFormatter dateFormatter = new PosDateFormatter(new Timestamp(this.getVoucher().getExpiryDate().getTime()), 3, 3, 0);
                Object[] objs = new Object[]{dateFormatter.toString()};
                DlgMessage dlgMessage = new DlgMessage(this.parentWindow, SP.getRS("Stop"), MessageFormat.format(SP.getRS("GV_Expired"), objs), 2, 0);
                dlgMessage.getOkButton().setText(SP.getRS("Details"));
                dlgMessage.getCancelButton().setText(SP.getRS("Close"));
                if (dlgMessage.showMessage() == 0) {
                    DlgStatusDetails dlgStatusDetails = new DlgStatusDetails(this.parentWindow, StoreParams.res.getString("Gift_Voucher_Balance_Enquiry"), true);
                    dlgStatusDetails.loadDetails(this);
                    dlgStatusDetails.setVisible(true);
                }
                this.destroyVoucher();
                return false;
            }
        }
        if (this.voucherType.isSecure() && this.voucherType.getIssueType() == VoucherType.IssueType.SOLD) {
            this.promptForPin = true;
            if (!this.getVoucher().isPinAvailable()) {
                if (this.getVoucher().getIssuedStore() != null && this.getVoucher().getIssuedStore().equals(String.valueOf(SP.sParams.getStoreIdx()))) {
                    this.promptForPin = false;
                } else {
                    DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("vouche_outofdate"), StoreParams.res.getString("Stop"), 0);
                    this.destroyVoucher();
                    return false;
                }
            }
        }
        return true;
    }
}

