/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.awt.Window;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.pay.eftpos.EftposUtils;
import jpos.voucher.VoucherType;
import org.jdom.Element;

public class VoucherUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getInternalNum(String externalVoucherNum) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT NUM FROM GVCN_MAINT WHERE EXTERNAL_NUM = UPPER(?) ORDER BY GVCNIDX");){
            stmt.setString(1, externalVoucherNum);
            try (ResultSet result = stmt.executeQuery();){
                if (!result.next()) return null;
                String internalNum = result.getString(1);
                if (StringUtils.isNullOrEmpty(internalNum)) {
                    internalNum = null;
                }
                String string = internalNum;
                return string;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isVoucherNumberExists(String externalVoucherNum) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("select 1 from online_q_promo_voucher_res where vouchernumber = '" + externalVoucherNum + "'\r\n" + "union\r\n" + "select 1 from GVCN_MAINT where \"TYPE\" = 0 and \"ACTIVE\" = 1 and num = '" + externalVoucherNum + "'");
             ResultSet result = stmt.executeQuery();){
            if (!result.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VoucherType getVoucherType(String voucherNum) {
        long vouchNumWithCheckdigit;
        try {
            vouchNumWithCheckdigit = Long.parseLong(voucherNum);
        }
        catch (NumberFormatException e) {
            return null;
        }
        long vouchNumWithoutCheckdigit = vouchNumWithCheckdigit / 10L;
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT G.GVRIDX FROM REFCODE R, GIFT_VOUCHER_RANGE G WHERE R.RGIDX = 368 AND R.RCIDX = G.RCIDX AND ( (COALESCE(G.USE_CHECK_DIGIT, 0) = 0 AND G.FROM_NUM <= ? AND G.TO_NUM >= ?) OR (G.USE_CHECK_DIGIT = 1 AND G.FROM_NUM <= ? AND G.TO_NUM >= ?)) ORDER BY G.GVRIDX");){
            stmt.setLong(1, vouchNumWithCheckdigit);
            stmt.setLong(2, vouchNumWithCheckdigit);
            stmt.setLong(3, vouchNumWithoutCheckdigit);
            stmt.setLong(4, vouchNumWithoutCheckdigit);
            try (ResultSet result = stmt.executeQuery();){
                if (!result.next()) return null;
                VoucherType voucherType = new VoucherType(result.getLong(1));
                return voucherType;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return null;
    }

    public static String cleanVoucherNumber(String voucherNumber) {
        StringBuffer sbOriginal = new StringBuffer(voucherNumber);
        StringBuffer sbReturn = new StringBuffer();
        for (int i = 0; i < sbOriginal.length(); ++i) {
            if (!(sbOriginal.charAt(i) >= '0' && sbOriginal.charAt(i) <= '9' || sbOriginal.charAt(i) >= 'A' && sbOriginal.charAt(i) <= 'Z') && (sbOriginal.charAt(i) < 'a' || sbOriginal.charAt(i) > 'z')) continue;
            sbReturn.append(sbOriginal.charAt(i));
        }
        return sbReturn.toString();
    }

    public static boolean isVoucher(long skuidx) {
        return SP.sParams.gvSkus.contains(String.valueOf(skuidx));
    }

    public static void completePendingVouchers(Connection con, long vhidx) throws Exception {
        try (PreparedStatement stmt = con.prepareStatement("UPDATE GVCN_MAINT SET AMT = PENDING_AMT WHERE PENDING_AMT IS NOT NULL AND PENDING_VHIDX = ?");){
            stmt.setLong(1, vhidx);
            stmt.execute();
        }
        stmt = con.prepareStatement("UPDATE GVCN_MAINT SET USED_AMT = PENDING_USED_AMT WHERE PENDING_USED_AMT IS NOT NULL AND PENDING_VHIDX = ?");
        var4_3 = null;
        try {
            stmt.setLong(1, vhidx);
            stmt.execute();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var4_3 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        stmt = con.prepareStatement("UPDATE GVCN_MAINT SET PENDING_AMT = NULL, PENDING_USED_AMT = NULL, PENDING_VHIDX = NULL, LAST_REDEEMED_WIDX = ?, LAST_REDEEMED_DATE = CURRENT_TIMESTAMP WHERE PENDING_VHIDX = ?");
        var4_3 = null;
        try {
            stmt.setLong(1, SP.sParams.getStoreIdx());
            stmt.setLong(2, vhidx);
            stmt.execute();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var4_3 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    public static void cancelPendingVouchers(Window parent, Connection con, long vhidx) throws SQLException {
        EftposUtils.debugPoint(parent, "Deleting from GVCN_MAINT table\nISSUE_VHIDX: " + vhidx);
        EftposUtils.debugPoint(parent, PosUtils.getDatabaseRecordAsText(SP.sParams.conn, "GVCN_MAINT", "ISSUE_VHIDX = " + vhidx));
        try (PreparedStatement stmt = con.prepareStatement("DELETE FROM GVCN_MAINT WHERE ISSUE_VHIDX = ?");){
            stmt.setLong(1, vhidx);
            stmt.execute();
        }
        stmt = con.prepareStatement("UPDATE GVCN_MAINT SET PENDING_AMT = NULL, PENDING_USED_AMT = NULL, PENDING_VHIDX = NULL WHERE PENDING_VHIDX = ?");
        var5_4 = null;
        try {
            stmt.setLong(1, vhidx);
            stmt.execute();
        }
        catch (Throwable throwable) {
            var5_4 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var5_4 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var5_4.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
    }

    public static void changeExpiryDate(Connection con, long gvcnidx, Date expiry, long memidx) throws Exception {
        try (PreparedStatement stmt = con.prepareStatement("UPDATE GVCN_MAINT SET EXPIRY_DATE = ?, UPMEMIDX = ?, UPDT = CURRENT_TIMESTAMP WHERE GVCNIDX = ?");){
            stmt.setDate(1, expiry);
            stmt.setLong(2, memidx);
            stmt.setLong(3, gvcnidx);
            stmt.execute();
            SP.sParams.yTabInsert("GVCN_MAINT", "GVCNIDX", String.valueOf(gvcnidx));
        }
    }

    public static boolean verifyCheckDigit(String voucherNumber) {
        char[] voucherDigits = voucherNumber.toCharArray();
        int sum = 0;
        boolean odd = true;
        if (!Character.isDigit(voucherDigits[voucherDigits.length - 1])) {
            return false;
        }
        for (int i = voucherDigits.length - 2; i >= 0; --i) {
            if (!Character.isDigit(voucherDigits[i])) {
                return false;
            }
            sum = odd ? (sum += Character.getNumericValue(voucherDigits[i]) * 3) : (sum += Character.getNumericValue(voucherDigits[i]));
            odd = !odd;
        }
        return (sum + Character.getNumericValue(voucherDigits[voucherDigits.length - 1])) % 10 == 0;
    }

    public static String decryptPin(String encryptPin) {
        char[] encryptPinChars = encryptPin.toCharArray();
        int[] gaps = encryptPinChars[3] == 'C' && encryptPinChars[8] == 'G' ? new int[]{0, 5, 13, 8} : (encryptPinChars[3] == 'K' && encryptPinChars[8] == 'Q' ? new int[]{7, 2, 11, 14} : (encryptPinChars[3] == 'F' && encryptPinChars[8] == 'L' ? new int[]{4, 15, 1, 3} : new int[]{6, 12, 10, 9}));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int second;
            char first;
            switch (i) {
                case 0: {
                    first = encryptPinChars[6];
                    second = encryptPinChars[1];
                    break;
                }
                case 1: {
                    first = encryptPinChars[2];
                    second = encryptPinChars[5];
                    break;
                }
                case 2: {
                    first = encryptPinChars[7];
                    second = encryptPinChars[9];
                    break;
                }
                default: {
                    first = encryptPinChars[4];
                    second = encryptPinChars[0];
                }
            }
            if (second < first) {
                second += 26;
            }
            sb.append(second - first - gaps[i]);
        }
        return sb.toString();
    }

    public static String getGatewayVoucher(String voucherNumber) {
        return "";
    }

    public static boolean usingCreditNoteGiftCards() {
        boolean isSetup = false;
        String GvType = "";
        String GvSKU = "";
        try {
            SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT GVTYPE_RCIDX, GV_SKUIDX FROM GIFTVOUCHER_STORE_SETUP");
            if (sql.next()) {
                GvType = sql.getString(1);
                GvSKU = sql.getString(2);
                if (GvType != null && !GvType.equals("") && GvSKU != null && !GvSKU.equals("")) {
                    isSetup = true;
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return isSetup;
    }

    public static String getNextVoucherNumber(String voucherType) {
        Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("giftvoucher_number_query", voucherType).getXML();
        String GvNumber = XMLUtils.getValue(response, "gv_number");
        return GvNumber;
    }

    public static String getCreditNoteGiftVoucherType() {
        String result = "";
        try {
            String data;
            SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT GVTYPE_RCIDX FROM GIFTVOUCHER_STORE_SETUP");
            if (sql.next() && (data = sql.getString(1)) != "" && data != null) {
                result = data;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getCreditNoteGiftVoucherSKU() {
        String result = "";
        try {
            String data;
            SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT GV_SKUIDX FROM GIFTVOUCHER_STORE_SETUP");
            if (sql.next() && (data = sql.getString(1)) != "" && data != null) {
                result = data;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getVoucherPin(String voucherNumber) {
        String vouch = voucherNumber.replace("CN", "");
        String vouchType = VoucherUtils.getCreditNoteGiftVoucherType();
        String params = vouch + "," + vouchType;
        Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("giftvoucher_pin_query", params).getXML();
        String GvPin = XMLUtils.getValue(response, "gv_pin");
        return GvPin;
    }
}

