/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher.vii;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.bind.JAXBException;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.voucher.GatewayVoucher;
import jpos.voucher.IVoucherGateway;
import jpos.voucher.VoucherGatewayException;
import jpos.voucher.vii.CheckBalanceRequest;
import jpos.voucher.vii.CheckBalanceResponse;
import jpos.voucher.vii.LoadRequest;
import jpos.voucher.vii.LoadResponse;
import jpos.voucher.vii.NewOrderRequest;
import jpos.voucher.vii.NewOrderResponse;
import jpos.voucher.vii.RedemptionRequest;
import jpos.voucher.vii.RedemptionResponse;
import jpos.voucher.vii.Request;
import jpos.voucher.vii.Response;
import jpos.voucher.vii.VerifyStoreResponse;
import jpos.voucher.vii.ViiApi;
import jpos.voucher.vii.ViiApiException;
import jpos.voucher.vii.ViiConfig;
import jpos.voucher.vii.ViiDigitalConfig;
import jpos.voucher.vii.ViiOrderItem;
import jpos.voucher.vii.XmlSerialiser;
import org.jdom.Element;

public class ViiGateway
implements IVoucherGateway {
    public static final String RESPONSE_CODE_OK = "0";
    public static final String RESPONSE_CODE_INSUFFICIENT_FUNDS = "5";
    public static final String RESPONSE_CODE_INVALID_NUMBER = "6";
    public static final String RESPONSE_CODE_INVALID_PIN = "9";
    private static final String STATUS_NOT_ISSUED = "0";
    private static final String STATUS_ACTIVE = "1";
    private static final String STATUS_EXPIRED = "2";
    private static final String STATUS_SUSPENDED = "3";
    private static final String STATUS_CANCELLED = "4";
    private static final String REQUEST_TYPE_LOAD = "LOAD";
    private static final String REQUEST_TYPE_REDEMPTION = "REDEMPTION";
    private static final String REQUEST_TYPE_NEW = "NEWORDER";
    private static final int RETRY_INTERVAL_MILLISECONDS = 300000;
    private static final long RETRY_MAX_MILLISECONDS = 86400000L;
    private ViiApi api;
    private ViiConfig config;
    private Timer retryTimer;
    private Connection mainConnection;
    private Connection backgroundConnection;
    private Object retryLock = new Object();
    private boolean _hasDigital = false;
    private boolean _isNameRequired = true;

    public boolean getIsNameRequired() {
        return this._isNameRequired;
    }

    public void setisNameRequried(boolean value) {
        this._isNameRequired = value;
    }

    public ViiGateway(long gatewayIdx) throws VoucherGatewayException {
        this.config = this.LoadConfig(gatewayIdx);
        this.api = new ViiApi(this.config);
        this.verifyStore();
        this.initialise(SP.sParams.tillnum);
    }

    private ViiConfig LoadConfig(long gatewayIdx) throws VoucherGatewayException {
        ViiConfig config = new ViiConfig();
        Element element = SP.sParams.OnlineQueryProvider.getOnlineQuery("gift_voucher_api", String.valueOf(gatewayIdx) + "," + String.valueOf(SP.sParams.getStoreIdx()), false).getXML();
        if (element != null && element.getName() == "gift_voucher_api") {
            config.setUrl(element.getAttributeValue("api_url"));
            config.setStoreId(element.getAttributeValue("api_store_id"));
            config.setStoreGroupId(element.getAttributeValue("api_store_group_id"));
            config.setUsername(element.getAttributeValue("api_username"));
            config.setPassword(element.getAttributeValue("api_password"));
            config.setMinValue(Double.parseDouble(element.getAttributeValue("api_min_value") != null ? element.getAttributeValue("api_min_value") : "0"));
            config.setMaxValue(Double.parseDouble(element.getAttributeValue("api_max_value") != null ? element.getAttributeValue("api_max_value") : "0"));
            if (element.getAttributeValue("has_digital").equals(STATUS_ACTIVE)) {
                this._hasDigital = true;
                ViiDigitalConfig digitalConfig = new ViiDigitalConfig();
                digitalConfig.setUsername(element.getAttributeValue("dig_api_username"));
                digitalConfig.setPassword(element.getAttributeValue("dig_api_password"));
                digitalConfig.setUrl(element.getAttributeValue("dig_api_url").trim());
                digitalConfig.setMailOrderBin(element.getAttributeValue("dig_api_mail_order_bin"));
                digitalConfig.setCardDesign(element.getAttributeValue("dig_api_card_design"));
                digitalConfig.setSourceId(element.getAttributeValue("dig_api_source_id"));
                digitalConfig.setMinValue(Double.parseDouble(element.getAttributeValue("dig_api_min_value") != null ? element.getAttributeValue("dig_api_min_value") : "0"));
                digitalConfig.setMaxValue(Double.parseDouble(element.getAttributeValue("dig_api_max_value") != null ? element.getAttributeValue("dig_api_max_value") : "0"));
                digitalConfig.setDigitalRefundCardDesign(element.getAttributeValue("dig_refund_card_design"));
                digitalConfig.setDigitalRefundBarcode(element.getAttributeValue("dig_refund_product_barcode"));
                digitalConfig.setDigitalRefundProductIdx(element.getAttributeValue("dig_refund_product_idx"));
                config.setDigitalConfig(digitalConfig);
            }
        } else {
            throw new VoucherGatewayException("vii_online_query_error", "\n", XMLUtils.getValue(element, "error_msg"));
        }
        return config;
    }

    @Override
    public GatewayVoucher loadVoucher(long vhidx, long vshidx, String cardNumber, double amount, String reference) throws VoucherGatewayException {
        LoadRequest request = new LoadRequest(this.config, cardNumber, amount, reference);
        String requestIdx = this.logRequest(vhidx, vshidx, request, amount);
        GatewayVoucher voucher = new GatewayVoucher(this, cardNumber);
        voucher.setGatewayTransactionId(request.getTransactionId());
        voucher.setReference(reference);
        try {
            LoadResponse response = this.api.LoadGiftVoucher(request);
            ViiGateway.checkResponse(response);
            this.logSuccess(requestIdx);
            voucher.setAuthCode(response.getAuthCode());
            voucher.setReceiptNumber(response.getReceiptNumber());
            voucher.setOriginalAmount(response.getAvailableBalance());
            voucher.setIssueDate(response.getIssuanceDate());
            voucher.setExpiryDate(response.getExpiryDate());
            return voucher;
        }
        catch (ViiApiException e) {
            this.logFailure(requestIdx, e.getMessage(), e.requiresUndo());
            if (!e.requiresUndo()) {
                throw e;
            }
            try {
                this.markForRetry(requestIdx, request);
            }
            catch (SQLException | JAXBException ex) {
                PosUtils.logError(ex);
                throw new VoucherGatewayException("vii_gateway_exception", e.getMessage());
            }
            voucher.setDeferred(true);
            voucher.setAuthCode(null);
            voucher.setReceiptNumber(null);
            voucher.setOriginalAmount(amount);
            voucher.setIssueDate(null);
            voucher.setExpiryDate(null);
            return voucher;
        }
    }

    @Override
    public GatewayVoucher orderVoucher(long vhidx, long vshidx, String recipientName, String recipientSurname, String recipientEmail, String message, double amount, String reference, double quantity) throws VoucherGatewayException {
        return this.orderVoucher(vhidx, vshidx, recipientName, recipientSurname, recipientEmail, message, amount, reference, quantity, false);
    }

    public GatewayVoucher orderVoucher(List<ViiOrderItem> orderItems, String salesRepFirstName, String salesRepSurname) throws VoucherGatewayException {
        if (orderItems != null && !orderItems.isEmpty()) {
            NewOrderRequest request = new NewOrderRequest(this.config, orderItems, salesRepFirstName, salesRepSurname);
            String requestIdx = this.logRequest(orderItems.get(0).getVhidx(), orderItems.get(0).getVshidx(), request, orderItems.get(0).getGross());
            GatewayVoucher voucher = new GatewayVoucher(this, "");
            voucher.setGatewayTransactionId(request.getTransactionId());
            try {
                NewOrderResponse response = this.api.NewGiftVoucher(request);
                ViiGateway.checkResponse(response);
                voucher.setReference(response.getSourceReference());
                voucher.setReceiptNumber(response.getViiOrderNumber());
                voucher.setPin(response.getActivationPin());
                voucher.setQuantityOrdered(response.getQuantityOrdered());
                return voucher;
            }
            catch (ViiApiException e) {
                this.logFailure(requestIdx, e.getMessage(), e.requiresUndo());
                if (!e.requiresUndo()) {
                    throw e;
                }
                try {
                    this.newOrderMarkForRetry(requestIdx, request);
                }
                catch (SQLException | JAXBException ex) {
                    PosUtils.logError(ex);
                    throw new VoucherGatewayException("vii_gateway_exception", e.getMessage());
                }
                voucher.setDeferred(true);
                voucher.setReference(null);
                voucher.setReceiptNumber(null);
                voucher.setPin(null);
                voucher.setQuantityOrdered(null);
                return voucher;
            }
        }
        return null;
    }

    @Override
    public GatewayVoucher orderVoucher(long vhidx, long vshidx, String recipientName, String recipientSurname, String recipientEmail, String message, double amount, String reference, double quantity, boolean isRefund) throws VoucherGatewayException {
        NewOrderRequest request = new NewOrderRequest(this.config, recipientName, recipientSurname, recipientEmail, message, amount, reference, quantity, isRefund);
        String requestIdx = this.logRequest(vhidx, vshidx, request, amount);
        GatewayVoucher voucher = new GatewayVoucher(this, "");
        voucher.setGatewayTransactionId(request.getTransactionId());
        voucher.setReference(reference);
        try {
            NewOrderResponse response = this.api.NewGiftVoucher(request);
            ViiGateway.checkResponse(response);
            this.logSuccess(requestIdx);
            voucher.setReference(response.getSourceReference());
            voucher.setReceiptNumber(response.getViiOrderNumber());
            voucher.setPin(response.getActivationPin());
            voucher.setQuantityOrdered(response.getQuantityOrdered());
            return voucher;
        }
        catch (ViiApiException e) {
            this.logFailure(requestIdx, e.getMessage(), e.requiresUndo());
            if (!e.requiresUndo()) {
                throw e;
            }
            try {
                this.newOrderMarkForRetry(requestIdx, request);
            }
            catch (SQLException | JAXBException ex) {
                PosUtils.logError(ex);
                throw new VoucherGatewayException("vii_gateway_exception", e.getMessage());
            }
            voucher.setDeferred(true);
            voucher.setReference(null);
            voucher.setReceiptNumber(null);
            voucher.setPin(null);
            voucher.setQuantityOrdered(null);
            return voucher;
        }
    }

    @Override
    public GatewayVoucher getBalance(String cardNumber, String pin) throws VoucherGatewayException {
        CheckBalanceRequest request = new CheckBalanceRequest(this.config, cardNumber, pin);
        GatewayVoucher voucher = new GatewayVoucher(this, cardNumber);
        voucher.setGatewayTransactionId(request.getTransactionId());
        CheckBalanceResponse response = this.api.CheckCardBalance(cardNumber, pin);
        ViiGateway.checkResponse(response);
        voucher.setAuthCode(response.getAuthCode());
        voucher.setSerialNumber(response.getSerialNumber());
        voucher.setOriginalAmount(response.getAvailableBalance());
        voucher.setIssueDate(response.getIssuanceDate());
        voucher.setExpiryDate(response.getExpiryDate());
        voucher.setCardStatus(response.getCardStatusId());
        return voucher;
    }

    @Override
    public GatewayVoucher redeemVoucher(long vhidx, long vshidx, String cardNumber, String pin, double amount, String reference) throws VoucherGatewayException {
        RedemptionRequest request = new RedemptionRequest(this.config, cardNumber, pin, amount, reference);
        String requestIdx = this.logRequest(vhidx, vshidx, request, amount);
        GatewayVoucher voucher = new GatewayVoucher(this, cardNumber);
        voucher.setGatewayTransactionId(request.getTransactionId());
        voucher.setReference(reference);
        try {
            RedemptionResponse response = this.api.RedeemGiftVoucher(request);
            ViiGateway.checkResponse(response);
            this.logSuccess(requestIdx);
            voucher.setAuthCode(response.getAuthCode());
            voucher.setOriginalAmount(response.getAvailableBalance());
            voucher.setSettlementDate(response.getSettlementDate());
            voucher.setReceiptNumber(response.getReceiptNumber());
            voucher.setExpiryDate(response.getExpiryDate());
        }
        catch (ViiApiException e) {
            this.logFailure(requestIdx, e.getMessage(), e.requiresUndo());
            if (e.requiresUndo()) {
                try {
                    this.undoRequest(this.mainConnection, requestIdx, cardNumber, request.getTransactionId(), true);
                }
                catch (SQLException ex) {
                    PosUtils.logError(ex);
                }
            }
            throw e;
        }
        return voucher;
    }

    @Override
    public void cancelRedemption(long vhidx, long vshidx, GatewayVoucher voucher) {
        try {
            this.undoRequest(this.mainConnection, vhidx, vshidx, voucher.getNumber(), voucher.getGatewayTransactionId(), true);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    @Override
    public double getMinValue() {
        return this.config.getMinValue();
    }

    @Override
    public double getMaxValue() {
        return this.config.getMaxValue();
    }

    public String getDigitalRefundBarcode() {
        return this.config.getDigitalConfig().getDigitalRefundBarcode();
    }

    private void verifyStore() throws VoucherGatewayException {
        VerifyStoreResponse response = null;
        try {
            response = this.api.VerifyStore();
        }
        catch (ViiApiException e) {
            throw new VoucherGatewayException("vii_verify_store_error", "\n", e.getMessage(), "");
        }
        if (!"0".equals(response.getResponseCode())) {
            throw new VoucherGatewayException("vii_verify_store_error", "\n", response.getResponseMessage(), MessageFormat.format(SP.getRS("vii_contact_head_office"), "\n"));
        }
    }

    @Override
    public void cancelAllLoadRequests(long vhidx) {
        try (SqlQuery qry = new SqlQuery(this.mainConnection, "SELECT IDX, VOUCHER_NUMBER, TRANSACTION_ID, UNDONE_FLAG FROM VII_REQUEST WHERE VHIDX = ? AND REQUEST_TYPE = ? AND IN_PROGRESS = 1", vhidx, REQUEST_TYPE_LOAD);){
            while (qry.next()) {
                if (!qry.getBoolean("UNDONE_FLAG")) {
                    this.undoRequest(this.mainConnection, qry.getString("IDX"), qry.getString("VOUCHER_NUMBER"), qry.getString("TRANSACTION_ID"), false);
                }
                SqlQuery.executeUpdate(this.mainConnection, "UPDATE VII_REQUEST SET IN_PROGRESS = NULL, NEEDS_RETRY = NULL, RETRY_TEMPLATE = NULL WHERE IDX = ?", qry.getString("IDX"));
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    @Override
    public void cancelNewOrderRequests(long vhidx) {
        try (SqlQuery qry = new SqlQuery(this.mainConnection, "SELECT IDX, VOUCHER_NUMBER, TRANSACTION_ID, UNDONE_FLAG FROM VII_REQUEST WHERE VHIDX = ? AND REQUEST_TYPE = ? AND IN_PROGRESS = 1", vhidx, REQUEST_TYPE_NEW);){
            while (qry.next()) {
                if (!qry.getBoolean("UNDONE_FLAG")) {
                    this.undoRequest(this.mainConnection, qry.getString("IDX"), qry.getString("VOUCHER_NUMBER"), qry.getString("TRANSACTION_ID"), false);
                }
                SqlQuery.executeUpdate(this.mainConnection, "UPDATE VII_REQUEST SET IN_PROGRESS = NULL, NEEDS_RETRY = NULL, RETRY_TEMPLATE = NULL WHERE IDX = ?", qry.getString("IDX"));
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    @Override
    public void finaliseTransaction(long vhidx) {
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT R.IDX, COALESCE(D.\"ACTIVE\", 0) AS CONFIRMED FROM VII_REQUEST R LEFT JOIN RET_TRAND D ON R.VSHIDX = D.VSHIDX WHERE R.VHIDX = ? AND R.REQUEST_TYPE IN (?,?) AND R.IN_PROGRESS = 1 UNION ALL SELECT R.IDX, COALESCE(P.\"ACTIVE\", 0) AS CONFIRMED FROM VII_REQUEST R LEFT JOIN RET_TRANP P ON R.VSHIDX = P.VSHIDX WHERE R.VHIDX = ? AND R.REQUEST_TYPE = ? AND R.IN_PROGRESS = 1", vhidx, REQUEST_TYPE_LOAD, REQUEST_TYPE_NEW, vhidx, REQUEST_TYPE_REDEMPTION);){
            while (qry.next()) {
                if (qry.getBoolean("CONFIRMED")) {
                    SqlQuery.executeUpdate(this.mainConnection, "UPDATE VII_REQUEST SET IN_PROGRESS = NULL WHERE IDX = ?", qry.getString("IDX"));
                    continue;
                }
                SqlQuery.executeUpdate(this.mainConnection, "UPDATE VII_REQUEST SET NEEDS_UNDO = CASE WHEN UNDONE_FLAG = 1 THEN NULL ELSE 1 END, NEEDS_RETRY = NULL, RETRY_TEMPLATE = NULL, IN_PROGRESS = NULL WHERE IDX = ?", qry.getString("IDX"));
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String logRequest(long vhidx, long vshidx, Request request, double amount) throws VoucherGatewayException {
        try {
            String voucherNumber;
            String type;
            if (request instanceof LoadRequest) {
                type = REQUEST_TYPE_LOAD;
                voucherNumber = ((LoadRequest)request).getCardNumber();
            } else if (request instanceof RedemptionRequest) {
                type = REQUEST_TYPE_REDEMPTION;
                voucherNumber = ((RedemptionRequest)request).getCardNumber();
            } else {
                if (!(request instanceof NewOrderRequest)) throw new IllegalStateException("Request must be either Load or Redemption");
                type = REQUEST_TYPE_NEW;
                voucherNumber = ((NewOrderRequest)request).getCardNumber();
            }
            SqlQuery.executeUpdate(this.mainConnection, "UPDATE VII_REQUEST SET NEEDS_UNDO = CASE WHEN UNDONE_FLAG = 1 THEN NULL ELSE 1 END, NEEDS_RETRY = NULL, RETRY_TEMPLATE = NULL, IN_PROGRESS = NULL WHERE VHIDX = ? AND VSHIDX = ? AND REQUEST_TYPE = ? AND IN_PROGRESS = 1", vhidx, vshidx, type);
            try (SqlQuery qry = new SqlQuery(this.mainConnection, "INSERT INTO VII_REQUEST(IDX, REQUEST_TIME, TILLNAME, VHIDX, VSHIDX,   TRANSACTION_ID, VOUCHER_NUMBER, AMOUNT, REQUEST_TYPE, IN_PROGRESS, SUCCESS_FLAG) VALUES(GEN_ID(XVII_REQUEST, 1), CURRENT_TIMESTAMP, ?, ?, ?, ?, ?, ?, ?, 1, -1) RETURNING IDX", SP.sParams.tillnum, vhidx, vshidx, request.getTransactionId(), voucherNumber, amount, type);){
                qry.next();
                String string = qry.getString("IDX");
                return string;
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            throw new VoucherGatewayException("vii_gateway_exception", e.getMessage());
        }
    }

    private boolean undoRequest(Connection conn, long vhidx, long vshidx, String voucherNumber, String transactionId, boolean finalise) throws SQLException {
        String idx = null;
        try (SqlQuery qry = new SqlQuery(conn, "SELECT IDX FROM VII_REQUEST WHERE VHIDX = ? AND VSHIDX = ? AND VOUCHER_NUMBER = ? AND TRANSACTION_ID = ?", vhidx, vshidx, voucherNumber, transactionId);){
            if (qry.next()) {
                idx = qry.getString("IDX");
            }
        }
        return this.undoRequest(conn, idx, voucherNumber, transactionId, finalise);
    }

    private boolean undoRequest(Connection conn, String requestIdx, String voucherNumber, String transactionId, boolean finalise) throws SQLException {
        String finaliseClause = finalise ? "IN_PROGRESS = NULL, " : "";
        try {
            this.api.Undo(voucherNumber, transactionId);
            SqlQuery.executeUpdate(conn, "UPDATE VII_REQUEST SET " + finaliseClause + "UNDO_ATTEMPTS = COALESCE(UNDO_ATTEMPTS, 0) + 1, " + "NEEDS_UNDO = NULL, " + "UNDONE_FLAG = 1 " + "WHERE IDX = ? ", requestIdx);
            return true;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            SqlQuery.executeUpdate(conn, "UPDATE VII_REQUEST SET " + finaliseClause + "UNDO_ATTEMPTS = COALESCE(UNDO_ATTEMPTS, 0) + 1, " + "NEEDS_UNDO = 1, " + "UNDO_RETRY_ERROR = ? " + "WHERE IDX = ? ", StringUtils.truncate(e.getMessage(), 4000), requestIdx);
            return false;
        }
    }

    private void markForRetry(String requestIdx, LoadRequest request) throws SQLException, JAXBException {
        String retryTemplate = request.generateRetryTemplate();
        SqlQuery.executeUpdate(this.mainConnection, "UPDATE VII_REQUEST SET NEEDS_RETRY = 1, RETRY_TEMPLATE = ? WHERE IDX = ?", retryTemplate, requestIdx);
    }

    private void newOrderMarkForRetry(String requestIdx, NewOrderRequest request) throws SQLException, JAXBException {
        String retryTemplate = request.generateRetryTemplate();
        SqlQuery.executeUpdate(this.mainConnection, "UPDATE VII_REQUEST SET NEEDS_RETRY = 1, RETRY_TEMPLATE = ? WHERE IDX = ?", retryTemplate, requestIdx);
    }

    private boolean retryTransaction(Connection conn, String requestIdx, String requestType, long vshidx, String requestTemplate) throws SQLException {
        try {
            Response response;
            Request request;
            if (REQUEST_TYPE_LOAD.equals(requestType)) {
                request = XmlSerialiser.deserialise(LoadRequest.class, requestTemplate);
                request.setConfig(this.config);
                response = this.api.LoadGiftVoucher((LoadRequest)request);
                ViiGateway.checkResponse(response);
                SqlQuery.executeUpdate(conn, "UPDATE RET_TRAND SET GVGATE_DEFERRED_FLAG = 0, GVGATE_BALANCE = ?, GVGATE_RECEIPT_NUM = ?, GVGATE_AUTHCODE = ?, GVGATE_ISSUE_DATE = ?, GVGATE_EXPIRY_DATE = ?, ORIG_EXPIRY_DATE = ?, EXPIRY_DATE = ?, GVGATE_REFERENCE = ? WHERE VSHIDX = ?", ((LoadResponse)response).getAvailableBalance(), ((LoadResponse)response).getReceiptNumber(), ((LoadResponse)response).getAuthCode(), ((LoadResponse)response).getIssuanceDate(), ((LoadResponse)response).getExpiryDate(), ((LoadResponse)response).getExpiryDate(), ((LoadResponse)response).getExpiryDate(), ((LoadRequest)request).getExternalReference(), vshidx);
            }
            if (REQUEST_TYPE_NEW.equals(requestType)) {
                request = XmlSerialiser.deserialise(NewOrderRequest.class, requestTemplate);
                request.setConfig(this.config);
                response = this.api.NewGiftVoucher((NewOrderRequest)request);
                ViiGateway.checkResponse(response);
                String gvOrder = ((NewOrderResponse)response).getViiOrderNumber();
                String styledesc = MessageFormat.format(SP.getRS("Dig_GV_Num"), gvOrder);
                SqlQuery.executeUpdate(conn, "UPDATE RET_TRAND SET GVGATE_DEFERRED_FLAG = 0, GVGATE_RECEIPT_NUM = ?, GVGATE_REFERENCE = ?, DESCRIP1 = ?, LINE_CODE = ?, GVNUM = ?, GVGATE_ISDIGITAL = 1 WHERE VSHIDX = ?", gvOrder, ((NewOrderResponse)response).getSourceReference(), styledesc, gvOrder, gvOrder, vshidx);
            }
            SqlQuery.executeUpdate(conn, "UPDATE VII_REQUEST SET RETRY_ATTEMPTS = COALESCE(RETRY_ATTEMPTS, 0) + 1, NEEDS_RETRY = NULL, REPROCESSED_FLAG = 1 WHERE IDX = ? ", requestIdx);
            SqlQuery.executeUpdate(this.backgroundConnection, "INSERT INTO YVII_REQUEST(YIDX, IDX) VALUES (GEN_ID(XYVII_REQUEST, 1), ?)", requestIdx);
            return true;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            SqlQuery.executeUpdate(conn, "UPDATE VII_REQUEST SET RETRY_ATTEMPTS = COALESCE(RETRY_ATTEMPTS, 0) + 1, UNDO_RETRY_ERROR = ? WHERE IDX = ? ", StringUtils.truncate(e.getMessage(), 4000), requestIdx);
            return false;
        }
    }

    private void logFailure(String requestIdx, String message, boolean unknownState) {
        String knownFailureClause = !unknownState ? "SUCCESS_FLAG = 0, IN_PROGRESS = NULL, " : "";
        try {
            SqlQuery.executeUpdate(this.mainConnection, "UPDATE VII_REQUEST SET " + knownFailureClause + "RESPONSE = ? " + "WHERE IDX = ?", StringUtils.truncate(message, 4000), requestIdx);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private void logSuccess(String requestIdx) {
        try {
            SqlQuery.executeUpdate(this.mainConnection, "UPDATE VII_REQUEST SET SUCCESS_FLAG = 1 WHERE IDX = ?", requestIdx);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private void initialise(final String tillName) throws VoucherGatewayException {
        try {
            this.mainConnection = StoreParams.createNewConnection();
            this.backgroundConnection = StoreParams.createNewConnection();
            ViiGateway.cleanUpInProgressRequests(this.mainConnection);
            this.retryTimer = new Timer();
            this.retryTimer.schedule(new TimerTask(){
                private String till;
                {
                    this.till = tillName;
                }

                @Override
                public void run() {
                    ViiGateway.this.processOutstandingRequests(this.till);
                }
            }, 0L, 300000L);
        }
        catch (Exception e) {
            PosUtils.logError(e);
            try {
                this.close();
            }
            catch (Exception ex) {
                PosUtils.logError(ex);
            }
            throw new VoucherGatewayException("vii_gateway_exception", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processOutstandingRequests(String tillName) {
        Object object = this.retryLock;
        synchronized (object) {
            if (this.backgroundConnection == null) return;
            try (SqlQuery qry = new SqlQuery(this.backgroundConnection, "SELECT IDX, VSHIDX, REQUEST_TYPE, TRANSACTION_ID, VOUCHER_NUMBER, NEEDS_UNDO, NEEDS_RETRY, RETRY_TEMPLATE, UNDO_ATTEMPTS, RETRY_ATTEMPTS, REQUEST_TIME FROM VII_REQUEST WHERE CASE WHEN IN_PROGRESS IS NULL AND COALESCE(NEEDS_UNDO, 0) + COALESCE(NEEDS_RETRY, 0) > 0 THEN TILLNAME ELSE NULL END = ? ", tillName);){
                while (qry.next()) {
                    try {
                        String requestIdx = qry.getString("IDX");
                        boolean needsUndo = qry.getBoolean("NEEDS_UNDO");
                        boolean needsRetry = qry.getBoolean("NEEDS_RETRY");
                        if (!ViiGateway.canRetry(qry.getTimestamp("REQUEST_TIME"))) {
                            SqlQuery.executeUpdate(this.backgroundConnection, "UPDATE VII_REQUEST SET UNDONE_FLAG = CASE WHEN NEEDS_UNDO = 1 THEN -1 ELSE UNDONE_FLAG END, REPROCESSED_FLAG = CASE WHEN NEEDS_RETRY = 1 THEN -1 ELSE REPROCESSED_FLAG END, NEEDS_UNDO = NULL, NEEDS_RETRY = NULL WHERE IDX = ?", requestIdx);
                            if (!needsRetry) continue;
                            SqlQuery.executeUpdate(this.backgroundConnection, "INSERT INTO YVII_REQUEST(YIDX, IDX) VALUES (GEN_ID(XYVII_REQUEST, 1), ?)", requestIdx);
                            continue;
                        }
                        if (needsUndo) {
                            boolean bl = needsUndo = !this.undoRequest(this.backgroundConnection, requestIdx, qry.getString("VOUCHER_NUMBER"), qry.getString("TRANSACTION_ID"), false);
                        }
                        if (needsUndo || !needsRetry) continue;
                        needsRetry = !this.retryTransaction(this.backgroundConnection, requestIdx, qry.getString("REQUEST_TYPE"), qry.getLong("VSHIDX"), qry.getString("RETRY_TEMPLATE"));
                    }
                    catch (SQLException ex) {
                        PosUtils.logError(ex);
                    }
                }
                return;
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
            return;
        }
    }

    private static boolean canRetry(Timestamp requestTime) {
        Date now = new Date();
        return requestTime.getTime() + 86400000L >= now.getTime();
    }

    private static void cleanUpInProgressRequests(Connection conn) {
        try (SqlQuery qry = new SqlQuery(conn, "SELECT R.IDX, COALESCE(H.COMPLETE, 0) AS HDR_CONFIRMED, COALESCE(D.\"ACTIVE\", 0) AS DET_CONFIRMED FROM VII_REQUEST R LEFT JOIN RET_TRANH H ON R.VHIDX = H.VHIDX LEFT JOIN RET_TRAND D ON R.VSHIDX = D.VSHIDX WHERE R.REQUEST_TYPE IN (?,?) AND R.IN_PROGRESS = 1 UNION ALL SELECT R.IDX, COALESCE(H.COMPLETE, 0) AS HDR_CONFIRMED, COALESCE(P.\"ACTIVE\", 0) AS DET_CONFIRMED FROM VII_REQUEST R LEFT JOIN RET_TRANH H ON R.VHIDX = H.VHIDX LEFT JOIN RET_TRANP P ON R.VSHIDX = P.VSHIDX WHERE R.REQUEST_TYPE = ? AND R.IN_PROGRESS = 1", REQUEST_TYPE_LOAD, REQUEST_TYPE_NEW, REQUEST_TYPE_REDEMPTION);){
            while (qry.next()) {
                if (qry.getBoolean("HDR_CONFIRMED") && qry.getBoolean("DET_CONFIRMED")) {
                    SqlQuery.executeUpdate(conn, "UPDATE VII_REQUEST SET IN_PROGRESS = NULL WHERE IDX = ?", qry.getString("IDX"));
                    continue;
                }
                SqlQuery.executeUpdate(conn, "UPDATE VII_REQUEST SET NEEDS_UNDO = CASE WHEN UNDONE_FLAG = 1 THEN NULL ELSE 1 END, NEEDS_RETRY = NULL, RETRY_TEMPLATE = NULL, IN_PROGRESS = NULL WHERE IDX = ?", qry.getString("IDX"));
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.retryLock;
        synchronized (object) {
            if (this.retryTimer != null) {
                this.retryTimer.cancel();
                this.retryTimer = null;
            }
            ViiGateway.closeConnection(this.mainConnection);
            this.mainConnection = null;
            ViiGateway.closeConnection(this.backgroundConnection);
            this.backgroundConnection = null;
        }
    }

    private static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static void checkResponse(Response response) throws ViiApiException {
        if ("0".equals(response.getResponseCode())) {
            return;
        }
        if (RESPONSE_CODE_INVALID_PIN.equals(response.getResponseCode())) {
            throw new ViiApiException(false, VoucherGatewayException.Type.INVALID_PIN);
        }
        if (RESPONSE_CODE_INVALID_NUMBER.equals(response.getResponseCode())) {
            throw new ViiApiException(false, VoucherGatewayException.Type.INVALID_NUMBER);
        }
        if (RESPONSE_CODE_INSUFFICIENT_FUNDS.equals(response.getResponseCode())) {
            throw new ViiApiException(false, VoucherGatewayException.Type.INSUFFICIENT_FUNDS);
        }
        throw new ViiApiException(false, "vii_fail_response", response.getResponseMessage());
    }

    public static GatewayVoucher.Status getCardStatus(String id) {
        switch (id) {
            case "0": {
                return GatewayVoucher.Status.NOT_ISSUED;
            }
            case "1": {
                return GatewayVoucher.Status.ACTIVE;
            }
            case "2": {
                return GatewayVoucher.Status.EXPIRED;
            }
            case "3": {
                return GatewayVoucher.Status.SUSPENDED;
            }
            case "4": {
                return GatewayVoucher.Status.CANCELLED;
            }
        }
        return GatewayVoucher.Status.UNKNOWN;
    }

    @Override
    public boolean hasDigitalVouchers() {
        return this._hasDigital;
    }
}

